## ----style, echo=FALSE, results="asis", message=FALSE--------------------
knitr::opts_chunk$set(tidy = FALSE,
		   message = FALSE)

## ----echo=FALSE, results="hide", message=FALSE---------------------------
library("ape")
library("Biostrings")
library("ggplot2")
library("ggtree")

## ----fig.width=8, fig.height=6, fig.align="center", warning=FALSE, message=FALSE----
beast_file <- system.file("examples/MCC_FluA_H3.tree", package="ggtree")
beast_tree <- read.beast(beast_file)

genotype_file <- system.file("examples/Genotype.txt", package="ggtree")
genotype <- read.table(genotype_file, sep="\t", stringsAsFactor=F)
colnames(genotype) <- sub("\\.$", "", colnames(genotype))
p <- ggtree(beast_tree, mrsd="2013-01-01") + geom_treescale(x=2008, y=1, offset=2)
p <- p + geom_tiplab(size=2)
gheatmap(p, genotype, offset = 5, width=0.5, font.size=3, colnames_angle=-45, hjust=0) +
    scale_fill_manual(breaks=c("HuH3N2", "pdm", "trig"), values=c("steelblue", "firebrick", "darkgreen"))

## ----fig.width=8, fig.height=6, fig.align="center", warning=FALSE--------
p <- ggtree(beast_tree, mrsd="2013-01-01") + geom_tiplab(size=2, align=TRUE, linesize=.5) + theme_tree2()
pp <- (p + scale_y_continuous(expand=c(0, 0.3))) %>%
    gheatmap(genotype, offset=8, width=0.6, colnames=FALSE) %>%
        scale_x_ggtree()
pp + theme(legend.position="right")

## ----fig.width=8, fig.height=6, fig.align='center', warning=FALSE--------
fasta <- system.file("examples/FluA_H3_AA.fas", package="ggtree")
msaplot(ggtree(beast_tree), fasta)

## ----fig.width=7, fig.height=7, fig.align='center', warning=FALSE--------
msaplot(ggtree(beast_tree), fasta, window=c(150, 200)) + coord_polar(theta='y')

## ------------------------------------------------------------------------
set.seed(2015-12-31)
tr <- rtree(15)
p <- ggtree(tr)

a <- runif(14, 0, 0.33)
b <- runif(14, 0, 0.33)
c <- runif(14, 0, 0.33)
d <- 1 - a - b - c
dat <- data.frame(a=a, b=b, c=c, d=d)
## input data should have a column of `node` that store the node number
dat$node <- 15+1:14

## cols parameter indicate which columns store stats (a, b, c and d in this example)
bars <- nodebar(dat, cols=1:4)

inset(p, bars)

## ------------------------------------------------------------------------
inset(p, bars, width=.06, height=.1)

## ------------------------------------------------------------------------
bars2 <- nodebar(dat, cols=1:4, position='dodge',
                 color=c(a='blue', b='red', c='green', d='cyan'))
p2 <- inset(p, bars2, x='branch', width=.06, vjust=-.3)
print(p2)

## ------------------------------------------------------------------------
pies <- nodepie(dat, cols=1:4, alpha=.6)
inset(p, pies)

## ------------------------------------------------------------------------
inset(p, pies, hjust=-.06)

## ------------------------------------------------------------------------
pies_and_bars <- bars2
pies_and_bars[9:14] <- pies[9:14]
inset(p, pies_and_bars)

## ------------------------------------------------------------------------
d <- lapply(1:15, rnorm, n=100)
ylim <- range(unlist(d))
bx <- lapply(d, function(y) {
    dd <- data.frame(y=y)
    ggplot(dd, aes(x=1, y=y))+geom_boxplot() + ylim(ylim) + theme_inset()
})
names(bx) <- 1:15
inset(p, bx, width=.06, height=.2, hjust=-.05)

## ----fig.width=10, fig.height=7------------------------------------------
p2 <- inset(p, bars2, x='branch', width=.06, vjust=-.4)
p2 <- inset(p2, pies, x='branch', vjust=.4)
bx2 <- lapply(bx, function(g) g+coord_flip())
inset(p2, bx2, width=.4, height=.06, vjust=.04, hjust=p2$data$x[1:15]-4) + xlim(NA, 4.5)

## ----eval=FALSE----------------------------------------------------------
#  imgfile <- tempfile(, fileext=".png")
#  download.file("https://avatars1.githubusercontent.com/u/626539?v=3&u=e731426406dd3f45a73d96dd604bc45ae2e7c36f&s=140", destfile=imgfile, mode='wb')
#  img <- list(imgfile, imgfile)
#  names(img) <- c("18", "22")
#  inset(p, img)

## ----warning=F, fig.width=10, fig.height=6-------------------------------
tr <- rtree(30)

d1 <- data.frame(id=tr$tip.label, val=rnorm(30, sd=3))
p <- ggtree(tr)

p2 <- facet_plot(p, panel="dot", data=d1, geom=geom_point, aes(x=val), color='firebrick')
d2 <- data.frame(id=tr$tip.label, value = abs(rnorm(30, mean=100, sd=50)))

facet_plot(p2, panel='bar', data=d2, geom=geom_segment, aes(x=0, xend=value, y=y, yend=y), size=3, color='steelblue') + theme_tree2()

## ----fig.width=5, fig.height=5, fig.align="center", warning=FALSE, eval=FALSE----
#  pp <- ggtree(tree) %>% phylopic("79ad5f09-cf21-4c89-8e7d-0c82a00ce728", color="steelblue", alpha = .3)
#  print(pp)

## ----fig.width=5, fig.height=5, fig.align="center", warning=FALSE, eval=FALSE----
#  pp %>% phylopic("67382184-5135-4faa-8e98-eadff02c3e8a", color="#86B875", alpha=.8, node=4) %>%
#       phylopic("d3563b54-780f-4711-a49a-7ea051e9dacc", color="darkcyan", alpha=.8, node=17, width=.2)

