/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.experiment.datamatrix;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;

public class MatrixCombiner {
    DataMatrix[] matrices;
    String[] newColumnTitles;
    String[] newRowTitles;
    HashMap columnTitleHash;
    HashMap rowTitleHash;

    public MatrixCombiner(DataMatrix[] matrices) {
        this.matrices = matrices;
        this.newColumnTitles = this.createNonRedundantTitleList("column");
        this.newRowTitles = this.createNonRedundantTitleList("row");
        this.columnTitleHash = this.createTitleHash(this.newColumnTitles);
        this.rowTitleHash = this.createTitleHash(this.newRowTitles);
    }

    public DataMatrix combine() {
        DataMatrix result = new DataMatrix();
        result.setSize(this.newRowTitles.length, this.newColumnTitles.length);
        result.setRowTitles(this.newRowTitles);
        result.setRowTitlesTitle(this.matrices[0].getRowTitlesTitle());
        result.setColumnTitles(this.newColumnTitles);
        result.setDefault(Double.NaN);
        result.setSpecies(this.matrices[0].getSpecies());
        for (int i = 0; i < this.matrices.length; ++i) {
            DataMatrix matrix = this.matrices[i];
            double[][] data = matrix.get();
            for (int row = 0; row < matrix.getRowCount(); ++row) {
                for (int column = 0; column < matrix.getColumnCount(); ++column) {
                    int[] indices = this.newIndices(matrix, row, column);
                    double value = data[row][column];
                    result.set(indices[0], indices[1], value);
                }
            }
        }
        return result;
    }

    protected int[] newIndices(DataMatrix matrix, int row, int column) {
        String originalMatrixRowName = matrix.getRowTitles()[row];
        String originalMatrixColumnName = matrix.getColumnTitles()[column];
        int targetMatrixRow = (Integer)this.rowTitleHash.get(originalMatrixRowName);
        int targetMatrixColumn = (Integer)this.columnTitleHash.get(originalMatrixColumnName);
        return new int[]{targetMatrixRow, targetMatrixColumn};
    }

    protected String[] createNonRedundantTitleList(String titleType) {
        HashSet<String> list = new HashSet<String>();
        for (int i = 0; i < this.matrices.length; ++i) {
            DataMatrix matrix = this.matrices[i];
            String[] titles = titleType.equals("row") ? matrix.getRowTitles() : matrix.getColumnTitles();
            for (int t = 0; t < titles.length; ++t) {
                String title = titles[t];
                list.add(title);
            }
        }
        Object[] result = list.toArray(new String[0]);
        Arrays.sort(result);
        return result;
    }

    public HashMap createTitleHash(String[] titleList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (int i = 0; i < titleList.length; ++i) {
            result.put(titleList[i], new Integer(i));
        }
        return result;
    }

    protected DataMatrix createEmptyMatrix(String[] columnTitles) {
        DataMatrix m = new DataMatrix();
        m.setSize(0, columnTitles.length);
        m.setColumnTitles(columnTitles);
        return m;
    }
}

