## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"---------------------------------
BiocStyle::latex()

## ----setup, include=FALSE, cache=FALSE--------------------------------------------------
library(knitr)
opts_chunk$set(out.width="0.7\\maxwidth",fig.align="center")

## ----load_bsgenome, message=FALSE-------------------------------------------------------
library(BSgenome.Hsapiens.UCSC.hg38)
genome <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38

## ----load_branchpointer, message=FALSE--------------------------------------------------
library(branchpointer)

## ----read_exon_gtf, message=FALSE, eval=FALSE-------------------------------------------
#  exons <- gtfToExons("gencode.v24.annotation.gtf")

## ----read_exon_small, message=FALSE-----------------------------------------------------
smallExons <- system.file("extdata","gencode.v24.annotation.small.gtf", 
                           package = "branchpointer")
exons <- gtfToExons(smallExons)

## ----read_introns, message=FALSE--------------------------------------------------------
queryIntron <- system.file("extdata","intron_example.txt", 
                            package = "branchpointer")
queryIntron <- readQueryFile(queryIntron,queryType = "region")

head(queryIntron)

## ----intron_loc, message=FALSE----------------------------------------------------------
queryIntron <- getQueryLoc(queryIntron,queryType = "region",exons = exons)
head(queryIntron)

## ----intron_loc_parallel, message=FALSE, eval=FALSE-------------------------------------
#  queryIntron <- getQueryLoc(queryIntron,queryType="region",
#                              exons = exons, useParallel=TRUE, cores=4)

## ----make_intron, message=FALSE---------------------------------------------------------
queryIntronMake <- makeRegions("ENSE00003541068", "exon_id", exons)
head(queryIntronMake)

#or for multiple ids
queryIntronMake <- lapply(c("ENSE00003541068", "ENSE00003461148"), 
                      makeRegions, "exon_id", exons)
                      
queryIntronMake <- do.call("c", queryIntronMake)

## ----predict_introns, message=FALSE-----------------------------------------------------
branchpointPredictionsIntron <- predictBranchpoints(queryIntron, queryType = "region", BSgenome = genome)

head(branchpointPredictionsIntron)

## ----brca2-plot-------------------------------------------------------------------------
plotBranchpointWindow(queryIntron$id[2], 
                      branchpointPredictionsIntron,
                      probabilityCutoff = 0.5,
                      plotMutated = FALSE,
                      plotStructure = TRUE,
                      exons = exons)

## ----read_snp, message=FALSE------------------------------------------------------------
querySNP <- system.file("extdata","SNP_example.txt", package = "branchpointer")
querySNP <- readQueryFile(querySNP,queryType="SNP")

## ----read_snp_mart, message=FALSE-------------------------------------------------------
library(biomaRt)
mart <- useMart("ENSEMBL_MART_SNP", dataset="hsapiens_snp",host="www.ensembl.org")
querySNP <- snpToQuery(c("rs17000647","rs5031002","rs998731"), mart.snp = mart)

## ----snp_loc, message=FALSE-------------------------------------------------------------
querySNP <- getQueryLoc(querySNP, queryType="SNP", exons = exons, filter = FALSE)
head(querySNP)

## ----snp_att_fa, message=FALSE, eval=FALSE----------------------------------------------
#  branchpointPredictionsSNP <- getBranchpointSequence(querySNP,
#                                          queryType = "SNP",
#                                          genome = "GRCh38.p5.genome.fa",
#                                          bedtoolsLocation="/Apps/bedtools2/bin/bedtools")

## ----snp_att_BS, message=FALSE----------------------------------------------------------
#for query SNPs
branchpointPredictionsSNP <- predictBranchpoints(querySNP,
                                        queryType = "SNP",
                                        BSgenome = genome)

#to summarise effects:
querySNP <- predictionsToStats(querySNP,branchpointPredictionsSNP)
head(querySNP)

## ----rs17000647-plot--------------------------------------------------------------------
plotBranchpointWindow(querySNP$id[1], 
                      branchpointPredictionsSNP,
                      probabilityCutoff = 0.5,plotMutated = TRUE,
                      plotStructure = TRUE,exons = exons)

## ----sessionInfo, eval=TRUE-------------------------------------------------------------
sessionInfo()

