tabItem(tabName = "elmeranalysis",
        fluidRow(
            column(8,  bsAlert("elmermessage"),
                   bsCollapse(id = "collapelmer", open = "Enhancer Linking by Methylation/Expression Relationship (ELMER) ",
                              bsCollapsePanel("Enhancer Linking by Methylation/Expression Relationship (ELMER) ",  includeHTML("elmer.html"), style = "default"))
            ),
            column(4,
                   box(title = "Analysis", width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = TRUE,collapsed = FALSE,
                       box(title = "Data", width = NULL,
                           solidHeader = TRUE, collapsible = TRUE,collapsed = TRUE,
                           box(title = "Create mee object", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE,collapsed = TRUE,
                               shinyFilesButton('elmermetfile', 'Select DNA methylation object', 'Please select DNA methylation object',
                                                multiple = FALSE),
                               bsTooltip("elmermetfile", "An R object (.rda) with a summarized experiment of DNA methylation from HM450K platform for multiple samples",
                                         "left"),
                               tags$br(),
                               tags$br(),
                               shinyFilesButton('elmerexpfile', 'Select expression object', 'Please select gene expression object',
                                                multiple = FALSE),
                               bsTooltip("elmerexpfile", "An R object (.rda) with a gene expression object for multiple samples",
                                         "left"),
                               tags$hr(),
                               selectizeInput('elmermeetype',
                                              "Group column",
                                              choices=NULL,
                                              multiple = FALSE),
                               bsTooltip("elmermeetype", "A columns from the DNA methylation SummarizedExperiment that contains the sample groups identification",
                                         "left"),
                               selectizeInput('elmermeesubtype',
                                              "Experiment group",
                                              choices=NULL,
                                              multiple = FALSE),
                               bsTooltip("elmermeesubtype", "Group to be compared with control group","left"),
                               selectizeInput('elmermeesubtype2',
                                              "Control group",
                                              choices=NULL,
                                              multiple = FALSE),
                               bsTooltip("elmermeesubtype2", "Group to be compared with experiment group","left"),
                               tags$hr(),

                               numericInput("elmermetnacut", "DNA methylation: Cut-off NA samples (%)",
                                            min = 0, max = 1, value = 0.2, step = 0.1),
                               bsTooltip("elmermetnacut", "By default, for the DNA methylation data will remove probes with NA values in more than 20% samples and remove the anottation data.",
                                         "left"),
                               textInput("meesavefilename", "Save as:", value = "mee.rda", width = NULL, placeholder = NULL),
                               actionButton("elmerpreparemee",
                                            "Create mee object",
                                            style = "background-color: #000080;
                                            color: #FFFFFF;
                                            margin-left: auto;
                                            margin-right: auto;
                                            width: 100%",
                                            icon = icon("floppy-o"))
                           ),
                           box(title = "Select mee object", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE,collapsed = TRUE,
                               shinyFilesButton('elmermeefile', 'Select mee', 'Please select mee object',
                                                multiple = FALSE),
                               bsTooltip("elmermeefile", "A .rda file with a mee object created in the `Create mee object` menu above .",
                                         "left")
                           ),
                           box(title = "Analysis parameters", width = NULL,
                               solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                               box(title = "Differently methylated probes", width = NULL,
                                   solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                                   checkboxInput("elmerhyperdir", "Hypermethylation direction ?", value = TRUE, width = NULL),
                                   bsTooltip("elmerhyperdir", "Select hypermethylated probes in experiment vs control",
                                             "left"),
                                   checkboxInput("elmerhypodir", "Hypomethylation direction ?", value = TRUE, width = NULL),
                                   bsTooltip("elmerhypodir", "Select hypomethylataded probes in experiment vs control",
                                             "left"),
                                   numericInput("elmermetdiff", " DNA methylation difference cutoff",
                                                min = 0, max = 1, value = 0.3, step = 0.05),
                                   bsTooltip("elmermetdiff", "Minimum mean level to consider probes as differently methylated",
                                             "left"),
                                   numericInput("elmermetpercentage", " percentage",
                                                min = 0, max = 1, value = 0.2, step = 0.01),
                                   bsTooltip("elmermetpercentage", "Percentage of samples to be used from each group for the comparison.",
                                             "left"),
                                   numericInput("elmermetpvalue", " pvalue",
                                                min = 0, max = 1, value = 0.01, step = 0.01),
                                   bsTooltip("elmermetpvalue", "Maximum pvalue to consider  differently methylated probe significant",
                                             "left")
                               ),
                               box(title = "Predict enhancer-gene linkages", width = NULL,
                                   solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                                   numericInput("elmergetpairNumGenes", " Nearby genes",
                                                min = 1, max = 100, value = 20, step = 1),
                                   bsTooltip("elmergetpairNumGenes", "For each differently methylated probe how many nearby genes will be verified ? (default:20, 10 downstream and 10 upstream)",
                                             "left"),
                                   numericInput("elmergetpairpercentage", " percentage",
                                                min = 0, max = 1, value = 0.2, step = 0.01),
                                   numericInput("elmergetpairpermu", " Number of permutations",
                                                min = 0, max = 10000, value = 10000, step = 1000),
                                   bsTooltip("elmergetpairpermu", "For each probe-gene pair tested, the raw p-value Pr was corrected for multiple hypothesis using a permutation approach. The greater the permutation time is, the longer it will take.",
                                             "left"),
                                   numericInput("elmergetpairpvalue", "Pvalue",
                                                min = 0, max = 1, value = 0.01, step = 0.01),
                                   bsTooltip("elmergetpairpermu", "Maximum  empirical P value to consider pair significant",
                                             "left"),
                                   numericInput("elmergetpairportion", "Portion",
                                                min = 0, max = 1, value = 0.3, step = 0.1),
                                   bsTooltip("elmergetpairportion", "We usually call locus unmethylated when the methylation value < 0.3 and methylated when the methylation value > 0.3. Make sure we have at least 5% percentage of beta values lesser than 0.3",
                                             "left"),
                                   checkboxInput("elmergetpairdiffExp", "Test whether putative target gene are differentially expressed ?", value = FALSE, width = NULL),
                                   bsTooltip("elmergetpairdiffExp", "t test will be applied to  test whether putative target gene are differentially expressed between two groups",
                                             "left")
                               ),
                               box(title = "Get enriched motif", width = NULL,
                                   solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                                   numericInput("elmergetenrichedmotifMinIncidence", "Minimum incidence",
                                                min = 0, max = 100, value = 10, step = 1),
                                   bsTooltip("elmergetenrichedmotifMinIncidence", "Minimum number of probes (from pair gene-probe found before) a motif has to have to be considered enriched.",
                                             "left"),
                                   numericInput("elmergetenrichedmotifLoweOR", "Lower boundary cut-off",
                                                min = 0, max = 5, value = 1.1, step = 0.1)
                               ),
                               box(title = "Identify regulatory TFs", width = NULL,
                                   solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                                   numericInput("elmergetTFpercentage", "Percentage",
                                                min = 0, max = 1, value = 0.2, step = 0.01),
                                   bsTooltip("elmergetenrichedmotifMinIncidence", "Percentage of samples used to compare methylated vs unmethylated group.",
                                             "left")
                               )
                           )
                       ),
                       box(title = "Other options", width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           sliderInput("elmercores", "Cores", step=1,
                                       min = 1, max = parallel::detectCores(), value = 1),
                           textInput("elmerresultssavefolder", "Name of the results folder:", value = "results_elmer", width = NULL, placeholder = NULL)
                       ),
                       actionButton("elmerAnalysisBt",
                                    "Run analysis",
                                    style = "background-color: #000080;
                                    color: #FFFFFF;
                                    margin-left: auto;
                                    margin-right: auto;
                                    width: 100%",
                                    icon = icon("flask"))
                   )
            )
        )
)
