### R code from vignette source 'SwathXtend_vignette.Rnw'

###################################################
### code chunk number 1: SwathXtend_vignette.Rnw:51-53 (eval = FALSE)
###################################################
## source("http://www.bioconductor.org/biocLite.R")
## biocLite("SwathXtend")


###################################################
### code chunk number 2: 1
###################################################
rm(list=ls())
library(SwathXtend)


###################################################
### code chunk number 3: 2
###################################################
filenames <- c("Lib2.txt", "Lib3.txt") 
libfiles <- paste(system.file("files",package="SwathXtend"),filenames,sep="/")
Lib2 <- readLibFile(libfiles[1], clean=TRUE)
Lib3 <- readLibFile(libfiles[2], clean=TRUE)


###################################################
### code chunk number 4: SwathXtend_vignette.Rnw:90-92 (eval = FALSE)
###################################################
## Lib2 <- cleanLib(Lib2, intensity.cutoff = 5, conf.cutoff = 0.99, nomod = FALSE, nomc = FALSE)
## Lib3 <- cleanLib(Lib3, intensity.cutoff = 5, conf.cutoff = 0.99, nomod = FALSE, nomc = FALSE)


###################################################
### code chunk number 5: 3
###################################################
checkQuality(Lib2, Lib3)


###################################################
### code chunk number 6: SwathXtend_vignette.Rnw:114-115
###################################################
plotRTCor(Lib2, Lib3, "Lib2", "Lib3")


###################################################
### code chunk number 7: SwathXtend_vignette.Rnw:118-119
###################################################
plotRTResd(Lib2, Lib3)


###################################################
### code chunk number 8: SwathXtend_vignette.Rnw:122-123
###################################################
plotRIICor(Lib2, Lib3)


###################################################
### code chunk number 9: c (eval = FALSE)
###################################################
## plotAll(Lib2, Lib3, file="allplots.xlsx")


###################################################
### code chunk number 10: 4 (eval = FALSE)
###################################################
## 
## Lib2_3 <- buildSpectraLibPair(libfiles[2], libfiles[3], clean=T, 
## 				nomc=T, nomod=T, plot=F, 
## 				outputFormat = "PeakView",
## 				outputFile = "Lib2_3.txt")	
## 


###################################################
### code chunk number 11: SwathXtend_vignette.Rnw:153-156
###################################################
hydroFile <- paste(system.file("files",package="SwathXtend"),"hydroIndex.txt",sep="/")
hydro <- readLibFile(hydroFile, type="hydro")
head(hydro)					


###################################################
### code chunk number 12: SwathXtend_vignette.Rnw:162-167 (eval = FALSE)
###################################################
## Lib2_3 <- buildSpectraLibPair(libfiles[2], libfiles[3], clean=T, 
## 				nomc=T, nomod=T, plot=F, 
## 				method="hydro",
## 				outputFormat = "PeakView",
## 				outputFile = "Lib2_3.txt")	


###################################################
### code chunk number 13: SwathXtend_vignette.Rnw:173-174 (eval = FALSE)
###################################################
## outputLib(Lib2_3, filename="Lib2_3.txt", format="openswath")


