/*
 * Decompiled with CFR 0.152.
 */
package reder.application.cluster;

import reder.application.cluster.Centroid;
import reder.application.cluster.Cluster;

public class DataPoint {
    private double mX;
    private double mY;
    private String mObjName;
    private Cluster mCluster;
    private double mEuDt;

    public DataPoint(double x, double y, String name) {
        this.mX = x;
        this.mY = y;
        this.mObjName = name;
        this.mCluster = null;
    }

    public void setCluster(Cluster cluster) {
        this.mCluster = cluster;
        this.calcEuclideanDistance();
    }

    public void calcEuclideanDistance() {
        this.mEuDt = Math.sqrt(Math.pow(this.mX - this.mCluster.getCentroid().getCx(), 2.0) + Math.pow(this.mY - this.mCluster.getCentroid().getCy(), 2.0));
    }

    public double testEuclideanDistance(Centroid c) {
        return Math.sqrt(Math.pow(this.mX - c.getCx(), 2.0) + Math.pow(this.mY - c.getCy(), 2.0));
    }

    public double getX() {
        return this.mX;
    }

    public double getY() {
        return this.mY;
    }

    public Cluster getCluster() {
        return this.mCluster;
    }

    public double getCurrentEuDt() {
        return this.mEuDt;
    }

    public String getObjName() {
        return this.mObjName;
    }
}

