/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.view;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;

public class mxSwimlaneManager
extends mxEventSource {
    protected mxGraph graph;
    protected boolean enabled;
    protected boolean horizontal;
    protected boolean siblings;
    protected boolean bubbling;
    protected mxEventSource.mxIEventListener addHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (mxSwimlaneManager.this.isEnabled()) {
                mxSwimlaneManager.this.cellsAdded((Object[])mxEventObject2.getProperty("cells"));
            }
        }
    };
    protected mxEventSource.mxIEventListener resizeHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            if (mxSwimlaneManager.this.isEnabled()) {
                mxSwimlaneManager.this.cellsResized((Object[])mxEventObject2.getProperty("cells"));
            }
        }
    };

    public mxSwimlaneManager(mxGraph mxGraph2) {
        this.setGraph(mxGraph2);
    }

    public boolean isSwimlaneIgnored(Object object) {
        return !this.getGraph().isSwimlane(object);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public boolean isSiblings() {
        return this.siblings;
    }

    public void setSiblings(boolean bl) {
        this.siblings = bl;
    }

    public boolean isBubbling() {
        return this.bubbling;
    }

    public void setBubbling(boolean bl) {
        this.bubbling = bl;
    }

    public mxGraph getGraph() {
        return this.graph;
    }

    public void setGraph(mxGraph mxGraph2) {
        if (this.graph != null) {
            this.graph.removeListener(this.addHandler);
            this.graph.removeListener(this.resizeHandler);
        }
        this.graph = mxGraph2;
        if (this.graph != null) {
            this.graph.addListener("addCells", this.addHandler);
            this.graph.addListener("cellsResized", this.resizeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellsAdded(Object[] objectArray) {
        if (objectArray != null) {
            mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
            mxIGraphModel2.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isSwimlaneIgnored(objectArray[i])) continue;
                    this.swimlaneAdded(objectArray[i]);
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swimlaneAdded(Object object) {
        mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
        mxRectangle mxRectangle2 = null;
        Object object2 = mxIGraphModel2.getParent(object);
        int n = mxIGraphModel2.getChildCount(object2);
        for (int i = 0; i < n; ++i) {
            Object object3 = mxIGraphModel2.getChildAt(object2, i);
            if (object3 == object || this.isSwimlaneIgnored(object3)) continue;
            mxRectangle2 = mxIGraphModel2.getGeometry(object3);
            break;
        }
        if (mxRectangle2 != null) {
            mxIGraphModel2.beginUpdate();
            try {
                this.resizeSwimlane(object, mxRectangle2.getWidth(), mxRectangle2.getHeight());
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cellsResized(Object[] objectArray) {
        if (objectArray != null) {
            mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
            mxIGraphModel2.beginUpdate();
            try {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.isSwimlaneIgnored(objectArray[i])) continue;
                    this.swimlaneResized(objectArray[i]);
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swimlaneResized(Object object) {
        mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 != null) {
            double d = mxGeometry2.getWidth();
            double d2 = mxGeometry2.getHeight();
            mxIGraphModel2.beginUpdate();
            try {
                Object object2 = mxIGraphModel2.getParent(object);
                if (this.isSiblings()) {
                    int n = mxIGraphModel2.getChildCount(object2);
                    for (int i = 0; i < n; ++i) {
                        Object object3 = mxIGraphModel2.getChildAt(object2, i);
                        if (object3 == object || this.isSwimlaneIgnored(object3)) continue;
                        this.resizeSwimlane(object3, d, d2);
                    }
                }
                if (this.isBubbling() && !this.isSwimlaneIgnored(object2)) {
                    this.resizeParent(object2, d, d2);
                    this.swimlaneResized(object2);
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    protected void resizeSwimlane(Object object, double d, double d2) {
        mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 != null) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            if (this.isHorizontal()) {
                mxGeometry2.setWidth(d);
            } else {
                mxGeometry2.setHeight(d2);
            }
            mxIGraphModel2.setGeometry(object, mxGeometry2);
        }
    }

    protected void resizeParent(Object object, double d, double d2) {
        mxIGraphModel mxIGraphModel2 = this.getGraph().getModel();
        mxGeometry mxGeometry2 = mxIGraphModel2.getGeometry(object);
        if (mxGeometry2 != null) {
            mxGeometry2 = (mxGeometry)mxGeometry2.clone();
            mxRectangle mxRectangle2 = this.graph.getStartSize(object);
            if (this.isHorizontal()) {
                mxGeometry2.setWidth(d + mxRectangle2.getWidth());
            } else {
                mxGeometry2.setHeight(d2 + mxRectangle2.getHeight());
            }
            mxIGraphModel2.setGeometry(object, mxGeometry2);
        }
    }

    public void destroy() {
        this.setGraph(null);
    }
}

