## ---- echo = FALSE---------------------------------------------------------
suppressPackageStartupMessages({
    library(RaggedExperiment)
    library(GenomicRanges)
})

## ---- eval = FALSE---------------------------------------------------------
#  source("https://bioconductor.org/biocLite.R")
#  BiocInstaller::biocLite("RaggedExperiment")

## ---- eval = FALSE---------------------------------------------------------
#  library(RaggedExperiment)

## --------------------------------------------------------------------------
sample1 <- GRanges(
    c(GENEA = "chr1:1-10:-", GENEB = "chr2:15-18:+"),
    score = 3:4)
sample2 <- GRanges(
    c(GENEC = "chr1:1-10:-", GENED = "chr2:11-18:+"),
    score = 1:2)

## --------------------------------------------------------------------------
colDat <- DataFrame(id = 1:2)

## --------------------------------------------------------------------------
ragexp <- RaggedExperiment(sample1 = sample1,
                           sample2 = sample2,
                           colData = colDat)
ragexp

## --------------------------------------------------------------------------
grl <- GRangesList(sample1 = sample1, sample2 = sample2)
RaggedExperiment(grl, colData = colDat)

## --------------------------------------------------------------------------
rangeList <- list(sample1 = sample1, sample2 = sample2)
RaggedExperiment(rangeList, colData = colDat)

## --------------------------------------------------------------------------
grList <- List(sample1 = sample1, sample2 = sample2)
mcols(grList) <- colDat
RaggedExperiment(grList)

## --------------------------------------------------------------------------
rowRanges(ragexp)

## --------------------------------------------------------------------------
dimnames(ragexp)

## --------------------------------------------------------------------------
colData(ragexp)

## --------------------------------------------------------------------------
dim(ragexp)
Reduce(`*`, dim(ragexp))
sparseAssay(ragexp)
length(sparseAssay(ragexp))

## --------------------------------------------------------------------------
compactAssay(ragexp)

## --------------------------------------------------------------------------
disjoinAssay(ragexp, simplify = mean)

## --------------------------------------------------------------------------
weightedmean <- function(scores, ranges, qranges)
    sum(scores * width(ranges)) / sum(width(ranges))

## --------------------------------------------------------------------------
qreduceAssay(ragexp,
             query = GRanges(c("chr1:1-10:-", "chr2:11-18:+")), 
             simplify = weightedmean)

## --------------------------------------------------------------------------
sessionInfo()

