## ----example_data, eval=TRUE---------------------------------------------
library(PathoStat)
example_data_dir <- system.file("example/data", package = "PathoStat")

## ----create_pathostat, eval=TRUE-----------------------------------------
pstat <- createPathoStat(input_dir=example_data_dir, 
    sample_data_file="sample_data.tsv")

## ----create_pathostat_from_biom, eval=TRUE-------------------------------
library(phyloseq)
rich_dense_biom  = system.file("extdata", "rich_dense_otu_table.biom", 
    package="phyloseq")
phyob <- import_biom(rich_dense_biom)

#and finally, we convert the phyloseq object into a pstat object
pstat_biom <- pathostat(phyob)

## ----save_load_pathostat, eval=FALSE-------------------------------------
#  # Saving data
#  savePstat(pstat, outdir=".", outfileName="pstat_data.rda")
#  # Loading data
#  pstat <- loadPstat(indir=".", infileName="pstat_data.rda")
#  # Calling the runPathoStat() function to execute Pathostat interactively
#  runPathoStat(pstat)

## ----coreOTU, eval=FALSE-------------------------------------------------
#  #create a UI calling coreOTUModuleUI() function
#  shinyUI(mainPanel(
#      coreOTUModuleUI("coreOTUModule")
#  ))
#  
#  #and a server
#  shinyServer(function(input, output) {
#      callModule( coreOTUModule, "coreOTUModule", pstat )
#  })

## ----taxon_abundance, eval=TRUE------------------------------------------
#first, get the otu_table from pstat calling a phyloseq function
library(phyloseq)
otut<-otu_table(pstat)
ffc<-findRAfromCount(otut)
#lets see, for example, the abundances for sample 01 on the ffc object
head(ffc[,1], n = 15)

## ----taxon_matrix, eval=TRUE---------------------------------------------
dat <- ffc
ids <- rownames(dat)
tids <- unlist(lapply(ids, FUN = grepTid))
taxonLevels <- findTaxonomy(tids[1:4])
taxmat <- findTaxonMat(ids[1:4], taxonLevels)
taxmat

## ----plot_confidence_region, eval=TRUE-----------------------------------
#select taxon 1 and 2, from your samples (randomly in this case)
n<-nrow(as.matrix(rownames(otut)))
m<-nrow(as.matrix(colnames(otut)))

p1 <- otut[rownames(otut)[ sample(1:n, 1)], 
    colnames(otut)[sample(1:m, 1)]]
if (p1 <= 0) p1 <- 1

#random taxon for p2 in this case again
n<-nrow(as.matrix(rownames(otut)))
m<-nrow(as.matrix(colnames(otut)))
p2 <- otut[rownames(otut)[ sample(1:n, 1)], 
    colnames(otut)[sample(1:m, 1)]]
if (p2 <= 0) p2 <- 1
size <- sum(otut[,colnames(otut)])
plotConfRegion(p1, p2, size, uselogit=FALSE)

## ----log2cpm, eval=TRUE--------------------------------------------------
# Only to sample one:
lcpm <- log2CPM(otut[,1])
lcpm

## ----plot_heatmap, eval=TRUE,warning=FALSE-------------------------------
#select a tax level for the heatmap plot
taxonLevel<-"class"
physeq <- tax_glom(pstat,taxonLevel)
plot_heatmap(physeq, taxa.label=taxonLevel)

