/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.dialogs.JavaMemoryDialog;
import com.compomics.software.dialogs.JavaMemoryDialogParent;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import no.uib.jsparklines.renderers.util.Util;

public class JavaSettingsDialog
extends JDialog {
    private JavaMemoryDialogParent javaMemoryDialogParent;
    private JFrame frameParent;
    private String toolName;
    private JDialog welcomeDialog;
    private JPanel backgroundsPanel;
    private JLabel bitLabel;
    private JPanel bitPanel;
    private JLabel bitRecommendationLabel;
    private JLabel editMemoryJLabel;
    private JLabel javaHelpJLabel;
    private JLabel javaHomeLabel;
    private JPanel javaHomePanel;
    private JLabel memoryLabel;
    private JPanel memoryPanel;
    private JLabel memoryRecommendationLabel;
    private JButton okButton;
    private JLabel versionLabel;
    private JPanel versionPanel;
    private JLabel versionRecommendationLabel;

    public JavaSettingsDialog(JFrame parent, JavaMemoryDialogParent javaMemoryDialogParent, JDialog welcomeDialog, String toolName, boolean modal) {
        super((Frame)parent, modal);
        this.frameParent = parent;
        this.javaMemoryDialogParent = javaMemoryDialogParent;
        this.welcomeDialog = welcomeDialog;
        this.toolName = toolName;
        this.initComponents();
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() {
        String javaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator;
        this.javaHomeLabel.setText(javaHome);
        String javaVersion = System.getProperty("java.version");
        this.versionLabel.setText(javaVersion);
        if (javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6")) {
            this.versionLabel.setForeground(Color.red);
        }
        if (CompomicsWrapper.is64BitJava()) {
            this.bitLabel.setText("64 Bit Java");
        } else {
            this.bitLabel.setText("32 Bit Java");
            this.bitLabel.setForeground(Color.red);
        }
        try {
            UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
            int maxMemory = utilitiesUserPreferences.getMemoryPreference();
            this.memoryLabel.setText(Util.roundDouble((double)((double)maxMemory * 9.76563E-4), (int)1) + " GB");
            if (maxMemory < 4000) {
                this.memoryLabel.setForeground(Color.red);
            }
        }
        catch (Exception e) {
            this.memoryLabel.setText("Error...");
            e.printStackTrace();
        }
    }

    private void initComponents() {
        this.backgroundsPanel = new JPanel();
        this.javaHomePanel = new JPanel();
        this.javaHomeLabel = new JLabel();
        this.bitPanel = new JPanel();
        this.bitLabel = new JLabel();
        this.bitRecommendationLabel = new JLabel();
        this.memoryPanel = new JPanel();
        this.memoryLabel = new JLabel();
        this.memoryRecommendationLabel = new JLabel();
        this.editMemoryJLabel = new JLabel();
        this.okButton = new JButton();
        this.javaHelpJLabel = new JLabel();
        this.versionPanel = new JPanel();
        this.versionLabel = new JLabel();
        this.versionRecommendationLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Java Settings");
        this.setResizable(false);
        this.backgroundsPanel.setBackground(new Color(230, 230, 230));
        this.javaHomePanel.setBorder(BorderFactory.createTitledBorder("Java Home"));
        this.javaHomePanel.setOpaque(false);
        this.javaHomeLabel.setText("Java Home...");
        GroupLayout javaHomePanelLayout = new GroupLayout(this.javaHomePanel);
        this.javaHomePanel.setLayout(javaHomePanelLayout);
        javaHomePanelLayout.setHorizontalGroup(javaHomePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(javaHomePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.javaHomeLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        javaHomePanelLayout.setVerticalGroup(javaHomePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(javaHomePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.javaHomeLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.bitPanel.setBorder(BorderFactory.createTitledBorder("32 Bit or 64 Bit"));
        this.bitPanel.setOpaque(false);
        this.bitLabel.setText("64 Bit Java");
        this.bitRecommendationLabel.setFont(this.bitRecommendationLabel.getFont().deriveFont(this.bitRecommendationLabel.getFont().getStyle() | 2));
        this.bitRecommendationLabel.setText("Recommended: 64 Bit Java");
        GroupLayout bitPanelLayout = new GroupLayout(this.bitPanel);
        this.bitPanel.setLayout(bitPanelLayout);
        bitPanelLayout.setHorizontalGroup(bitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bitPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bitLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bitRecommendationLabel).addContainerGap()));
        bitPanelLayout.setVerticalGroup(bitPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bitPanelLayout.createSequentialGroup().addContainerGap().addGroup(bitPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bitLabel).addComponent(this.bitRecommendationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.memoryPanel.setBorder(BorderFactory.createTitledBorder("Memory"));
        this.memoryPanel.setOpaque(false);
        this.memoryLabel.setText("60 GB");
        this.memoryRecommendationLabel.setFont(this.memoryRecommendationLabel.getFont().deriveFont(this.memoryRecommendationLabel.getFont().getStyle() | 2));
        this.memoryRecommendationLabel.setText("Recommended: at least 4 GB");
        this.editMemoryJLabel.setForeground(new Color(0, 0, 255));
        this.editMemoryJLabel.setText("<html><u>Edit</u></html>");
        this.editMemoryJLabel.setToolTipText("Open Java Help");
        this.editMemoryJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JavaSettingsDialog.this.editMemoryJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JavaSettingsDialog.this.editMemoryJLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JavaSettingsDialog.this.editMemoryJLabelMouseReleased(evt);
            }
        });
        GroupLayout memoryPanelLayout = new GroupLayout(this.memoryPanel);
        this.memoryPanel.setLayout(memoryPanelLayout);
        memoryPanelLayout.setHorizontalGroup(memoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(memoryPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.memoryLabel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.editMemoryJLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 363, Short.MAX_VALUE).addComponent(this.memoryRecommendationLabel).addContainerGap()));
        memoryPanelLayout.setVerticalGroup(memoryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(memoryPanelLayout.createSequentialGroup().addContainerGap().addGroup(memoryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.memoryLabel).addComponent(this.memoryRecommendationLabel).addComponent(this.editMemoryJLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.javaHelpJLabel.setForeground(new Color(0, 0, 255));
        this.javaHelpJLabel.setText("<html><u><i>Java setup help</i></u></html>");
        this.javaHelpJLabel.setToolTipText("Open Java Help");
        this.javaHelpJLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JavaSettingsDialog.this.javaHelpJLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JavaSettingsDialog.this.javaHelpJLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JavaSettingsDialog.this.javaHelpJLabelMouseReleased(evt);
            }
        });
        this.versionPanel.setBorder(BorderFactory.createTitledBorder("Java Version"));
        this.versionPanel.setOpaque(false);
        this.versionLabel.setText("1.7");
        this.versionRecommendationLabel.setFont(this.versionRecommendationLabel.getFont().deriveFont(this.versionRecommendationLabel.getFont().getStyle() | 2));
        this.versionRecommendationLabel.setText("Recommended: Java 1.7 or newer");
        GroupLayout versionPanelLayout = new GroupLayout(this.versionPanel);
        this.versionPanel.setLayout(versionPanelLayout);
        versionPanelLayout.setHorizontalGroup(versionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(versionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.versionLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.versionRecommendationLabel).addContainerGap()));
        versionPanelLayout.setVerticalGroup(versionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(versionPanelLayout.createSequentialGroup().addContainerGap().addGroup(versionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.versionRecommendationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundsPanelLayout = new GroupLayout(this.backgroundsPanel);
        this.backgroundsPanel.setLayout(backgroundsPanelLayout);
        backgroundsPanelLayout.setHorizontalGroup(backgroundsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundsPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaHomePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.memoryPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundsPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.javaHelpJLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton)).addComponent(this.bitPanel, -1, -1, Short.MAX_VALUE).addComponent(this.versionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundsPanelLayout.setVerticalGroup(backgroundsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.javaHomePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bitPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memoryPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.javaHelpJLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundsPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundsPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void javaHelpJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void javaHelpJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void javaHelpJLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://code.google.com/p/compomics-utilities/wiki/JavaTroubleShooting");
        this.setCursor(new Cursor(0));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void editMemoryJLabelMouseReleased(MouseEvent evt) {
        new JavaMemoryDialog(this.frameParent, this.javaMemoryDialogParent, this.welcomeDialog, this.toolName);
    }

    private void editMemoryJLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void editMemoryJLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }
}

