/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.research.script;

import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.ProteinID;
import com.compomics.mascotdatfile.util.mascot.Query;
import com.compomics.mascotdatfile.util.mascot.enumeration.MascotDatfileType;
import com.compomics.mascotdatfile.util.mascot.factory.MascotDatfileFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExampleWiki1 {
    public ExampleWiki1(String aFileName) {
        String file = aFileName;
        char separator = ',';
        MascotDatfileInf iMascotDatfile = null;
        System.out.println("Processing " + file);
        iMascotDatfile = MascotDatfileFactory.create(file, MascotDatfileType.INDEX);
        QueryToPeptideMapInf lQueryToPeptideMap = iMascotDatfile.getQueryToPeptideMap();
        ArrayList<Object> list = null;
        List<PeptideHit> lBestPeptideHits = lQueryToPeptideMap.getAllPeptideHitsAboveIdentityThreshold();
        Iterator iter = iMascotDatfile.getProteinMap().getProteinIDIterator();
        ProteinID lProteinID = null;
        while (iter.hasNext()) {
            String item = "";
            String lAccession = iter.next().toString();
            lProteinID = iMascotDatfile.getProteinMap().getProteinID(lAccession);
            item = "PROTEIN" + separator + lAccession + separator + lProteinID.getQueryNumbers().length + separator + lProteinID.getDescription();
            System.out.println(item);
        }
        for (int j = 0; j < lBestPeptideHits.size(); ++j) {
            PeptideHit lPeptideHit = lBestPeptideHits.get(j);
            if (lPeptideHit == null) continue;
            ArrayList lProteins = lPeptideHit.getProteinHits();
            for (int k = 0; k < lProteins.size(); ++k) {
                list = new ArrayList<Object>();
                ProteinHit lProteinHit = (ProteinHit)lProteins.get(k);
                String lAccession = lProteinHit.getAccession();
                list.add(lAccession);
                list.add("PEPTIDE");
                list.add(((Query)iMascotDatfile.getQueryList().get(j)).getFilename());
                list.add(lPeptideHit.getModifiedSequence());
                list.add(lPeptideHit.getIonsScore());
                list.add(lPeptideHit.calculateIdentityThreshold(0.05));
                String lResult = "";
                for (Object e : list) {
                    lResult = lResult + e + separator;
                }
                System.out.println(lResult);
            }
        }
        iMascotDatfile.finish();
    }

    public static void main(String[] args) {
        URL url = ClassLoader.class.getResource("/F004071.dat");
        new ExampleWiki1(url.getPath());
    }
}

