/*
 * Decompiled with CFR 0.152.
 */
package cn.bgi;

import cn.bgi.FDRcalculator;
import cn.bgi.FastaReader;
import cn.bgi.ProteinGroup;
import cn.bgi.PsmPool;
import cn.bgi.Spectra;
import com.compomics.mascotdatfile.util.interfaces.FragmentIon;
import com.compomics.mascotdatfile.util.interfaces.MascotDatfileInf;
import com.compomics.mascotdatfile.util.interfaces.QueryToPeptideMapInf;
import com.compomics.mascotdatfile.util.mascot.MascotDatfile;
import com.compomics.mascotdatfile.util.mascot.PeptideHit;
import com.compomics.mascotdatfile.util.mascot.PeptideHitAnnotation;
import com.compomics.mascotdatfile.util.mascot.ProteinHit;
import com.compomics.mascotdatfile.util.mascot.Query;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MascotParser {
    public static boolean reMap = true;

    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        String xmlfile = args[0];
        String fasta = args[1];
        String projname = args[2];
        String outdir = args[3];
        String decoyString = args[4];
        String sapPrefixString = args[5];
        reMap = !args[6].startsWith("0");
        FastaReader.setCpu(Integer.valueOf(args[7]));
        MascotParser.run(xmlfile, fasta, projname, outdir, decoyString, sapPrefixString);
    }

    public static void run(String dat, String fasta, String projname, String outdir, String decoyString, String sapPrefixString) throws IOException, SAXException, ParserConfigurationException, InterruptedException, ExecutionException {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(dateformat.format(new Date()));
        if (reMap) {
            System.out.println("You set to re-map the peptide to protein!");
        }
        System.out.println("Process file: " + dat + "...");
        File cdir = new File(outdir);
        if (!cdir.isDirectory()) {
            cdir.mkdirs();
        }
        MascotDatfile iMascotDatfile = null;
        iMascotDatfile = new MascotDatfile(dat);
        QueryToPeptideMapInf lQueryToPeptideMap = iMascotDatfile.getQueryToPeptideMap();
        Vector lQueryList = iMascotDatfile.getQueryList();
        String pepfile = String.valueOf(outdir) + "/" + projname + "-rawPSMs.txt";
        BufferedWriter pepfilebw = new BufferedWriter(new FileWriter(new File(pepfile)));
        pepfilebw.write("index\tevalue\tcharge\tmass\tmz\tdelta_da\tdelta_ppm\tpeptide\tisdecoy\tmiss\tprotein\trt\tmods\tisSap\tposition\n");
        PsmPool psmPool = new PsmPool();
        System.out.println("Total query: " + lQueryList.size());
        int j = 0;
        while (j < lQueryList.size()) {
            Query lQuery = (Query)lQueryList.get(j);
            Integer queryNum = lQuery.getQueryNumber();
            int rank = 1;
            PeptideHit lPeptideHit = lQueryToPeptideMap.getPeptideHitOfOneQuery(queryNum, rank);
            if (lPeptideHit != null && lPeptideHit.getSequence().length() > 5) {
                StringBuilder pepPosInProString = new StringBuilder();
                StringBuilder accStringBuilder = new StringBuilder();
                boolean isSAP = true;
                boolean isDecoy = false;
                ArrayList accArrayList = lPeptideHit.getProteinHits();
                int k = 0;
                while (k < accArrayList.size()) {
                    ProteinHit ph = (ProteinHit)accArrayList.get(k);
                    int pstart = ph.getStart();
                    int pend = ph.getStop();
                    String accTmp = ph.getAccession().split("\\s")[0];
                    if (accTmp.startsWith(decoyString)) {
                        isDecoy = true;
                    }
                    if (!accTmp.startsWith(sapPrefixString)) {
                        isSAP = false;
                    }
                    if (k == 0) {
                        pepPosInProString.append(String.valueOf(pstart) + ":" + pend);
                        accStringBuilder.append(accTmp);
                    } else {
                        pepPosInProString.append(";" + pstart + ":" + pend);
                        accStringBuilder.append(";");
                        accStringBuilder.append(accTmp);
                    }
                    ++k;
                }
                String modSites = "-";
                if (lPeptideHit.getModifications() != null) {
                    modSites = lPeptideHit.getModifiedSequence();
                }
                Spectra psm = new Spectra(String.valueOf(queryNum));
                StringBuilder pepoutBuilder = new StringBuilder();
                pepoutBuilder.append(queryNum + "\t");
                pepoutBuilder.append(String.valueOf(lPeptideHit.getExpectancy()) + "\t");
                psm.setScore(lPeptideHit.getExpectancy());
                String charge = lQuery.getChargeString();
                charge = charge.replace("+", "");
                pepoutBuilder.append(String.valueOf(charge) + "\t");
                psm.setCharge(Integer.valueOf(charge));
                double precmass = lPeptideHit.getPeptideMr();
                pepoutBuilder.append(String.valueOf(precmass) + "\t");
                psm.setParentmass(precmass);
                double mz = lQuery.getPrecursorMZ();
                pepoutBuilder.append(String.valueOf(mz) + "\t");
                psm.setMz(mz);
                pepoutBuilder.append(String.valueOf(lPeptideHit.getDeltaMass()) + "\t");
                psm.setDelta_da(lPeptideHit.getDeltaMass());
                double ppm = lPeptideHit.getDeltaMass() / precmass * 1000000.0;
                pepoutBuilder.append(String.valueOf(ppm) + "\t");
                psm.setDelta_ppm(ppm);
                pepoutBuilder.append(String.valueOf(lPeptideHit.getSequence()) + "\t");
                psm.setPepSeq(lPeptideHit.getSequence());
                pepoutBuilder.append(String.valueOf(isDecoy) + "\t");
                psm.setDecoy(isDecoy);
                pepoutBuilder.append(String.valueOf(lPeptideHit.getMissedCleavages()) + "\t");
                psm.setMissc(lPeptideHit.getMissedCleavages());
                pepoutBuilder.append(accStringBuilder + "\t");
                psm.setProString(accStringBuilder.toString());
                String rt = lQuery.getRetentionTimeInSeconds() == null ? "-1" : lQuery.getRetentionTimeInSeconds();
                pepoutBuilder.append(String.valueOf(rt) + "\t");
                psm.setRt(Double.valueOf(rt));
                pepoutBuilder.append(String.valueOf(modSites) + "\t");
                psm.setMods(modSites);
                pepoutBuilder.append(String.valueOf(isSAP) + "\t");
                psm.setSAP(isSAP);
                pepoutBuilder.append(pepPosInProString.toString());
                psm.setPosString(pepPosInProString.toString());
                pepfilebw.write(String.valueOf(pepoutBuilder.toString()) + "\n");
                psmPool.addPsm(psm);
                psmPool.putCharge2lastPSM(psm.getChargeClass(), psm);
            }
            ++j;
        }
        pepfilebw.close();
        System.out.println(dateformat.format(new Date()));
        System.out.println("Raw PSMs information extraction done!");
        String outFilterPsmFile = String.valueOf(outdir) + "/" + projname + "-peptideSummary.txt";
        Spectra.setSapPrefixString(sapPrefixString);
        Spectra.setDecoyPrefixString(decoyString);
        FDRcalculator.initialize(reMap, 0.01, outFilterPsmFile, fasta);
        FDRcalculator.setDecoyString(decoyString);
        FastaReader.setDecoyString(decoyString);
        HashSet<String> psmIdHashSet = FDRcalculator.fdrCalc(psmPool);
        System.out.println(dateformat.format(new Date()));
        System.out.println("FDR calculation done!");
        MascotParser.outPSMpeak(psmIdHashSet, iMascotDatfile, outdir);
        System.out.println(dateformat.format(new Date()));
        System.out.println("Peak labeling information extraction done!");
        String outProtienFile = String.valueOf(outdir) + "/" + projname + "-proteinSummary.txt";
        ProteinGroup.proteinGrouper(outFilterPsmFile, outProtienFile, fasta, sapPrefixString);
        System.out.println(dateformat.format(new Date()));
        System.out.println("Protein inference done!");
    }

    private static void outPSMpeak(HashSet<String> psmIdHashSet, MascotDatfileInf iMascotDatfile, String outdir) throws IOException {
        QueryToPeptideMapInf lQueryToPeptideMap = iMascotDatfile.getQueryToPeptideMap();
        Vector lQueryList = iMascotDatfile.getQueryList();
        int j = 0;
        while (j < lQueryList.size()) {
            Query lQuery = (Query)lQueryList.get(j);
            int queryNum = lQuery.getQueryNumber();
            int specNum = queryNum;
            String ms2id = String.valueOf(specNum);
            if (psmIdHashSet.contains(ms2id)) {
                String ms2file = String.valueOf(outdir) + "/" + ms2id + "_ms2match.txt";
                BufferedWriter bWriter = new BufferedWriter(new FileWriter(new File(ms2file)));
                StringBuilder ms2outBuilder = new StringBuilder();
                PeptideHit lPeptideHit = lQueryToPeptideMap.getPeptideHitOfOneQuery(specNum, 1);
                PeptideHitAnnotation lPeptideHitAnnotation = lPeptideHit.getPeptideHitAnnotation(iMascotDatfile.getMasses(), iMascotDatfile.getParametersSection());
                Vector lFusedFragmentionsVec = lPeptideHitAnnotation.getFusedMatchedIons(lQuery.getPeakList(), lPeptideHit.getPeaksUsedFromIons1(), lQuery.getMaxIntensity(), 0.05);
                int i = 0;
                while (i < lFusedFragmentionsVec.size()) {
                    FragmentIon ion = (FragmentIon)lFusedFragmentionsVec.get(i);
                    if (!(ion.getIntensity() < 0.01 * lQuery.getMaxIntensity())) {
                        String ionDesc = String.valueOf(ion.getType()) + ion.getNumber();
                        ms2outBuilder.append(String.valueOf(ion.getMZ()) + "\t");
                        ms2outBuilder.append(String.valueOf(ion.getIntensity()) + "\t");
                        ms2outBuilder.append(String.valueOf(ionDesc) + "\n");
                    }
                    ++i;
                }
                bWriter.write(ms2outBuilder.toString());
                bWriter.close();
                String ms2rawfile = String.valueOf(outdir) + "/" + ms2id + "_rawPeakList.txt";
                BufferedWriter bWriter4ms2rawfile = new BufferedWriter(new FileWriter(new File(ms2rawfile)));
                String peakList = MascotParser.getPeakList(lQuery);
                bWriter4ms2rawfile.write(peakList);
                bWriter4ms2rawfile.close();
            }
            ++j;
        }
    }

    private static String getPeakList(Query lQuery) {
        StringBuilder sBuilder = new StringBuilder();
        double[] mzValues = lQuery.getMZArray();
        double[] intensityValues = lQuery.getIntensityArray();
        int i = 0;
        while (i < mzValues.length) {
            sBuilder.append(String.valueOf(mzValues[i]) + "\t" + intensityValues[i] + "\n");
            ++i;
        }
        return sBuilder.toString();
    }
}

