/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches_iterators;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.personalization.UrParameter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PeptideMatchesIterator {
    private final Identification identification;
    private final ArrayList<String> peptideKeys;
    private final ArrayList<UrParameter> peptidesParameters;
    private final boolean loadPsms;
    private final ArrayList<UrParameter> psmParameters;
    private final int nMatches;
    private int index = -1;
    public final int defaultBatchSize = 1000;
    private int batchSize = 1000;
    private int loadingIndex = -1;
    private boolean buffering = false;
    public final double defaultMargin = 0.1;
    private double margin = 0.1;

    public PeptideMatchesIterator(ArrayList<String> peptideKeys, Identification identification, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters) {
        this.identification = identification;
        this.peptideKeys = peptideKeys == null ? identification.getPeptideIdentification() : peptideKeys;
        this.nMatches = this.peptideKeys.size();
        this.peptidesParameters = peptideParameters;
        this.loadPsms = loadPsms;
        this.psmParameters = psmParameters;
    }

    public PeptideMatchesIterator(Identification identification, ArrayList<UrParameter> peptideParameters, boolean loadPsms, ArrayList<UrParameter> psmParameters) {
        this(null, identification, peptideParameters, loadPsms, psmParameters);
    }

    public PeptideMatchesIterator(ArrayList<String> peptideKeys, Identification identification, ArrayList<UrParameter> peptideParameters) {
        this(peptideKeys, identification, peptideParameters, false, null);
    }

    public boolean hasNext() {
        return this.index < this.nMatches - 1;
    }

    public PeptideMatch next() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        int threadIndex = this.incrementIndex();
        if (threadIndex < this.nMatches) {
            this.checkBuffer();
            String key = this.peptideKeys.get(threadIndex);
            PeptideMatch match = this.identification.getPeptideMatch(key);
            return match;
        }
        return null;
    }

    private void checkBuffer() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.buffering) {
            int trigger = this.loadingIndex - (int)(this.margin * (double)this.batchSize);
            if (this.index >= trigger) {
                int newLoadingIndex = Math.min(this.loadingIndex + this.batchSize, this.nMatches - 1);
                ArrayList<String> keysInBatch = new ArrayList<String>(this.peptideKeys.subList(this.loadingIndex + 1, newLoadingIndex + 1));
                this.identification.loadPeptideMatches(keysInBatch, null);
                if (this.peptidesParameters != null) {
                    for (UrParameter urParameter : this.peptidesParameters) {
                        if (urParameter == null) {
                            throw new IllegalArgumentException("Parameter to for batch load is null.");
                        }
                        this.identification.loadPeptideMatchParameters(keysInBatch, urParameter, null);
                    }
                }
                if (this.loadPsms) {
                    ArrayList<String> psmKeys = new ArrayList<String>(this.batchSize);
                    for (String peptideKey : keysInBatch) {
                        PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
                        psmKeys.addAll(peptideMatch.getSpectrumMatches());
                    }
                    this.identification.loadSpectrumMatches(psmKeys, null);
                    if (this.psmParameters != null) {
                        for (UrParameter urParameter : this.psmParameters) {
                            if (urParameter == null) {
                                throw new IllegalArgumentException("Parameter to for batch load is null.");
                            }
                            this.identification.loadSpectrumMatchParameters(psmKeys, urParameter, null);
                        }
                    }
                }
                this.loadingIndex = newLoadingIndex;
                trigger += (int)(this.margin * (double)this.batchSize / 2.0);
                if (this.index < (trigger = Math.max(0, trigger))) {
                    if (this.batchSize > 1000) {
                        this.batchSize = Math.max(1000, 0 * this.batchSize);
                    } else if (this.margin > 0.1) {
                        this.margin = Math.max(0.1, 0.9 * this.margin);
                    }
                }
                this.buffering = false;
            }
        } else if (this.index == this.loadingIndex) {
            this.margin *= 1.1;
            if (this.margin >= 0.25) {
                this.batchSize = (int)((double)this.batchSize * 1.1);
                this.margin = 0.1;
            }
        }
    }

    private synchronized int incrementIndex() {
        int localIndex = ++this.index;
        return localIndex;
    }
}

