/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.TagAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public abstract class SpectrumAnnotator {
    protected int precursorCharge;
    protected HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> theoreticalFragmentIons;
    protected IonFactory fragmentFactory = IonFactory.getInstance();
    private String spectrumKey = "";
    protected double intensityLimit = 0.0;
    private ArrayList<Double> mz;
    private HashMap<Double, Peak> peakMap;
    protected HashMap<String, IonMatch> spectrumAnnotation = new HashMap();
    protected ArrayList<String> unmatchedIons = new ArrayList();
    protected double mzTolerance;
    protected boolean isPpm;
    protected static final boolean subtractIsotope = false;
    protected double massShift = 0.0;
    protected double massShiftNTerm = 0.0;
    protected double massShiftCTerm = 0.0;
    protected boolean pickMostAccuratePeak = true;

    public static Vector<SpectrumAnnotation> getSpectrumAnnotation(ArrayList<IonMatch> ionMatches) {
        Vector<SpectrumAnnotation> currentAnnotations = new Vector<SpectrumAnnotation>();
        for (IonMatch ionMatch : ionMatches) {
            currentAnnotations.add(new DefaultSpectrumAnnotation(ionMatch.peak.mz, ionMatch.getAbsoluteError(false), SpectrumPanel.determineFragmentIonColor(ionMatch.ion, true), ionMatch.getPeakAnnotation()));
        }
        return currentAnnotations;
    }

    protected boolean matchInSpectrum(Ion theoreticIon, int inspectedCharge) {
        Charge charge = new Charge(1, inspectedCharge);
        IonMatch bestMatch = null;
        double bestAccuracy = Double.MAX_VALUE;
        double fragmentMz = (theoreticIon.getTheoreticMass() + (double)inspectedCharge * ElementaryIon.proton.getTheoreticMass()) / (double)inspectedCharge;
        double deltaMz = this.isPpm ? this.mzTolerance / 1000000.0 * fragmentMz : this.mzTolerance;
        if (!this.mz.isEmpty() && fragmentMz >= this.mz.get(0) - deltaMz && fragmentMz <= this.mz.get(this.mz.size() - 1) + deltaMz) {
            Peak tempPeak = new Peak(0.0, 0.0);
            IonMatch tempMatch = new IonMatch(tempPeak, theoreticIon, charge);
            for (int i = 0; i < this.mz.size(); ++i) {
                tempPeak.setMz(this.mz.get(i));
                tempMatch.peak = tempPeak;
                if (!(Math.abs(tempMatch.getError(this.isPpm, false)) <= this.mzTolerance)) continue;
                Peak currentPeak = this.peakMap.get(this.mz.get(i));
                if (this.pickMostAccuratePeak) {
                    double tempAccuracy = Math.abs(currentPeak.mz - theoreticIon.getTheoreticMz(inspectedCharge));
                    if (bestMatch != null && !(tempAccuracy < bestAccuracy)) continue;
                    bestMatch = new IonMatch(currentPeak, theoreticIon, charge);
                    bestAccuracy = tempAccuracy;
                    continue;
                }
                if (bestMatch != null && !(bestMatch.peak.intensity < currentPeak.intensity)) continue;
                bestMatch = new IonMatch(currentPeak, theoreticIon, charge);
            }
        }
        if (bestMatch != null) {
            this.spectrumAnnotation.put(IonMatch.getMatchKey(theoreticIon, charge.value), bestMatch);
        } else {
            this.unmatchedIons.add(IonMatch.getMatchKey(theoreticIon, charge.value));
        }
        return bestMatch != null;
    }

    protected void setSpectrum(MSnSpectrum spectrum, double intensityLimit) {
        if (!this.spectrumKey.equals(spectrum.getSpectrumKey()) || this.intensityLimit != intensityLimit) {
            ArrayList<Object> tempMz;
            this.spectrumKey = spectrum.getSpectrumKey();
            this.intensityLimit = intensityLimit;
            if (intensityLimit == 0.0) {
                this.peakMap = spectrum.getPeakMap();
                tempMz = new ArrayList<Double>(this.peakMap.keySet());
            } else {
                this.peakMap = new HashMap();
                tempMz = new ArrayList();
                for (Peak peak : spectrum.getPeakList()) {
                    if (!(peak.intensity > intensityLimit)) continue;
                    this.peakMap.put(peak.mz, peak);
                    tempMz.add(peak.mz);
                }
            }
            Collections.sort(tempMz);
            this.mz = tempMz;
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    protected void setMassTolerance(double mzTolerance, boolean isPpm, boolean pickMostAccuratePeak) {
        if (mzTolerance != this.mzTolerance || pickMostAccuratePeak != this.pickMostAccuratePeak) {
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
            this.mzTolerance = mzTolerance;
            this.isPpm = isPpm;
            this.pickMostAccuratePeak = pickMostAccuratePeak;
        }
    }

    public boolean isAccounted(NeutralLossesMap neutralLosses, NeutralLoss neutralLoss, Ion ion) {
        if (neutralLosses == null || neutralLosses.isEmpty()) {
            return false;
        }
        for (NeutralLoss neutralLossRef : neutralLosses.getAccountedNeutralLosses()) {
            if (!neutralLoss.isSameAs(neutralLossRef)) continue;
            switch (ion.getType()) {
                case PEPTIDE_FRAGMENT_ION: {
                    PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getBStart(neutralLossRef) <= peptideFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getYStart(neutralLossRef) <= peptideFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
                case TAG_FRAGMENT_ION: {
                    TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getBStart(neutralLossRef) <= tagFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getYStart(neutralLossRef) <= tagFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
            }
            return true;
        }
        return false;
    }

    public boolean lossesValidated(NeutralLossesMap neutralLosses, Ion theoreticIon) {
        for (NeutralLoss neutralLoss : theoreticIon.getNeutralLosses()) {
            if (this.isAccounted(neutralLosses, neutralLoss, theoreticIon)) continue;
            return false;
        }
        return true;
    }

    public boolean chargeValidated(Ion theoreticIon, int charge, int precursorCharge) {
        if (charge == 1) {
            return true;
        }
        switch (theoreticIon.getType()) {
            case IMMONIUM_ION: {
                return false;
            }
            case REPORTER_ION: {
                return false;
            }
            case PEPTIDE_FRAGMENT_ION: {
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)theoreticIon;
                return charge <= peptideFragmentIon.getNumber() && charge < precursorCharge;
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)theoreticIon;
                return charge <= tagFragmentIon.getNumber() && charge < precursorCharge;
            }
            case PRECURSOR_ION: {
                return charge >= precursorCharge;
            }
        }
        throw new UnsupportedOperationException("Ion type " + theoreticIon.getTypeAsString() + " not implemented in the spectrum annotator.");
    }

    public abstract ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum var1, HashMap<Ion.IonType, HashSet<Integer>> var2, NeutralLossesMap var3, ArrayList<Integer> var4, boolean var5);

    public String getCurrentlyLoadedSpectrumKey() {
        return this.spectrumKey;
    }

    public double getMassShift() {
        return this.massShift;
    }

    public double getMassShiftNTerm() {
        return this.massShiftNTerm;
    }

    public double getMassShiftCTerm() {
        return this.massShiftNTerm;
    }

    public void setMassShift(double aMassShift) {
        this.massShift = aMassShift;
        this.updateMassShifts();
    }

    public void setMassShifts(double aMassShift, double aMassShiftNTerm, double aMassShiftCTerm) {
        this.massShift = aMassShift;
        this.massShiftNTerm = aMassShiftNTerm;
        this.massShiftCTerm = aMassShiftCTerm;
        this.updateMassShifts();
    }

    public void setTerminalMassShifts(double aMassShiftNTerm, double aMassShiftCTerm) {
        this.massShiftNTerm = aMassShiftNTerm;
        this.massShiftCTerm = aMassShiftCTerm;
        this.updateMassShifts();
    }

    protected void updateMassShifts() {
        this.spectrumAnnotation.clear();
        this.unmatchedIons.clear();
        if (this.theoreticalFragmentIons != null) {
            HashMap<Integer, ArrayList<Ion>> tagFragmentIons;
            HashMap<Integer, ArrayList<Ion>> peptideFragmentIons = this.theoreticalFragmentIons.get(Ion.IonType.PEPTIDE_FRAGMENT_ION.index);
            ArrayList<Ion> ions = peptideFragmentIons.get(0);
            if (ions != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(1)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(2)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(3)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(4)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(5)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = (tagFragmentIons = this.theoreticalFragmentIons.get(Ion.IonType.TAG_FRAGMENT_ION.index)).get(0)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(1)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(2)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(3)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = tagFragmentIons.get(4)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = tagFragmentIons.get(5)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
        }
    }

    public static NeutralLossesMap getDefaultLosses(SpectrumIdentificationAssumption spectrumIdentificationAssumption, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException, SQLException {
        if (spectrumIdentificationAssumption instanceof PeptideAssumption) {
            PeptideAssumption peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
            return PeptideSpectrumAnnotator.getDefaultLosses(peptideAssumption.getPeptide(), sequenceMatchingPreferences);
        }
        if (spectrumIdentificationAssumption instanceof TagAssumption) {
            TagAssumption tagAssumption = (TagAssumption)spectrumIdentificationAssumption;
            return TagSpectrumAnnotator.getDefaultLosses(tagAssumption.getTag(), sequenceMatchingPreferences);
        }
        throw new IllegalArgumentException("Default neutral loss map not implemented for SpectrumIdentificationAssumption " + spectrumIdentificationAssumption.getClass() + ".");
    }

    protected ArrayList<IonMatch> matchPeak(HashMap<Ion.IonType, HashSet<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, NeutralLossesMap neutralLosses, Peak peak) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (iontypes.containsKey((Object)Ion.IonType.PRECURSOR_ION)) {
            charges.add(precursorCharge);
            charges.add(precursorCharge + 1);
        }
        for (Ion.IonType ionType : iontypes.keySet()) {
            HashMap<Integer, ArrayList<Ion>> ionMap = this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = iontypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList<Ion> ions = ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    for (int charge : charges) {
                        IonMatch ionMatch;
                        if (!this.chargeValidated(ion, charge, precursorCharge) || !this.lossesValidated(neutralLosses, ion) || !(Math.abs((ionMatch = new IonMatch(peak, ion, new Charge(1, charge))).getError(this.isPpm, false)) <= this.mzTolerance)) continue;
                        result.add(ionMatch);
                    }
                }
            }
        }
        return result;
    }

    protected HashMap<Integer, ArrayList<Ion>> getExpectedIons(HashMap<Ion.IonType, HashSet<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge) {
        HashMap<Integer, ArrayList<Ion>> result = new HashMap<Integer, ArrayList<Ion>>();
        for (Ion.IonType ionType : iontypes.keySet()) {
            HashMap<Integer, ArrayList<Ion>> ionMap = this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = iontypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList<Ion> ions = ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    if (!this.lossesValidated(neutralLosses, ion)) continue;
                    for (int charge : charges) {
                        if (!this.chargeValidated(ion, charge, precursorCharge)) continue;
                        ArrayList<Ion> resultsAtCharge = result.get(charge);
                        if (resultsAtCharge == null) {
                            resultsAtCharge = new ArrayList();
                            result.put(charge, resultsAtCharge);
                        }
                        resultsAtCharge.add(ion);
                    }
                }
            }
        }
        return result;
    }

    public static ArrayList<IonMatch> matchReporterIon(Ion theoreticIon, int charge, Spectrum spectrum, double massTolerance) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        double targetMass = (theoreticIon.getTheoreticMass() + (double)charge * ElementaryIon.proton.getTheoreticMass()) / (double)charge;
        for (double mz : spectrum.getOrderedMzValues()) {
            if (Math.abs(mz - targetMass) <= massTolerance) {
                result.add(new IonMatch(spectrum.getPeakMap().get(mz), theoreticIon, new Charge(1, 1)));
            }
            if (mz > targetMass + massTolerance) break;
        }
        return result;
    }
}

