### R code from vignette source 'vignetteNanoStringQCPro.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex()


###################################################
### code chunk number 2: vignetteNanoStringQCPro.Rnw:24-25
###################################################
options(width=80)


###################################################
### code chunk number 3: vignetteNanoStringQCPro.Rnw:79-80
###################################################
options(warn=-1)


###################################################
### code chunk number 4: libraryNanoStringQCPro
###################################################
library(NanoStringQCPro)


###################################################
### code chunk number 5: vignetteNanoStringQCPro.Rnw:85-86
###################################################
options(warn=0)


###################################################
### code chunk number 6: vignetteNanoStringQCPro.Rnw:88-107
###################################################
exampleDataDir <- system.file("extdata", package="NanoStringQCPro")
rccDir <- file.path(exampleDataDir, "RCC")
example_rccSet <- newRccSet(
     rccFiles               = dir(rccDir, full.names=TRUE)
   #,rccCollectorToolExport = file.path(exampleDataDir, "nSolver", "RCC_collector_tool_export.csv")
    ,rlf                    = file.path(exampleDataDir, "RLF", "NQCP_example.rlf")
    ,cdrDesignData          = file.path(exampleDataDir, "CDR", "CDR-DesignData.csv")
    ,extraPdata             = file.path(exampleDataDir, "extraPdata", "SampleType.txt")
    ,blankLabel             = "blank"
    ,experimentData.name    = "Dorothee Nickles"
    ,experimentData.lab     = "Richard Bourgon"
    ,experimentData.contact = "nickles.dorothee@gene.com"
    ,experimentData.title   = "NanoStringQCPro example dataset"
    ,experimentData.abstract= "Example data for the NanoStringQCPro package"
)

# Reading RCC files...
# checkRccSet() messages:
#   The following panel housekeeping genes were found: RBCK1, USP19


###################################################
### code chunk number 7: example_rccSet
###################################################
str(max.level=2, example_rccSet)


###################################################
### code chunk number 8: preprocRccSet
###################################################
norm_example_rccSet <- preprocRccSet(rccSet = example_rccSet, normMethod = "housekeeping")

# Warning message:
# In .local(rccSet, ...) : Less than three housekeeping features are defined

ls(assayData(norm_example_rccSet))
preproc(norm_example_rccSet)


###################################################
### code chunk number 9: posCtrlNorm
###################################################
adj_example_rccSet <- posCtrlNorm(example_rccSet, summaryFunction="sum")
ls(assayData(adj_example_rccSet))
preproc(adj_example_rccSet)
head(pData(adj_example_rccSet)$PosFactor)


###################################################
### code chunk number 10: getBackground
###################################################
# Get background based on median signal for each probe in blank measurements:
bg1 <- getBackground(adj_example_rccSet, bgReference="blanks", summaryFunction="median")

# ...based on mean of negative controls:
bg2 <- getBackground(adj_example_rccSet, bgReference="negatives", summaryFunction="mean")

# ...using an implementation mimicking that of the nSolver software:
bg3 <- getBackground(adj_example_rccSet, bgReference="both", stringency=1)


###################################################
### code chunk number 11: subtractBackground
###################################################
bgcorr_example_rccSet <- subtractBackground(adj_example_rccSet, bgEstimates=bg1)
ls(assayData(bgcorr_example_rccSet))
preproc(bgcorr_example_rccSet)


###################################################
### code chunk number 12: contentNorm
###################################################
gmnorm_example_rccSet <- contentNorm(rccSet=bgcorr_example_rccSet, method="median")
hknorm_example_rccSet <- contentNorm(rccSet=bgcorr_example_rccSet, method="housekeeping")

# Warning message:
# In contentNorm(srccSet, method = "housekeeping", hk = hk) :
#   Less than three housekeeping features are defined


###################################################
### code chunk number 13: makeQCReport
###################################################
qc_example_rccSet <- makeQCReport(norm_example_rccSet, "example_QC_report")

# Generating QC report...
# Report file has been generated: /gne/home/richarbo/tmp/example_QC_report.html


###################################################
### code chunk number 14: sessionInfo
###################################################
sessionInfo()


