## ---- include = FALSE----------------------------------------------------
knitr::opts_chunk$set(eval = FALSE)

## ------------------------------------------------------------------------
#  BiocInstaller::biocLite("LiNk-NY/RTCGAToolbox")
#  BiocInstaller::biocLite("waldronlab/TCGAutils")

## ------------------------------------------------------------------------
#  library(MultiAssayExperiment)
#  library(RTCGAToolbox)
#  library(TCGAutils)
#  library(readr)

## ------------------------------------------------------------------------
#  TCGAcode <- getFirehoseDatasets()[27] # PRAD
#  stopifnot(identical(ds, "PRAD"))
#  runDate <- getFirehoseRunningDates()[1]
#  analyzeDate <- getFirehoseAnalyzeDates()[1]
#  dataDirectory <- "data"

## ------------------------------------------------------------------------
#  buildMultiAssayExperiments <-
#      function(TCGAcode, runDate, analyzeDate, dataDirectory) {
#          if (!dir.exists(dataDirectory))
#              dir.create(dataDirectory)
#          for (cancer in TCGAcodes) {
#              message("\n######\n",
#                      "\nProcessing ", cancer, " : )\n",
#                      "\n######\n")
#              serialPath <- file.path("data", paste0(cancer, ".rds"))
#              if (file.exists(serialPath)) {
#                  cancerObject <- readRDS(serialPath)
#              } else {
#                  cancerObject <- getFirehoseData(cancer, runDate = runDate,
#                                                  gistic2_Date = analyzeDate,
#                                                  RNAseq_Gene = TRUE,
#                                                  Clinic = TRUE,
#                                                  miRNASeq_Gene = TRUE,
#                                                  RNAseq2_Gene_Norm = TRUE,
#                                                  CNA_SNP = TRUE,
#                                                  CNV_SNP = TRUE,
#                                                  CNA_Seq = TRUE,
#                                                  CNA_CGH = TRUE,
#                                                  Methylation = TRUE,
#                                                  Mutation = TRUE,
#                                                  mRNA_Array = TRUE,
#                                                  miRNA_Array = TRUE,
#                                                  RPPA_Array = TRUE,
#                                                  RNAseqNorm = "raw_counts",
#                                                  RNAseq2Norm =
#                                                      "normalized_count",
#                                                  forceDownload = FALSE,
#                                                  destdir = "./tmp",
#                                                  fileSizeLimit = 500000,
#                                                  getUUIDs = FALSE)
#                  saveRDS(cancerObject, file = serialPath, compress = "bzip2")
#              }
#              ## Add clinical data from RTCGAToolbox
#              pd <- Clinical(co)
#              rownames(pd) <- toupper(gsub("\\.", "-", rownames(pd)))
#              clinicalData <- type_convert(pd)
#              ## slotNames in FirehoseData RTCGAToolbox class
#              targets <- c("RNASeqGene", "RNASeq2GeneNorm", "miRNASeqGene",
#                           "CNASNP", "CNVSNP", "CNAseq", "CNACGH", "Methylation",
#                           "mRNAArray", "miRNAArray", "RPPAArray", "Mutations",
#                           "gistica", "gistict")
#              names(targets) <- targets
#              dataList <- lapply(targets, function(datType) {
#                  tryCatch({TCGAutils::TCGAextract(cancerObject, datType)},
#                           error = function(e) {
#                               message(datType, " does not contain any data!")
#                           })
#              })
#              dataFull <- Filter(function(x) {!is.null(x)}, dataList)
#              NewMap <- generateMap(dataFull, clinicalData, TCGAbarcode)
#              MAEO <- MultiAssayExperiment(dataFull, clinicalData, NewMap)
#              saveRDS(MAEO, file = file.path(dataDirectory,
#                                             paste0(cancer, "_MAEO.rds")),
#                      compress = "bzip2")
#          }
#      }

## ------------------------------------------------------------------------
#  buildMultiAssayExperiments(TCGAcode, runDate, analyzeDate, dataDirectory)

