## ---- echo=FALSE, warning=FALSE------------------------------------------
suppressPackageStartupMessages({
    library(MultiAssayExperiment)
    library(S4Vectors)
    })

## ------------------------------------------------------------------------
pheno <- DataFrame(id = 1:4, type = c("a", "a", "b", "b"),
                   sex = c("M", "F", "M", "F"),
                   row.names = c("Bob", "Sandy", "Jake", "Lauren"))

## ------------------------------------------------------------------------
dataset1 <- matrix(rnorm(20, 5, 1), ncol = 5,
                  dimnames = list(paste0("GENE", 4:1),
                                  paste0("sample", LETTERS[1:5])))
dataset2 <- matrix(rnorm(12, 3, 2), ncol = 3,
                   dimnames = list(paste0("ENST0000", 1:4),
                                   paste0("samp", letters[1:3])))

expList <- list(exp1 = dataset1, exp2 = dataset2)
expList

## ------------------------------------------------------------------------
map1 <- DataFrame(primary = c("Bob", "Jake", "Sandy", "Sandy", "Lauren"),
                  colname = paste0("sample", LETTERS[1:5]))
map2 <- DataFrame(primary = c("Jake", "Sandy", "Lauren"),
                  colname = paste0("samp", letters[1:3]))
sampMap <- listToMap(list(exp1 = map1, exp2 = map2))
sampMap

## ------------------------------------------------------------------------
(mae <- MultiAssayExperiment(expList, pheno, sampMap))

## ------------------------------------------------------------------------
mae[c("GENE4", "ENST00002"), , ]
mae[, c("Bob", "Jake", "Sandy"), ]
mae[, , "exp1"]

## ------------------------------------------------------------------------
mae[[1L]]

## ------------------------------------------------------------------------
assay(mae)

## ------------------------------------------------------------------------
assays(mae)

## ------------------------------------------------------------------------
mae$sex

## ------------------------------------------------------------------------
longFormat(mae)

## ------------------------------------------------------------------------
wideFormat(mae)[, 1:4]

## ------------------------------------------------------------------------
(maec1 <- c(x = mae,
  exp3 = matrix(rnorm(10), ncol = 5,
                dimnames = list(paste0("GENE", c("A", "B")),
                                paste0("sample", LETTERS[1:5]))),
  sampleMap = DataFrame(assay = "exp3",
                        primary = c("Bob", "Bob", "Sandy", "Jake", "Lauren"),
                        colname = paste0("sample", LETTERS[1:5])
                        )
  ))
sampleMap(maec1)

## ------------------------------------------------------------------------
(maec2 <- c(x = mae,
  exp3 = matrix(rnorm(10), ncol = 5,
                dimnames = list(paste0("GENE", c("A", "B")),
                                paste0("sample", LETTERS[1:5]))),
  mapFrom = 1L))

## ------------------------------------------------------------------------
sessionInfo()

