/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Packing;
import org.biojava.bio.symbol.Symbol;

class IndexedNoAmbPack
implements Packing,
Serializable {
    private final AlphabetIndex index;
    private final byte wordSize;

    IndexedNoAmbPack(AlphabetIndex index) throws IllegalAlphabetException {
        this.index = index;
        int size = (int)Math.ceil(Math.log(index.getAlphabet().size()) / Math.log(2.0));
        if (size > 8) {
            throw new IllegalAlphabetException("Alphabet too big to pack into a byte");
        }
        this.wordSize = (byte)size;
    }

    public AlphabetIndex getIndex() {
        return this.index;
    }

    public FiniteAlphabet getAlphabet() {
        return this.index.getAlphabet();
    }

    public byte wordSize() {
        return this.wordSize;
    }

    public boolean handlesAmbiguity() {
        return false;
    }

    public byte pack(Symbol sym) throws IllegalSymbolException {
        return (byte)this.index.indexForSymbol(sym);
    }

    public Symbol unpack(byte packed) throws IllegalSymbolException {
        return this.index.symbolForIndex(packed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexedNoAmbPack)) {
            return false;
        }
        IndexedNoAmbPack indexedNoAmbPack = (IndexedNoAmbPack)o;
        return this.index.equals(indexedNoAmbPack.index);
    }

    public int hashCode() {
        return this.index.hashCode();
    }
}

