/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.impl.vector;

import cytoscape.render.stateful.CustomGraphic;
import cytoscape.visual.customgraphic.IDGenerator;
import cytoscape.visual.customgraphic.impl.DLayer;
import cytoscape.visual.customgraphic.impl.vector.GradientLayerCustomGraphics;
import cytoscape.visual.customgraphic.paint.GradientPaintFactory;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;

public class GradientRoundRectangleLayer
extends GradientLayerCustomGraphics {
    private static final String NAME = "Glossy Round Rectangle Layer";
    private int r = 20;

    public GradientRoundRectangleLayer() {
        this(IDGenerator.getIDGenerator().getNextId(), NAME);
    }

    public GradientRoundRectangleLayer(Long id, String name) {
        super(id, name);
    }

    protected void renderImage(Graphics graphics) {
        super.renderImage(graphics);
        Graphics2D g2d = (Graphics2D)graphics;
        this.update();
        g2d.setPaint(this.paintFactory.getPaint(this.bound.getBounds2D()));
        g2d.fillRoundRect(this.rendered.getMinX(), this.rendered.getMinY(), this.rendered.getWidth(), this.rendered.getHeight(), this.r, this.r);
    }

    public void update() {
        this.layers.clear();
        this.r = (int)((float)Math.min(this.width, this.height) / 4.0f);
        this.bound = new RoundRectangle2D.Double(-this.width / 2, -this.height / 2, this.width, this.height, this.r, this.r);
        this.paintFactory = new GradientPaintFactory((Color)this.c1.getValue(), (Color)this.c2.getValue());
        CustomGraphic cg = new CustomGraphic(this.bound, this.paintFactory);
        DLayer layer = new DLayer(cg, 1);
        this.layers.add(layer);
    }
}

