/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.CytoscapeInit;
import cytoscape.actions.SaveSessionAction;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesImpl;
import cytoscape.data.ExpressionData;
import cytoscape.data.ImportHandler;
import cytoscape.data.readers.BookmarkReader;
import cytoscape.data.readers.CyAttributesReader;
import cytoscape.data.readers.EqnAttrTracker;
import cytoscape.data.readers.GraphReader;
import cytoscape.data.readers.NestedNetworkReader;
import cytoscape.data.servers.OntologyServer;
import cytoscape.ding.CyGraphLOD;
import cytoscape.ding.DingNetworkView;
import cytoscape.giny.CytoscapeFingRootGraph;
import cytoscape.giny.CytoscapeRootGraph;
import cytoscape.groups.CyGroup;
import cytoscape.groups.CyGroupManager;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.CyLayouts;
import cytoscape.logger.CyLogger;
import cytoscape.util.FileUtil;
import cytoscape.util.RecentlyOpenedTracker;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.GraphView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cytoscape {
    public static String ATTRIBUTES_CHANGED = "ATTRIBUTES_CHANGED";
    public static String NETWORK_CREATED = "NETWORK_CREATED";
    public static String DATASERVER_CHANGED = "DATASERVER_CHANGED";
    public static String EXPRESSION_DATA_LOADED = "EXPRESSION_DATA_LOADED";
    public static String NETWORK_DESTROYED = "NETWORK_DESTROYED";
    public static String CYTOSCAPE_INITIALIZED = "CYTOSCAPE_INITIALIZED";
    public static String CYTOSCAPE_EXIT = "CYTOSCAPE_EXIT";
    public static String SESSION_SAVED = "SESSION_SAVED";
    public static String SESSION_LOADED = "SESSION_LOADED";
    public static String VIZMAP_RESTORED = "VIZMAP_RESTORED";
    public static String SAVE_VIZMAP_PROPS = "SAVE_VIZMAP_PROPS";
    public static String VIZMAP_LOADED = "VIZMAP_LOADED";
    public static final String SAVE_PLUGIN_STATE = "SAVE_PLUGIN_STATE";
    public static final String RESTORE_PLUGIN_STATE = "RESTORE_PLUGIN_STATE";
    public static final String NETWORK_MODIFIED = "NETWORK_MODIFIED";
    public static final String NETWORK_TITLE_MODIFIED = "NETWORK_TITLE_MODIFIED";
    public static final String NETWORK_SAVED = "NETWORK_SAVED";
    public static final String NETWORK_LOADED = "NETWORK_LOADED";
    public static final String ONTOLOGY_ROOT = "ONTOLOGY_ROOT";
    public static final String PREFERENCE_MODIFIED = "PREFERENCE_MODIFIED";
    public static final String PREFERENCES_UPDATED = "PREFERENCES_UPDATED";
    public static final String PROXY_MODIFIED = "PROXY_MODIFIED";
    public static final String NESTED_NETWORK_CREATED = "NESTED_NETWORK_CREATED";
    public static final String NESTED_NETWORK_DESTROYED = "NESTED_NETWORK_DESTROYED";
    public static int FILE_BY_SUFFIX = 0;
    public static int FILE_GML = 1;
    public static int FILE_SIF = 2;
    public static int FILE_SBML = 3;
    public static int FILE_XGMML = 4;
    public static int FILE_BIOPAX = 5;
    public static int FILE_PSI_MI = 6;
    public static final int SELECT_NODES_ONLY = 1;
    public static final int SELECT_EDGES_ONLY = 2;
    public static final int SELECT_NODES_AND_EDGES = 3;
    private static int currentSelectionMode = 1;
    public static final Integer SESSION_NEW = 0;
    public static final Integer SESSION_OPENED = 1;
    public static final Integer SESSION_CHANGED = 2;
    public static final int SESSION_CLOSED = 3;
    private static int sessionState = SESSION_NEW;
    private static OntologyServer ontologyServer;
    public static final String READER_CLIENT_KEY = "reader_client_key";
    protected static CytoscapeRootGraph cytoscapeRootGraph;
    private static CyAttributes nodeAttributes;
    private static CyAttributes edgeAttributes;
    private static CyAttributes networkAttributes;
    private static CyAttributes ontologyAttributes;
    protected static ExpressionData expressionData;
    protected static Object pcsO;
    protected static SwingPropertyChangeSupport pcs;
    protected static Object pcs2;
    protected static PropertyChangeSupport newPcs;
    protected static Map<String, CyNetworkView> networkViewMap;
    protected static Map<String, CyNetwork> networkMap;
    protected static CytoscapeDesktop defaultDesktop;
    protected static String currentNetworkID;
    protected static String currentNetworkViewID;
    protected static String ontologyRootID;
    private static String currentSessionFileName;
    private static Bookmarks bookmarks;
    private static RecentlyOpenedTracker recentlyOpenedSessions;
    protected static CyNetwork nullNetwork;
    private static ImportHandler importHandler;
    protected static LinkedList<CyNetworkView> selectedNetworkViews;
    protected static LinkedList<CyNetwork> selectedNetworks;
    protected static final CyNetworkView nullNetworkView;
    protected static VisualMappingManager VMM;
    protected static CyLogger logger;
    private static EqnAttrTracker eqnAttrTracker;

    public static ImportHandler getImportHandler() {
        return importHandler;
    }

    public static CyNetworkView getNullNetworkView() {
        return nullNetworkView;
    }

    public static CyNetwork getNullNetwork() {
        return nullNetwork;
    }

    public static EqnAttrTracker getEqnAttrTracker() {
        if (eqnAttrTracker == null) {
            eqnAttrTracker = new EqnAttrTracker();
        }
        return eqnAttrTracker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void exit(int returnVal) {
        int mode = CytoscapeInit.getCyInitParams().getMode();
        if (mode == 4 || mode == 1) {
            if (!Cytoscape.confirmQuit()) return;
            try {
                Cytoscape.firePropertyChange(CYTOSCAPE_EXIT, null, "now");
            }
            catch (Exception e) {
                logger.warn("Errors on close, closed anyways.", e);
            }
            logger.info("Cytoscape Exiting....");
            if (mode == 4) {
                Cytoscape.getDesktop().setVisible(false);
                Cytoscape.createNewSession();
                return;
            } else {
                System.exit(returnVal);
            }
            return;
        }
        try {
            Cytoscape.getRecentlyOpenedSessionTracker().writeOut();
        }
        catch (IOException e) {
            System.err.println("failed to save recent session URLs!");
        }
        logger.info("Cytoscape Exiting....");
        System.exit(returnVal);
    }

    private static boolean confirmQuit() {
        String msg = "Do you want to save your session?";
        int networkCount = Cytoscape.getNetworkSet().size();
        if (networkCount == 0) {
            return true;
        }
        Object[] options = new Object[]{"Yes, save and quit", "No, just quit", "Cancel"};
        int n = JOptionPane.showOptionDialog(Cytoscape.getDesktop(), "Do you want to save your session?", "Save Networks Before Quitting?", 0, 3, null, options, options[0]);
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            SaveSessionAction saveAction = new SaveSessionAction();
            saveAction.actionPerformed(null);
            if (Cytoscape.getCurrentSessionFileName() == null) {
                return Cytoscape.confirmQuit();
            }
            return true;
        }
        return false;
    }

    public static SwingPropertyChangeSupport getSwingPropertyChangeSupport() {
        return pcs;
    }

    public static PropertyChangeSupport getPropertyChangeSupport() {
        return newPcs;
    }

    public static VisualMappingManager getVisualMappingManager() {
        if (VMM == null) {
            VMM = new VisualMappingManager(nullNetworkView);
        }
        return VMM;
    }

    public static CytoscapeRootGraph getRootGraph() {
        if (cytoscapeRootGraph == null) {
            cytoscapeRootGraph = new CytoscapeFingRootGraph();
        }
        return cytoscapeRootGraph;
    }

    public static void ensureCapacity(int nodes, int edges) {
    }

    public static List getCyNodesList() {
        return Cytoscape.getRootGraph().nodesList();
    }

    public static List getCyEdgesList() {
        return Cytoscape.getRootGraph().edgesList();
    }

    public static CyNode getCyNode(String alias) {
        return Cytoscape.getCyNode(alias, false);
    }

    public static CyNode getCyNode(String nodeID, boolean create) {
        CyNode node = Cytoscape.getRootGraph().getNode(nodeID);
        if (node != null) {
            return node;
        }
        if (!create) {
            return null;
        }
        node = (CyNode)Cytoscape.getRootGraph().getNode(Cytoscape.getRootGraph().createNode());
        node.setIdentifier(nodeID);
        if (Cytoscape.getNodeAttributes().getStringAttribute(nodeID, "canonicalName") == null) {
            Cytoscape.getNodeAttributes().setAttribute(nodeID, "canonicalName", nodeID);
        }
        return node;
    }

    public static CyEdge getCyEdge(Node node_1, Node node_2, String attribute, Object attribute_value, boolean create) {
        return Cytoscape.getCyEdge(node_1, node_2, attribute, attribute_value, create, false);
    }

    public static CyEdge getCyEdge(Node source, Node target, String attribute, Object attribute_value, boolean create, boolean directed) {
        if (Cytoscape.getRootGraph().getEdgeCount() != 0) {
            int[] n1Edges = Cytoscape.getRootGraph().getAdjacentEdgeIndicesArray(source.getRootGraphIndex(), true, true, true);
            for (int i = 0; i < n1Edges.length; ++i) {
                CyEdge edge = (CyEdge)Cytoscape.getRootGraph().getEdge(n1Edges[i]);
                Object attValue = Cytoscape.private_getEdgeAttributeValue(edge, attribute);
                if (attValue == null || !attValue.equals(attribute_value)) continue;
                CyNode edgeTarget = (CyNode)edge.getTarget();
                CyNode edgeSource = (CyNode)edge.getSource();
                if (edgeTarget.getRootGraphIndex() == target.getRootGraphIndex() && edgeSource.getRootGraphIndex() == source.getRootGraphIndex()) {
                    return edge;
                }
                if (directed || edgeTarget.getRootGraphIndex() != source.getRootGraphIndex() || edgeSource.getRootGraphIndex() != target.getRootGraphIndex()) continue;
                return edge;
            }
        }
        if (create && attribute instanceof String && attribute.equals("interaction")) {
            int rootEdge = Cytoscape.getRootGraph().createEdge(source, target);
            CyEdge edge = (CyEdge)Cytoscape.getRootGraph().getEdge(rootEdge);
            String edge_name = CyEdge.createIdentifier(source.getIdentifier(), (String)attribute_value, target.getIdentifier());
            edge.setIdentifier(edge_name);
            edgeAttributes.setAttribute(edge_name, "interaction", (String)attribute_value);
            edgeAttributes.setAttribute(edge_name, "canonicalName", edge_name);
            return edge;
        }
        return null;
    }

    public static CyEdge getCyEdge(String source_alias, String edge_name, String target_alias, String interaction_type) {
        CyEdge edge = Cytoscape.getRootGraph().getEdge(edge_name);
        if (edge != null) {
            return edge;
        }
        if (source_alias == null || source_alias.equals("")) {
            logger.warn("Attempting to get CyEdge with null or empty source node identifier.");
            return null;
        }
        if (target_alias == null || target_alias.equals("")) {
            logger.warn("Attempting to get CyEdge with null or empty target node identifier.");
            return null;
        }
        CyNode source = Cytoscape.getCyNode(source_alias, true);
        CyNode target = Cytoscape.getCyNode(target_alias, true);
        return Cytoscape.getCyEdge(source, target, "interaction", interaction_type, true, true);
    }

    private static Object private_getEdgeAttributeValue(Edge edge, String attribute) {
        CyAttributes edgeAttrs = Cytoscape.getEdgeAttributes();
        String canonName = edge.getIdentifier();
        byte cyType = edgeAttrs.getType(attribute);
        if (cyType == 1) {
            return edgeAttrs.getBooleanAttribute(canonName, attribute);
        }
        if (cyType == 2) {
            return edgeAttrs.getDoubleAttribute(canonName, attribute);
        }
        if (cyType == 3) {
            return edgeAttrs.getIntegerAttribute(canonName, attribute);
        }
        if (cyType == 4) {
            return edgeAttrs.getStringAttribute(canonName, attribute);
        }
        if (cyType == -2) {
            return edgeAttrs.getListAttribute(canonName, attribute);
        }
        if (cyType == -3) {
            return edgeAttrs.getMapAttribute(canonName, attribute);
        }
        return null;
    }

    public static CyNetwork getCurrentNetwork() {
        if (currentNetworkID == null || !Cytoscape.getNetworkMap().containsKey(currentNetworkID)) {
            return nullNetwork;
        }
        CyNetwork network = Cytoscape.getNetworkMap().get(currentNetworkID);
        return network;
    }

    public static Set<CyNetwork> getNetworkSet() {
        return new LinkedHashSet<CyNetwork>(((HashMap)Cytoscape.getNetworkMap()).values());
    }

    public static CyNetwork getNetwork(String id) {
        if (id != null && Cytoscape.getNetworkMap().containsKey(id)) {
            return Cytoscape.getNetworkMap().get(id);
        }
        return nullNetwork;
    }

    public static CyNetworkView getNetworkView(String network_id) {
        if (network_id == null || !Cytoscape.getNetworkViewMap().containsKey(network_id)) {
            return nullNetworkView;
        }
        return Cytoscape.getNetworkViewMap().get(network_id);
    }

    public static boolean viewExists(String network_id) {
        return Cytoscape.getNetworkViewMap().containsKey(network_id);
    }

    public static CyNetworkView getCurrentNetworkView() {
        if (currentNetworkViewID == null || !Cytoscape.getNetworkViewMap().containsKey(currentNetworkViewID)) {
            return nullNetworkView;
        }
        return Cytoscape.getNetworkViewMap().get(currentNetworkViewID);
    }

    public static List<CyNetworkView> getSelectedNetworkViews() {
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        if (!selectedNetworkViews.contains(view)) {
            selectedNetworkViews.add(view);
        }
        return (List)selectedNetworkViews.clone();
    }

    public static void setSelectedNetworkViews(List<String> viewIDs) {
        selectedNetworkViews.clear();
        if (viewIDs == null) {
            return;
        }
        for (String id : viewIDs) {
            CyNetworkView nview = Cytoscape.getNetworkViewMap().get(id);
            if (nview == null || nview == nullNetworkView) continue;
            selectedNetworkViews.add(nview);
        }
        CyNetworkView cv = Cytoscape.getCurrentNetworkView();
        if (cv != nullNetworkView && !selectedNetworkViews.contains(cv)) {
            selectedNetworkViews.add(cv);
        }
    }

    public static List<CyNetwork> getSelectedNetworks() {
        CyNetwork curNet = Cytoscape.getCurrentNetwork();
        if (!selectedNetworks.contains(curNet)) {
            selectedNetworks.add(curNet);
        }
        return (List)selectedNetworks.clone();
    }

    public static void setSelectedNetworks(List<String> ids) {
        selectedNetworks.clear();
        if (ids == null) {
            return;
        }
        for (String id : ids) {
            CyNetwork n = Cytoscape.getNetworkMap().get(id);
            if (n == null || n == nullNetwork) continue;
            selectedNetworks.add(n);
        }
        CyNetwork cn = Cytoscape.getCurrentNetwork();
        if (!selectedNetworks.contains(cn)) {
            selectedNetworks.add(cn);
        }
    }

    public static CytoscapeDesktop getDesktop() {
        if (defaultDesktop == null) {
            defaultDesktop = new CytoscapeDesktop();
        }
        return defaultDesktop;
    }

    public static void setCurrentNetwork(String id) {
        if (Cytoscape.getNetworkMap().containsKey(id)) {
            currentNetworkID = id;
            selectedNetworks.clear();
            selectedNetworks.add(Cytoscape.getNetworkMap().get(id));
        }
    }

    public static boolean setCurrentNetworkView(String id) {
        if (Cytoscape.getNetworkViewMap().containsKey(id)) {
            currentNetworkViewID = id;
            selectedNetworkViews.clear();
            selectedNetworkViews.add(Cytoscape.getNetworkViewMap().get(id));
            return true;
        }
        return false;
    }

    protected static Map<String, CyNetwork> getNetworkMap() {
        if (networkMap == null) {
            networkMap = new HashMap<String, CyNetwork>();
        }
        return networkMap;
    }

    public static Map<String, CyNetworkView> getNetworkViewMap() {
        if (networkViewMap == null) {
            networkViewMap = new HashMap<String, CyNetworkView>();
        }
        return networkViewMap;
    }

    public static void destroyNetwork(String network_id) {
        Cytoscape.destroyNetwork(Cytoscape.getNetworkMap().get(network_id));
    }

    public static void destroyNetwork(CyNetwork network) {
        Cytoscape.destroyNetwork(network, false);
    }

    public static void destroyNetwork(CyNetwork network, boolean destroy_unique) {
        if (network == null || network == nullNetwork) {
            return;
        }
        Cytoscape.getSelectedNetworks().remove(network);
        String networkId = network.getIdentifier();
        Cytoscape.firePropertyChange(NETWORK_DESTROYED, null, networkId);
        network.unselectAllEdges();
        network.unselectAllNodes();
        Map<String, CyNetwork> nmap = Cytoscape.getNetworkMap();
        nmap.remove(networkId);
        if (networkId.equals(currentNetworkID)) {
            if (nmap.size() <= 0) {
                currentNetworkID = null;
            } else {
                Iterator<String> i$ = nmap.keySet().iterator();
                if (i$.hasNext()) {
                    String key;
                    currentNetworkID = key = i$.next();
                }
            }
        }
        if (Cytoscape.viewExists(networkId)) {
            Cytoscape.destroyNetworkView(network);
        }
        if (destroy_unique) {
            boolean add;
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Edge> edges = new ArrayList<Edge>();
            Collection<CyNetwork> networks = networkMap.values();
            for (Node node : nodes) {
                add = true;
                for (CyNetwork net : networks) {
                    if (!net.containsNode(node)) continue;
                    add = false;
                }
                if (!add) continue;
                nodes.add(node);
            }
            for (Edge edge : edges) {
                add = true;
                for (CyNetwork net : networks) {
                    if (!net.containsEdge(edge)) continue;
                    add = false;
                }
                if (!add) continue;
                edges.add(edge);
            }
            for (Node node : nodes) {
                Cytoscape.getRootGraph().removeNode(node);
                node = null;
            }
            for (Edge edge : edges) {
                Cytoscape.getRootGraph().removeEdge(edge);
                edge = null;
            }
        }
        Cytoscape.updateNestedNetworkNodes(network);
        network = null;
        if (currentNetworkID != null && currentNetworkViewID == null) {
            Cytoscape.getDesktop().setFocus(currentNetworkID);
        }
    }

    private static void updateNestedNetworkNodes(GraphPerspective destroyedNetwork) {
        for (CyNode node : Cytoscape.getRootGraph().nodesList()) {
            if (node.getNestedNetwork() != destroyedNetwork) continue;
            node.setNestedNetwork(null);
        }
    }

    public static void destroyNetworkView(CyNetworkView view) {
        if (view == null || view == nullNetworkView) {
            return;
        }
        Cytoscape.getSelectedNetworkViews().remove(view);
        String viewID = view.getIdentifier();
        if (viewID.equals(currentNetworkViewID)) {
            CyNetworkView newCurr;
            currentNetworkViewID = Cytoscape.getNetworkViewMap().size() <= 0 ? null : ((newCurr = Cytoscape.getNetworkViewMap().get(currentNetworkID)) != null ? newCurr.getIdentifier() : null);
        }
        Cytoscape.firePropertyChange("NETWORK_VIEW_DESTROYED", null, view);
        Cytoscape.getNetworkViewMap().remove(viewID);
        view = null;
        if (currentNetworkID != null) {
            Cytoscape.getDesktop().setFocus(currentNetworkID);
        }
    }

    public static void destroyNetworkView(String networkViewID) {
        Cytoscape.destroyNetworkView(Cytoscape.getNetworkViewMap().get(networkViewID));
    }

    public static void destroyNetworkView(CyNetwork network) {
        Cytoscape.destroyNetworkView(Cytoscape.getNetworkViewMap().get(network.getIdentifier()));
    }

    protected static void addNetwork(CyNetwork network, String title, CyNetwork parent, boolean create_view) {
        String parentID;
        Cytoscape.getNetworkMap().put(network.getIdentifier(), network);
        network.setTitle(title);
        parentID = parent != null ? (parentID = parent.getIdentifier()) : null;
        Cytoscape.firePropertyChange(NETWORK_CREATED, parentID, network.getIdentifier());
        String propVal = CytoscapeInit.getProperties().getProperty("viewThreshold");
        if (create_view && propVal != null && network.getNodeCount() < Integer.parseInt(propVal)) {
            Cytoscape.createNetworkView(network);
        }
    }

    public static CyNetwork createNetwork(String title) {
        return Cytoscape.createNetwork(new int[0], new int[0], title, null, true);
    }

    public static CyNetwork createNetwork(String title, boolean create_view) {
        return Cytoscape.createNetwork(new int[0], new int[0], title, null, create_view);
    }

    public static CyNetwork createNetwork(String title, CyNetwork parent, boolean create_view) {
        return Cytoscape.createNetwork(new int[0], new int[0], title, parent, create_view);
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String title) {
        return Cytoscape.createNetwork(nodes, edges, title, null, true);
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String title) {
        return Cytoscape.createNetwork(nodes, edges, title, null, true);
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String child_title, CyNetwork parent) {
        return Cytoscape.createNetwork(nodes, edges, child_title, parent, true);
    }

    public static CyNetwork createNetwork(int[] nodes, int[] edges, String child_title, CyNetwork parent, boolean create_view) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        Cytoscape.addNetwork(network, child_title, parent, create_view);
        return network;
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String child_title, CyNetwork parent) {
        return Cytoscape.createNetwork(nodes, edges, child_title, parent, true);
    }

    public static CyNetwork createNetwork(Collection nodes, Collection edges, String child_title, CyNetwork parent, boolean create_view) {
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        Cytoscape.addNetwork(network, child_title, parent, create_view);
        return network;
    }

    public static CyNetwork createNetworkFromFile(String location) {
        return Cytoscape.createNetworkFromFile(location, true);
    }

    public static CyNetwork createNetworkFromFile(String loc, boolean create_view) {
        return Cytoscape.createNetwork(importHandler.getReader(loc), create_view, null);
    }

    public static CyNetwork createNetworkFromURL(URL url, boolean create_view) {
        return Cytoscape.createNetwork(importHandler.getReader(url), create_view, null);
    }

    public static CyNetwork createNetwork(GraphReader reader, boolean create_view, CyNetwork parent) {
        if (reader == null) {
            throw new RuntimeException("Couldn't read specified file.");
        }
        try {
            reader.read();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (reader instanceof NestedNetworkReader) {
            List<CyNetwork> networks = ((NestedNetworkReader)((Object)reader)).getNetworks();
            Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane().setVisible(false);
            for (CyNetwork network : networks) {
                Cytoscape.getNetworkMap().put(network.getIdentifier(), network);
                if (!create_view || network.getNodeCount() >= Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"))) continue;
                Cytoscape.createNetworkView(network);
            }
            Cytoscape.getDesktop().getNetworkViewManager().getDesktopPane().setVisible(true);
            return networks.get(0);
        }
        int[] nodes = reader.getNodeIndicesArray();
        int[] edges = reader.getEdgeIndicesArray();
        if (nodes == null) {
            logger.warn("Network reader didn't return any nodes");
        }
        if (edges == null) {
            logger.warn("Network reader didn't return any edges");
        }
        String title = reader.getNetworkName();
        CyNetwork network = Cytoscape.getRootGraph().createNetwork(nodes, edges);
        network.setIdentifier(title);
        Cytoscape.addNetwork(network, title, parent, false);
        if (create_view && network.getNodeCount() < Integer.parseInt(CytoscapeInit.getProperties().getProperty("viewThreshold"))) {
            Cytoscape.createNetworkView(network, title, reader.getLayoutAlgorithm());
        }
        reader.doPostProcessing(network);
        return network;
    }

    public static CyAttributes getNodeAttributes() {
        return nodeAttributes;
    }

    public static CyAttributes getEdgeAttributes() {
        return edgeAttributes;
    }

    public static CyAttributes getNetworkAttributes() {
        return networkAttributes;
    }

    public static CyAttributes getOntologyAttributes() {
        return ontologyAttributes;
    }

    public static ExpressionData getExpressionData() {
        return expressionData;
    }

    public static void setExpressionData(ExpressionData expData) {
        expressionData = expData;
    }

    public static boolean loadExpressionData(String filename, boolean copy_atts) {
        try {
            expressionData = new ExpressionData(filename);
        }
        catch (Exception e) {
            String errString = "Unable to load expression data from " + filename;
            logger.warn(errString, e);
        }
        if (copy_atts) {
            expressionData.copyToAttribs(Cytoscape.getNodeAttributes(), null);
            Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
        }
        Cytoscape.firePropertyChange(EXPRESSION_DATA_LOADED, null, expressionData);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAttributes(String[] nodeAttrLocations, String[] edgeAttrLocations) {
        InputStreamReader reader;
        if (nodeAttrLocations != null) {
            for (int i = 0; i < nodeAttrLocations.length; ++i) {
                try {
                    reader = null;
                    try {
                        reader = new InputStreamReader(FileUtil.getInputStream(nodeAttrLocations[i]));
                        CyAttributesReader.loadAttributes(nodeAttributes, reader);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failure loading node attribute data: " + nodeAttrLocations[i] + "  because of:" + e.getMessage());
                }
            }
        }
        if (edgeAttrLocations != null) {
            for (int j = 0; j < edgeAttrLocations.length; ++j) {
                try {
                    reader = null;
                    try {
                        reader = new InputStreamReader(FileUtil.getInputStream(edgeAttrLocations[j]));
                        CyAttributesReader.loadAttributes(edgeAttributes, reader);
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failure loading edge attribute data: " + edgeAttrLocations[j] + "  because of:" + e.getMessage());
                }
            }
        }
    }

    public static OntologyServer buildOntologyServer() {
        try {
            ontologyServer = new OntologyServer();
        }
        catch (Exception e) {
            logger.warn("Could not build OntologyServer.", e);
            return null;
        }
        return ontologyServer;
    }

    public static OntologyServer getOntologyServer() {
        return ontologyServer;
    }

    public static CyNetworkView createNetworkView(CyNetwork network) {
        return Cytoscape.createNetworkView(network, network.getTitle(), null, null);
    }

    public static CyNetworkView createNetworkView(CyNetwork network, String title) {
        return Cytoscape.createNetworkView(network, title, null, null);
    }

    public static CyNetworkView createNetworkView(CyNetwork network, String title, CyLayoutAlgorithm layout) {
        return Cytoscape.createNetworkView(network, title, layout, null);
    }

    public static CyNetworkView createNetworkView(CyNetwork network, String title, CyLayoutAlgorithm layout, VisualStyle vs) {
        if (network == nullNetwork) {
            return nullNetworkView;
        }
        if (Cytoscape.viewExists(network.getIdentifier())) {
            return Cytoscape.getNetworkView(network.getIdentifier());
        }
        DingNetworkView view = new DingNetworkView(network, title);
        VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
        view.setIdentifier(network.getIdentifier());
        view.setTitle(network.getTitle());
        Cytoscape.getNetworkViewMap().put(network.getIdentifier(), view);
        Cytoscape.setSelectionMode(Cytoscape.getSelectionMode(), view);
        if (vs != null) {
            view.setVisualStyle(vs.getName());
            vmm.setVisualStyle(vs);
        } else {
            view.setVisualStyle(vmm.getVisualStyle().getName());
        }
        if (layout == null) {
            layout = CyLayouts.getDefaultLayout();
        }
        vmm.setNetworkView(view);
        vmm.applyAppearances();
        layout.doLayout(view);
        view.setGraphLOD(new CyGraphLOD());
        Cytoscape.firePropertyChange("NETWORK_VIEW_CREATED", null, view);
        return view;
    }

    public static void firePropertyChange(String property_type, Object old_value, Object new_value) {
        PropertyChangeEvent e = new PropertyChangeEvent(pcsO, property_type, old_value, new_value);
        Cytoscape.getSwingPropertyChangeSupport().firePropertyChange(e);
        Cytoscape.getPropertyChangeSupport().firePropertyChange(e);
    }

    public static int getSelectionMode() {
        return currentSelectionMode;
    }

    public static void setSelectionMode(int selectionMode) {
        Map<String, CyNetworkView> networkViewMap = Cytoscape.getNetworkViewMap();
        for (String network_id : networkViewMap.keySet()) {
            GraphView view = networkViewMap.get(network_id);
            Cytoscape.setSelectionMode(selectionMode, view);
        }
        currentSelectionMode = selectionMode;
    }

    public static void setSelectionMode(int selectionMode, GraphView view) {
        switch (selectionMode) {
            case 1: {
                view.disableEdgeSelection();
                view.enableNodeSelection();
                break;
            }
            case 2: {
                view.disableNodeSelection();
                view.enableEdgeSelection();
                break;
            }
            case 3: {
                view.enableNodeSelection();
                view.enableEdgeSelection();
            }
        }
    }

    public static String getCurrentSessionFileName() {
        return currentSessionFileName;
    }

    public static void setCurrentSessionFileName(String newName) {
        currentSessionFileName = newName;
    }

    public static void setSessionState(int state) {
        sessionState = state;
    }

    public static int getSessionstate() {
        return sessionState;
    }

    public static void createNewSession() {
        String[] networkAttrNames;
        String[] edgeAttrNames;
        String[] nodeAttrNames;
        List<CyGroup> groups = CyGroupManager.getGroupList();
        for (CyGroup group : groups) {
            CyGroupManager.removeGroup(group);
        }
        Set<CyNetwork> netSet = Cytoscape.getNetworkSet();
        for (CyNetwork net : netSet) {
            Cytoscape.destroyNetwork(net, true);
        }
        for (String name : nodeAttrNames = nodeAttributes.getAttributeNames()) {
            nodeAttributes.deleteAttribute(name);
        }
        for (String name : edgeAttrNames = edgeAttributes.getAttributeNames()) {
            edgeAttributes.deleteAttribute(name);
        }
        for (String name : networkAttrNames = networkAttributes.getAttributeNames()) {
            networkAttributes.deleteAttribute(name);
        }
        Cytoscape.buildOntologyServer();
        Cytoscape.setOntologyRootID(null);
        Cytoscape.setCurrentSessionFileName(null);
        Cytoscape.firePropertyChange(ATTRIBUTES_CHANGED, null, null);
        cytoscapeRootGraph = null;
        cytoscapeRootGraph = new CytoscapeFingRootGraph();
        logger.info("Cytoscape Session Initialized.");
        System.gc();
    }

    public static String getOntologyRootID() {
        return ontologyRootID;
    }

    public static void setOntologyRootID(String id) {
        ontologyRootID = id;
    }

    public static Bookmarks getBookmarks() throws JAXBException, IOException {
        if (bookmarks == null) {
            BookmarkReader reader = new BookmarkReader();
            reader.readBookmarks();
            bookmarks = reader.getBookmarks();
        }
        return bookmarks;
    }

    public static void setBookmarks(Bookmarks pBookmarks) {
        bookmarks = pBookmarks;
    }

    public static synchronized RecentlyOpenedTracker getRecentlyOpenedSessionTracker() {
        if (recentlyOpenedSessions == null) {
            String trackerFileName = "sessions.tracker";
            try {
                recentlyOpenedSessions = new RecentlyOpenedTracker("sessions.tracker");
            }
            catch (IOException e) {
                System.err.println(e);
                logger.warn("Failed to load \"sessions.tracker\"!");
            }
        }
        return recentlyOpenedSessions;
    }

    static {
        nodeAttributes = new CyAttributesImpl();
        edgeAttributes = new CyAttributesImpl();
        networkAttributes = new CyAttributesImpl();
        ontologyAttributes = new CyAttributesImpl();
        pcsO = new Object();
        pcs = new SwingPropertyChangeSupport(pcsO);
        pcs2 = new Object();
        newPcs = new PropertyChangeSupport(pcs2);
        recentlyOpenedSessions = null;
        nullNetwork = Cytoscape.getRootGraph().createNetwork(new int[0], new int[0]);
        importHandler = new ImportHandler();
        selectedNetworkViews = new LinkedList();
        selectedNetworks = new LinkedList();
        nullNetworkView = new DingNetworkView(nullNetwork, "null");
        VMM = null;
        logger = CyLogger.getLogger(Cytoscape.class);
        eqnAttrTracker = null;
    }
}

