/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf;

import com.sun.glf.Dimension2D_Double;
import com.sun.glf.Renderer;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class StrokeRenderer
implements Renderer {
    private static final Rectangle rect = new Rectangle(0, 0, 1, 1);
    private Paint strokePaint;
    private Dimension2D margins;
    private Stroke stroke;

    public StrokeRenderer(Paint paint, float f) {
        this(paint, new BasicStroke(f));
    }

    public StrokeRenderer(Paint paint, Stroke stroke) {
        if (paint == null || stroke == null) {
            throw new IllegalArgumentException();
        }
        this.strokePaint = paint;
        this.stroke = stroke;
        Shape shape = stroke.createStrokedShape(rect);
        Rectangle2D rectangle2D = shape.getBounds2D();
        this.margins = new Dimension2D_Double(rectangle2D.getWidth() - (double)StrokeRenderer.rect.width, rectangle2D.getHeight() - (double)StrokeRenderer.rect.height);
        if (this.margins.getWidth() < 0.0) {
            this.margins.setSize(0.0, this.margins.getHeight());
        }
        if (this.margins.getHeight() < 0.0) {
            this.margins.setSize(this.margins.getWidth(), 0.0);
        }
    }

    public Dimension2D getMargins() {
        return (Dimension2D)this.margins.clone();
    }

    public void render(Graphics2D graphics2D, Shape shape) {
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.strokePaint);
        graphics2D.draw(shape);
    }
}

