/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class MergingIterator
implements Iterator {
    private final Iterator sourceIt;
    private Iterator currentIt;
    private Object nextVal;

    public MergingIterator(Iterator sourceIt) {
        this.sourceIt = sourceIt;
        this.currentIt = Collections.EMPTY_SET.iterator();
        this.nextVal = this.findNextVal();
    }

    public boolean hasNext() {
        return this.nextVal != null;
    }

    public Object next() {
        Object val = this.nextVal;
        this.nextVal = this.findNextVal();
        return val;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Object findNextVal() {
        while (!this.currentIt.hasNext()) {
            if (!this.sourceIt.hasNext()) {
                return null;
            }
            this.currentIt = ((Collection)this.sourceIt.next()).iterator();
        }
        return this.currentIt.next();
    }
}

