/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class CheckBoxBorderPanel
extends JPanel
implements ItemListener {
    private JCheckBox checkbox;

    public CheckBoxBorderPanel(String title) {
        this(title, null, null);
    }

    public CheckBoxBorderPanel(String title, Border border) {
        this(title, border, null);
    }

    public CheckBoxBorderPanel(String title, LayoutManager layout) {
        this(title, null, layout);
    }

    public CheckBoxBorderPanel(String title, Border border, LayoutManager layout) {
        if (layout == null) {
            layout = new FlowLayout();
        }
        if (border == null) {
            border = BorderFactory.createEtchedBorder();
        }
        this.checkbox = new JCheckBox(title);
        this.setLayout(layout);
        this.setBorder(border);
        this.add((Component)this.checkbox, 0);
        this.checkbox.addItemListener(this);
    }

    public void doLayout() {
        this.setEnabled();
        this.checkbox.setVisible(false);
        super.doLayout();
        this.checkbox.setVisible(true);
        Dimension size = this.checkbox.getPreferredSize();
        this.checkbox.setSize(size);
        this.checkbox.setLocation(20, 0);
    }

    public void itemStateChanged(ItemEvent e) {
        this.setEnabled();
    }

    private void setEnabled() {
        boolean set = this.checkbox.isSelected();
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == this.checkbox) continue;
            children[i].setEnabled(set);
        }
    }

    public void setBorder(Border border) {
        super.setBorder(border == null ? null : new CBBorder(border));
    }

    public JCheckBox getCheckBox() {
        return this.checkbox;
    }

    public static void main(String[] argv) {
        JFrame frame = new JFrame();
        CheckBoxBorderPanel p = new CheckBoxBorderPanel("test");
        p.add(new JButton("Test"));
        frame.setContentPane(p);
        frame.setSize(200, 200);
        frame.show();
    }

    private class CBBorder
    implements Border {
        private Border child;

        CBBorder(Border child) {
            this.child = child;
        }

        public Insets getBorderInsets(Component c) {
            Insets result = (Insets)this.child.getBorderInsets(c).clone();
            result.top = ((CheckBoxBorderPanel)CheckBoxBorderPanel.this).checkbox.getPreferredSize().height;
            return result;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int cHeight = ((CheckBoxBorderPanel)CheckBoxBorderPanel.this).checkbox.getPreferredSize().height / 2;
            this.child.paintBorder(c, g, x, y += cHeight, width, height -= cHeight);
        }
    }
}

