/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data;

import cytoscape.Cytoscape;
import cytoscape.data.ExpressionData;
import cytoscape.data.mRNAMeasurement;
import java.io.File;
import java.util.Vector;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ExpressionDataTest
extends TestCase {
    private static String testDataDir = "testData";
    private static String testDataFilename_1st = "/gal1.22x5.mRNA";
    private static String testDataFilename_2nd = "/gal1.22x5.mRNA_wo_descript";

    public void testExpressionDataLoading() throws Exception {
        this.expressionDataLoading(testDataFilename_1st);
        this.expressionDataLoading(testDataFilename_2nd);
    }

    private void expressionDataLoading(String pTestDataFilename) throws Exception {
        ExpressionData data = new ExpressionData(testDataDir + pTestDataFilename);
        Vector measurements = data.getAllMeasurements();
        ExpressionDataTest.assertTrue(data.getNumberOfGenes() == measurements.size());
        ExpressionDataTest.assertTrue(data.getNumberOfGenes() > 0);
        String geneName = data.getGeneNames()[0];
        ExpressionDataTest.assertTrue(data.getGeneNames().length == data.getNumberOfGenes());
        ExpressionDataTest.assertEquals("YHR051W", geneName);
        String geneDescriptor = data.getGeneDescriptors()[0];
        if (!pTestDataFilename.contains("_wo_descript")) {
            ExpressionDataTest.assertEquals("COX6", geneDescriptor);
        } else {
            ExpressionDataTest.assertEquals("", geneDescriptor);
        }
        String conditionName = data.getConditionNames()[0];
        ExpressionDataTest.assertEquals("gal1RG.sig", conditionName);
        ExpressionDataTest.assertTrue(data.getConditionNames().length == data.getNumberOfConditions());
        Vector geneInfo = (Vector)measurements.get(0);
        mRNAMeasurement measurement = (mRNAMeasurement)geneInfo.get(0);
        ExpressionDataTest.assertEquals(-0.034, measurement.getRatio(), 0.001);
        ExpressionDataTest.assertEquals(1.177, measurement.getSignificance(), 0.001);
        double[][] extremes = data.getExtremeValues();
        ExpressionDataTest.assertEquals(-0.71, extremes[0][0], 0.01);
        ExpressionDataTest.assertEquals(0.432, extremes[0][1], 0.01);
        ExpressionDataTest.assertEquals(-0.717, extremes[1][0], 0.01);
        ExpressionDataTest.assertEquals(27.075, extremes[1][1], 0.01);
    }

    public void testGetMeasurement() throws Exception {
        this.getMeasurement(testDataFilename_1st);
        this.getMeasurement(testDataFilename_2nd);
    }

    private void getMeasurement(String pTestDataFilename) throws Exception {
        ExpressionData data = new ExpressionData(testDataDir + pTestDataFilename);
        for (int i = 0; i < data.getGeneNames().length; ++i) {
            String gene = data.getGeneNames()[i];
            String condition = data.getConditionNames()[0];
            mRNAMeasurement measurement = data.getMeasurement(gene, condition);
            double ratio = measurement.getRatio();
            double sig = measurement.getSignificance();
            ExpressionDataTest.assertTrue(ratio > -100.0);
            ExpressionDataTest.assertTrue(ratio < 1000.0);
            ExpressionDataTest.assertTrue(sig >= -1.0);
            ExpressionDataTest.assertTrue(sig < 10000.0);
        }
    }

    public static void main(String[] args) {
        File tester;
        if (args.length == 1) {
            testDataDir = args[0];
        }
        if (!(tester = new File(testDataDir)).canRead() || !tester.isDirectory()) {
            System.err.println("error! ExpressionDataTest cannot read relative directory '" + testDataDir + "'");
            Cytoscape.exit(1);
        }
        TestRunner.run(new TestSuite(ExpressionDataTest.class));
    }
}

