/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.glf.Anchor;
import com.sun.glf.ImageLayer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.goodies.DirectionalLight;
import com.sun.glf.goodies.ElevationMap;
import com.sun.glf.goodies.LightOp;
import com.sun.glf.goodies.LitSurface;
import com.sun.glf.goodies.LitSurfaceType;
import com.sun.glf.goodies.SpotLight;
import com.sun.glf.util.CompositionComponent;
import com.sun.glf.util.Toolbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public final class LightsStudio {
    private static final double[] lightAngles = new double[]{-0.7853981633974483, 0.0, 0.7853981633974483, 1.5707963267948966, 2.356194490192345, Math.PI, -2.356194490192345, -1.5707963267948966, 0.0};
    private static final Dimension[] lightOffsets = new Dimension[]{new Dimension(0, 0), new Dimension(1, 0), new Dimension(2, 0), new Dimension(2, 1), new Dimension(2, 2), new Dimension(1, 2), new Dimension(0, 2), new Dimension(0, 1), new Dimension(1, 1)};
    public static final String USAGE = "java com.sun.glf.goodies.LightsStudio textureFile width height";

    public static DirectionalLight getSunLight(Anchor anchor, double d, Color color) {
        if (color == null) {
            color = Color.white;
        }
        double[] dArray = new double[3];
        switch (anchor.toInt()) {
            case 1: {
                dArray[0] = 0.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
                break;
            }
            case 5: {
                dArray[0] = 0.0;
                dArray[1] = 1.0;
                dArray[2] = 1.0;
                break;
            }
            case 7: {
                dArray[0] = -1.0;
                dArray[1] = 0.0;
                dArray[2] = 1.0;
                break;
            }
            case 3: {
                dArray[0] = 1.0;
                dArray[1] = 0.0;
                dArray[2] = 1.0;
                break;
            }
            case 0: {
                dArray[0] = -1.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
                break;
            }
            case 2: {
                dArray[0] = 1.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
                break;
            }
            case 6: {
                dArray[0] = -1.0;
                dArray[1] = 1.0;
                dArray[2] = 1.0;
                break;
            }
            case 4: {
                dArray[0] = 1.0;
                dArray[1] = 1.0;
                dArray[2] = 1.0;
                break;
            }
            case 8: {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
                dArray[2] = 1.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid anchor: " + anchor);
            }
        }
        return new DirectionalLight(dArray, d, color);
    }

    public static SpotLight getSpotLight(Rectangle rectangle, Anchor anchor, Dimension dimension, double d, Color color) {
        double d2 = lightAngles[anchor.toInt()];
        int n = Math.min(dimension.width, dimension.height);
        int n2 = Math.max(dimension.width, dimension.height);
        Dimension dimension2 = lightOffsets[anchor.toInt()];
        Rectangle rectangle2 = new Rectangle(rectangle.x - n / 2 + dimension2.width * rectangle.width / 2, rectangle.y + dimension2.height * rectangle.height / 2, n, n2);
        return new SpotLight(rectangle2, color, d, d2);
    }

    public static SpotLight[] getLightRamp(Rectangle rectangle, int n, Anchor anchor, double d, Color color, double d2) {
        double[] dArray = new double[n];
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
            colorArray[i] = color;
        }
        return LightsStudio.getLightRamp(rectangle, n, anchor, dArray, colorArray, d2);
    }

    public static SpotLight[] getLightRamp(Rectangle rectangle, int n, Anchor anchor, double[] dArray, Color[] colorArray, double d) {
        int n2;
        if (n < 1) {
            return null;
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("overlap should be in [0-1] range");
        }
        int n3 = 0;
        int n4 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n5 = 0;
        int n6 = 0;
        double d4 = 0.0;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        switch (anchor.toInt()) {
            case 1: {
                n3 = rectangle.width;
                n4 = 2 * n3 / n;
                n2 = n3 / n;
                n5 = rectangle.x;
                n6 = rectangle.y;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n4 * (1.0 + d));
                rectangle2.x = (int)((double)n5 - (double)n2 * d / 2.0);
                rectangle2.y = n6;
                d2 = 1.0;
                d3 = 0.0;
                d4 = 0.0;
                break;
            }
            case 5: {
                n3 = rectangle.width;
                n4 = 2 * n3 / n;
                n2 = n3 / n;
                n5 = rectangle.x;
                n6 = rectangle.y + rectangle.height;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n4 * (1.0 + d));
                rectangle2.x = (int)((double)n5 - (double)n2 * d / 2.0);
                rectangle2.y = n6;
                d2 = 1.0;
                d3 = 0.0;
                d4 = Math.PI;
                break;
            }
            case 7: {
                n3 = rectangle.height;
                n4 = n3 / n;
                n2 = 2 * n4;
                n5 = rectangle.x;
                n6 = rectangle.y;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n4 * (1.0 + d));
                rectangle2.x = n5;
                rectangle2.y = (int)((double)n6 - (double)n4 * d / 2.0);
                d2 = 0.0;
                d3 = 1.0;
                d4 = 0.0;
                break;
            }
            case 3: {
                n3 = rectangle.height;
                n4 = n3 / n;
                n2 = 2 * n4;
                n5 = rectangle.x + rectangle.width;
                n6 = rectangle.y;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n4 * (1.0 + d));
                rectangle2.x = n5;
                rectangle2.y = (int)((double)n6 - (double)n4 * d / 2.0);
                d2 = 0.0;
                d3 = 1.0;
                d4 = Math.PI;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown anchor : " + anchor);
            }
        }
        SpotLight[] spotLightArray = new SpotLight[n];
        for (int i = 0; i < n; ++i) {
            Color color = Color.white;
            if (colorArray != null && colorArray.length > i && colorArray[i] != null) {
                color = colorArray[i];
            }
            double d5 = dArray != null && dArray.length > i ? dArray[i] : 1.0;
            spotLightArray[i] = new SpotLight(rectangle2, color, d5, d4);
            rectangle2.x += (int)(d2 * (double)n2);
            rectangle2.y += (int)(d3 * (double)n4);
        }
        return spotLightArray;
    }

    public static SpotLight[] getHotSpotLightRamp(Rectangle rectangle, int n, Anchor anchor, double d, Color color, double d2, Point point) {
        double[] dArray = new double[n];
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
            colorArray[i] = color;
        }
        return LightsStudio.getHotSpotLightRamp(rectangle, n, anchor, dArray, colorArray, d2, point);
    }

    public static SpotLight[] getHotSpotLightRamp(Rectangle rectangle, int n, Anchor anchor, double[] dArray, Color[] colorArray, double d, Point point) {
        int n2;
        if (n < 1) {
            return null;
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("overlap should be in [0-1] range");
        }
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        int n5 = 0;
        double d4 = 0.0;
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Point point2 = new Point();
        int n6 = 0;
        switch (anchor.toInt()) {
            case 1: {
                n3 = rectangle.width;
                n6 = 2 * n3 / n;
                n2 = n3 / n;
                n4 = rectangle.x;
                n5 = rectangle.y;
                d2 = 1.0;
                d3 = 0.0;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n6 * (1.0 + d));
                rectangle2.x = (int)((double)n4 - (double)n2 * d / 2.0);
                rectangle2.y = n5;
                point2.x = rectangle.x + n2 / 2;
                point2.y = rectangle.y;
                break;
            }
            case 5: {
                n3 = rectangle.width;
                n6 = 2 * n3 / n;
                n2 = n3 / n;
                n4 = rectangle.x;
                n5 = rectangle.y + rectangle.height;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n6 * (1.0 + d));
                rectangle2.x = (int)((double)n4 - (double)n2 * d / 2.0);
                rectangle2.y = n5;
                d2 = 1.0;
                d3 = 0.0;
                point2.x = rectangle.x + n2 / 2;
                point2.y = rectangle.y + rectangle.height;
                break;
            }
            case 7: {
                n3 = rectangle.height;
                n2 = n3 / n;
                n6 = 2 * n2;
                n4 = rectangle.x - n2 / 2;
                n5 = rectangle.y + n2 / 2;
                d2 = 0.0;
                d3 = 1.0;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n6 * (1.0 + d));
                rectangle2.x = (int)((double)n4 - (double)n2 * d / 2.0);
                rectangle2.y = n5;
                point2.x = rectangle.x;
                point2.y = rectangle.y + n2 / 2;
                break;
            }
            case 3: {
                n3 = rectangle.height;
                n2 = n3 / n;
                n6 = 2 * n2;
                n4 = rectangle.x + rectangle.width - n2 / 2;
                n5 = rectangle.y + n2 / 2;
                d2 = 0.0;
                d3 = 1.0;
                rectangle2.width = (int)((double)n2 * (1.0 + d));
                rectangle2.height = (int)((double)n6 * (1.0 + d));
                rectangle2.x = (int)((double)n4 - (double)n2 * d / 2.0);
                rectangle2.y = n5;
                point2.x = rectangle.x + rectangle.width;
                point2.y = rectangle.y + n2 / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid anchor : " + anchor);
            }
        }
        SpotLight[] spotLightArray = new SpotLight[n];
        double d5 = 0.0;
        double d6 = 1.0;
        for (int i = 0; i < n; ++i) {
            Color color = Color.white;
            if (colorArray != null && colorArray.length > i && colorArray[i] != null) {
                color = colorArray[i];
            }
            double d7 = dArray != null && dArray.length > i ? dArray[i] : 1.0;
            double d8 = point.x - point2.x;
            double d9 = point.y - point2.y;
            double d10 = Math.sqrt(d8 * d8 + d9 * d9);
            if (d10 != 0.0) {
                d8 /= d10;
                d9 /= d10;
            }
            double d11 = Math.atan2(-d8 * d6 + d9 * d5, d8 * d5 + d9 * d6);
            spotLightArray[i] = new SpotLight(rectangle2, color, d7, d11);
            rectangle2.x += (int)(d2 * (double)n2);
            rectangle2.y += (int)(d3 * (double)n2);
            point2.x += (int)(d2 * (double)n2);
            point2.y += (int)(d3 * (double)n2);
        }
        return spotLightArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println(USAGE);
            System.exit(0);
        }
        String string = stringArray[0];
        int n = Integer.parseInt(stringArray[1]);
        int n2 = Integer.parseInt(stringArray[2]);
        Color color = new Color(153, 153, 204);
        JFrame jFrame = new JFrame("LightsStudio Unit Testing");
        int n3 = Toolkit.getDefaultToolkit().getScreenSize().width;
        jFrame.getContentPane().setLayout(new GridLayout(0, n3 / n));
        BufferedImage bufferedImage = Toolbox.loadImage(string, 1);
        ElevationMap elevationMap = new ElevationMap(bufferedImage, true, 10);
        LitSurface litSurface = new LitSurface(0.0, LitSurfaceType.NORMAL, null);
        LitSurface litSurface2 = new LitSurface(0.0, LitSurfaceType.NORMAL, elevationMap);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        Object var14_14 = null;
        Object var15_15 = null;
        Dimension dimension = new Dimension(n, n2);
        String[] stringArray2 = new String[]{"Top", "Bottom", "Right", "Left", "Top Left", "Top Right", "Bottom Left", "Bottom Right", "Center"};
        Anchor[] anchorArray = new Anchor[]{Anchor.TOP, Anchor.BOTTOM, Anchor.RIGHT, Anchor.LEFT, Anchor.TOP_LEFT, Anchor.TOP_RIGHT, Anchor.BOTTOM_LEFT, Anchor.BOTTOM_RIGHT, Anchor.CENTER};
        for (int i = 0; i < stringArray2.length; ++i) {
            litSurface2.removeAllLights();
            litSurface2.addLight(LightsStudio.getSunLight(anchorArray[i], 1.0, color));
            jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface2).filter(bufferedImage2, null), "Sun Light " + stringArray2[i]));
        }
        SpotLight[] spotLightArray = null;
        spotLightArray = LightsStudio.getLightRamp(rectangle, 3, Anchor.TOP, new double[]{4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color}, 0.0);
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Light Ramp. Orientation = TOP"));
        spotLightArray = LightsStudio.getLightRamp(rectangle, 5, Anchor.BOTTOM, new double[]{4.0, 4.0, 4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color, Color.white, Color.yellow}, 0.25);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Light Ramp. Orientation = BOTTOM"));
        spotLightArray = LightsStudio.getLightRamp(rectangle, 2, Anchor.LEFT, new double[]{4.0, 4.0}, new Color[]{Color.white, Color.yellow}, 0.5);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Light Ramp. Orientation = LEFT"));
        spotLightArray = LightsStudio.getLightRamp(rectangle, 3, Anchor.RIGHT, new double[]{4.0, 4.0}, new Color[]{Color.yellow, Color.white, color}, 1.0);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Light Ramp. Orientation = RIGHT"));
        Point point = new Point(n / 2, n2 / 2);
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 3, Anchor.TOP, new double[]{4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color}, 0.0, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = TOP"));
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 5, Anchor.BOTTOM, new double[]{4.0, 4.0, 4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color, Color.white, Color.yellow}, 0.25, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = BOTTOM"));
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 2, Anchor.LEFT, new double[]{4.0, 4.0}, new Color[]{Color.white, Color.yellow}, 0.5, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = LEFT"));
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 3, Anchor.RIGHT, new double[]{4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color}, 1.0, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = RIGHT"));
        point = new Point(n / 4, n2 / 2);
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 3, Anchor.TOP, new double[]{4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color}, 0.0, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = TOP. Hot spot w/4 h/2"));
        point = new Point(3 * n / 4, n2 / 2);
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 5, Anchor.BOTTOM, new double[]{4.0, 4.0, 4.0}, new Color[]{Color.yellow, Color.white, color, Color.white, Color.yellow}, 0.25, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = BOTTOM. Hot spot 3*w/4 h/2"));
        point = new Point(n / 2, 0);
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 2, Anchor.LEFT, null, new Color[]{Color.white, Color.yellow}, 0.5, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = LEFT. Hot spot w/2 0"));
        point = new Point(n / 2, 0);
        spotLightArray = LightsStudio.getHotSpotLightRamp(rectangle, 3, Anchor.RIGHT, null, new Color[]{Color.yellow, Color.white, color}, 1.0, point);
        litSurface.removeAllLights();
        litSurface.addLights(spotLightArray);
        jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Hot Spot Light Ramp. Orientation = RIGHT. Hot spot w/2 0"));
        Dimension dimension2 = new Dimension(n, n2);
        for (int i = 0; i <= 8; ++i) {
            Anchor anchor = Anchor.enumValues[i];
            litSurface.removeAllLights();
            litSurface.addLight(LightsStudio.getSpotLight(rectangle, anchor, dimension2, 1.0, Color.white));
            jFrame.getContentPane().add(LightsStudio.makeNewComponent(dimension, new LightOp(litSurface).filter(bufferedImage2, null), "Spot light " + anchor));
        }
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static Component makeNewComponent(Dimension dimension, Image image, String string) {
        LayerComposition layerComposition = new LayerComposition(dimension);
        ImageLayer imageLayer = new ImageLayer(layerComposition, image, null);
        layerComposition.setLayers(new Layer[]{imageLayer});
        CompositionComponent compositionComponent = new CompositionComponent(layerComposition);
        compositionComponent.setToolTipText(string);
        return compositionComponent;
    }
}

