## ---- echo=FALSE---------------------------------------------------------
library(GenRank)
input_file <- system.file("extdata","CE_toydata.txt",package="GenRank")
toydata <- read.table(input_file,header=FALSE, sep = '\t')
head(toydata)

## ---- echo=FALSE---------------------------------------------------------
library(GenRank)
input_file <- system.file("extdata","CE_toydata.txt",package="GenRank")
toydata <- read.table(input_file,header=FALSE, sep = '\t')
head(toydata[,1:2])

## ------------------------------------------------------------------------
library(GenRank)
input_file <- system.file("extdata","CE_toydata.txt",package="GenRank")
CE_ranks <- ComputeCE(input_file,PC = "equal")
head(CE_ranks)

## ------------------------------------------------------------------------
evid.weight <- c(1,1,0.8,0.8,0.5,1)

## ------------------------------------------------------------------------
file1 <- read.table(input_file, header = FALSE, sep = "\t", stringsAsFactors = FALSE)
names(table(file1[,2]))

## ------------------------------------------------------------------------
CE_ranks_cust <- ComputeCE(input_file,PC = "custom", cust.weights = evid.weight)
head(CE_ranks_cust)

## ------------------------------------------------------------------------
library(GenRank)
input_file <- system.file("extdata","RP_toydata.txt",package="GenRank")
signif.val <- c('L','L','H','L','H','L')
RP_ranks <- ComputeRP(input_file, signif.type = signif.val)
head(RP_ranks)

## ------------------------------------------------------------------------
RP_ranks_cust <- ComputeRP(input_file, signif.type = signif.val, n.perm=200, setseed=1234)
head(RP_ranks_cust)

## ------------------------------------------------------------------------
library(GenRank)
input_file_P <- system.file("extdata","CombP_toydata.txt",package="GenRank")
CP_ranking <- CombP(input_file_P, method = "fisher", na.remove = TRUE)
head(CP_ranking)

## ------------------------------------------------------------------------
cus.weights <- c(100,50,200,300,150,400)
CP_ranking_z <- CombP(input_file_P, method = "z.transform", na.remove = TRUE, weight = cus.weights)
head(CP_ranking_z)

