## ----eval=TRUE, echo=TRUE------------------------------------------------
if (.Platform[['OS.type']] == 'unix') 
{ 
    options('DEsubs_CACHE'=file.path(path.expand("~"), 'DEsubs') ) 
}
if (.Platform[['OS.type']] == 'windows') 
{ 
    options('DEsubs_CACHE'=file.path(
            gsub("\\\\", "/", Sys.getenv("USERPROFILE")), "AppData/DEsubs"))
}

## ----eval=FALSE, echo=TRUE-----------------------------------------------
#  library('DEsubs')
#  
#  load(system.file('extdata', 'data.RData', package='DEsubs'))

## ----setup, echo=FALSE, include=FALSE------------------------------------
# set global chunk options: 

if (.Platform[['OS.type']] == 'unix') 
{ 
    options('DEsubs_CACHE'=file.path(path.expand("~"), 'DEsubs') ) 
}
if (.Platform[['OS.type']] == 'windows') 
{ 
    options('DEsubs_CACHE'=file.path(
            gsub("\\\\", "/", Sys.getenv("USERPROFILE")), "AppData/DEsubs"))
}

library(knitr)
library('DEsubs')
load(system.file('extdata', 'data.RData', package='DEsubs'))

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(    1879, 2734, 2369, 2636, 2188, 9743, 9932, 10099,
            97, 124, 146, 114, 126, 33, 19, 31,
            485, 485, 469, 428, 475, 128, 135, 103,
            '...', '...', '...', '...', '...', '...', '...', '...',
            84, 25, 67, 62, 61, 277, 246, 297,
            120, 312, 78, 514, 210, 324, 95, 102)
data <- matrix(data, nrow=6, ncol=8, byrow=TRUE)

rownames(data) <- c(paste0('Gene ', 1:3), '...',  'Gene N-1', 'Gene N')
colnames(data) <- c(paste0('Case ', 1:4), paste0('Control ', 1:4))

kable( data,
    caption = 'Example of user input format' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(  'Homo sapiens', "'hsa'", 
            'Mus musculus', "'mmu'", 
            'Drosophila melanogaster', "'dme'", 
            'Saccharomyces cerevisiae', "'sce'",
            'Arabidopsis thaliana', "'ath'",
            'Rattus norvegicus', "'rno'",
            'Danio rerio', "'dre'")
data <- matrix(data, nrow=7, ncol=2, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Supported Organisms', 'R command')

kable( data,
    caption = 'DEsubs supported KEGG organisms' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(  'Entrez', "'entrezgene'", 
            'Ensemble', "'ensembl_gene_id', 'ensembl_transcript_id'", 
            '', "'ensembl_peptide_id'",
            'HGNC', "'hgnc_id', 'hgnc_symbol', 'hgnc_transcript_name'",
            'Refseq', "'refseq_mrna', 'refseq_peptide'")
data <- matrix(data, nrow=5, ncol=2, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Supported Labels', 'R command')

kable( data,
    caption = 'Supported gene labels' )

## ---- eval=TRUE, echo=FALSE----------------------------------------------


DEsubs.run <- DEsubs(   org='hsa', 
                        mRNAexpr=mRNAexpr, 
                        mRNAnomenclature='entrezgene', 
                        pathways='All', 
                        DEtool=NULL, 
                        DEpar=0.05,
                        CORtool='pearson', 
                        CORpar=0.7, 
                        subpathwayType=NULL,
                        rankedList=rankedList, verbose=FALSE)

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(  'Pearson product-moment correlation coefficient', "'pearson'", 
            'Spearman rank correlation coefficient', "'spearman'", 
            'Kendall rank correlation coefficient', "'kedhall'")
data <- matrix(data, nrow=3, ncol=2, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Type', 'R command')

kable( data,
    caption = 'Edge Rule options' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(  '**Topological**', '', "",
'Degree', 'Number adjacent interactions of the gene', "'degree'", 
'Betweenness', 'Number of shortest paths from all vertices to all', 
"'betweenness'",
'', 'others that pass through that node', "",
'Closeness', 'Inverse of farness, which is the sum of distances', 
"'closeness'",
'', 'to all other nodes', '',
'Hub score', 'Kleinbergs hub centrality score', "'hub_score'",
'Eccentricity', 'Shortest path distance from the farthest', "'eccentricity'",
'', 'node in the graph', '', 
'Page rank', 'Google Page Rank', "'page_rank'",
'Start Nodes', 'Nodes without any incoming links', "'start_nodes'",
'**Functional**', '', "",
'DEG', 'Genes highly differentially expressed', "'deg'",
'', 'according to the experimental data', '',
'Pathways', 'Genes acting as bridges among KEGG pathways', "'KEGG'",
'Biological Process', 'Genes acting as bridges among', "'GO_bp'",
'', 'Gene Ontology Biological Process terms', '', 
'Cellular Component', 'Genes acting as bridges among', "'GO_cc'",
'', 'Gene Ontology Cellular Component terms', '', 
'Molecular Function', 'Genes acting as bridges among', "'GO_mf'",
'', 'Gene Ontology Molecular Function terms', '', 
'Disease', 'Genes acting as bridges for OMIM targets', "'Disease_OMIM'",
'Disease', 'Genes acting as bridges for GAD targets', "'Disease_GAD'",
'Drug', 'Genes acting as bridges for DrugBank targets', "'Drug_DrugBank'",
'microRNA', 'Genes acting as bridges for microRNA targets', "'miRNA'",
'Transcription Factors', 'Genes acting as bridges for TF targets', "'TF'"
)
data <- matrix(data, nrow=26, ncol=3, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Type', 'Description', 'R parameter')

kable( data,
    caption = 'Gene of interest (GOI) types' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(    
'**Topological**', '', 
'Forward and backward streams starting from',
"'fwd.stream.topological.degree'",
'genes/nodes with crucial topological roles',
"'fwd.stream.topological.betweenness'",
'within the network',               "'fwd.stream.topological.closeness'",
'',                                 "'fwd.stream.topological.hub_score'",
'', "'fwd.stream.topological.eccentricity'",
'', "'fwd.stream.topological.page_rank'",
'', "'fwd.stream.topological.start_nodes'",
'', "'bwd.stream.topological.degree'",
'', "'bwd.stream.topological.betweenness'",
'', "'bwd.stream.topological.closeness'",
'', "'bwd.stream.topological.hub_score'",
'', "'bwd.stream.topological.eccentricity'",
'', "'bwd.stream.topological.page_rank'",
'', "'bwd.stream.topological.start_nodes'",
'**Functional**', '', 
'Forward and backward streams starting from', "'fwd.stream.functional.GO_bp'",
'genes/nodes with crucial functional role',  "'fwd.stream.functional.GO_cc'",
'within the network',                         "'fwd.stream.functional.GO_mf'",
'',                                 "'fwd.stream.functional.Disease_OMIM'",
'', "'fwd.stream.functional.Disease_GAD'",
'', "'fwd.stream.functional.Drug_DrugBank'",
'', "'fwd.stream.functional.miRNA'",
'', "'fwd.stream.functional.TF'",
'', "'fwd.stream.functional.KEGG_pathways'",
'', "'fwd.stream.functional.DEG'",
'', "'bwd.stream.functional.GO_bp'",
'', "'bwd.stream.functional.GOC_cc",
'', "'bwd.stream.functional.GO_mf'",
'', "'bwd.stream.functional.Disease_OMIM'",
'', "'bwd.stream.functional.Disease_GAD'",
'', "'bwd.stream.functional.Drug_DrugBank'",
'', "'bwd.stream.functional.miRNA'",
'', "'bwd.stream.functional.TF'",
'', "'bwd.stream.functional. KEGG_pathways'",
'', "'bwd.stream.functional.DEG'") 
data <- matrix(data, nrow=36, ncol=2, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Desciption', 'R parameter')

kable( data,
    caption = 'Subpathway Options - STREAM' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------


data <- c(    
'**Topological**', '', 
'Forward and backward streams starting from ',
                                "'fwd.neighbourhood.topological.degree'",
'genes/nodes with crucial topological role',
                                "'fwd.neighbourhood.topological.betweenness'",
' within the network',          "'fwd.neighbourhood.topological.closeness'",
'',                             "'fwd.neighbourhood.topological.hub_score'",
'', "'fwd.neighbourhood.topological.eccentricity'",
'', "'fwd.neighbourhood.topological.page_rank'",
'', "'fwd.neighbourhood.topological.start_nodes'",
'', "'bwd.neighbourhood.topological.degree'",
'', "'bwd.neighbourhood.topological.betweenness'",
'', "'bwd.neighbourhood.topological.closeness'",
'', "'bwd.neighbourhood.topological.hub_score'",
'', "'bwd.neighbourhood.topological.eccentricity'",
'', "'bwd.neighbourhood.topological.page_rank'",
'', "'bwd.neighbourhood.topological.start_nodes'",
'**Functional**', '', 
'Forward and backward streams starting from ',     
                                "'fwd.neighbourhood.functional.GO_bp'",
'genes/nodes with crucial functional role ',     
                                "'fwd.neighbourhood.functional.GO_cc'",
'within the network',                                     
                                "'fwd.neighbourhood.functional.GO_mf'",
'',                                                             
                                "'fwd.neighbourhood.functional.Disease_OMIM'",
'', "'fwd.neighbourhood.functional.Disease_GAD'",
'', "'fwd.neighbourhood.functional.Drug_DrugBank'",
'', "'fwd.neighbourhood.functional.miRNA'",
'', "'fwd.neighbourhood.functional.TF'",
'', "'fwd.neighbourhood.functional.KEGG_pathways'",
'', "'fwd.neighbourhood.functional.DEG'",
'', "'bwd.neighbourhood.functional.GO_bp'",
'', "'bwd.neighbourhood.functional.GOC_cc",
'', "'bwd.neighbourhood.functional.GO_mf'",
'', "'bwd.neighbourhood.functional.Disease_OMIM'",
'', "'bwd.neighbourhood.functional.Disease_GAD'",
'', "'bwd.neighbourhood.functional.Drug_DrugBank'",
'', "'bwd.neighbourhood.functional.miRNA'",
'', "'bwd.neighbourhood.functional.TF'",
'', "'bwd.neighbourhood.functional. KEGG_pathways'",
'', "'bwd.neighbourhood.functional.DEG'") 
data <- matrix(data, nrow=36, ncol=2, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Desciption', 'R parameter')

kable( data,
    caption = 'Subpathway Options - NEIGHBOURHOOD' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(    
'**Topological**', '', 
'Forward and backward streams starting from',     
                            "'fwd.cascade.topological.degree'",
'genes/nodes with crucial topological role',     
                            "'fwd.cascade.topological.betweenness'",
'within the network',                                     
                            "'fwd.cascade.topological.closeness'",
'', "'fwd.cascade.topological.hub_score'",
'', "'fwd.cascade.topological.eccentricity'",
'', "'fwd.cascade.topological.page_rank'",
'', "'fwd.cascade.topological.start_nodes'",
'', "'bwd.cascade.topological.degree'",
'', "'bwd.cascade.topological.betweenness'",
'', "'bwd.cascade.topological.closeness'",
'', "'bwd.cascade.topological.hub_score'",
'', "'bwd.cascade.topological.eccentricity'",
'', "'bwd.cascade.topological.page_rank'",
'', "'bwd.cascade.topological.start_nodes'",
'**Functional**', '', 
'Forward and backward streams starting from',
                                    "'fwd.cascade.functional.GO_bp'",
'genes/nodes with crucial functional role',
                                    "'fwd.cascade.functional.GO_cc'",
'within the network',         
                                    "'fwd.cascade.functional.GO_mf'",
'',                       
                                    "'fwd.cascade.functional.Disease_OMIM'",
'', "'fwd.cascade.functional.Disease_GAD'",
'', "'fwd.cascade.functional.Drug_DrugBank'",
'', "'fwd.cascade.functional.miRNA'",
'', "'fwd.cascade.functional.TF'",
'', "'fwd.cascade.functional.KEGG'",
'', "'fwd.cascade.functional.DEG'",
'', "'bwd.cascade.functional.GO_bp'",
'', "'bwd.cascade.functional.GOC_cc",
'', "'bwd.cascade.functional.GO_mf'",
'', "'bwd.cascade.functional.Disease_OMIM'",
'', "'bwd.cascade.functional.Disease_GAD'",
'', "'bwd.cascade.functional.Drug_DrugBank'",
'', "'bwd.cascade.functional.miRNA'",
'', "'bwd.cascade.functional.TF'",
'', "'bwd.cascade.functional.KEGG'",
'', "'bwd.cascade.functional.DEG'") 
data <- matrix(data, nrow=36, ncol=2, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Desciption', 'R parameter')

kable( data,
    caption = 'Subpathway Options - CASCADE' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(     
'Random Walk', 'Community structures that minimize ', "'community.infomap'",
'',             'the expected description length of',         "", 
'',             'a random walker trajectory',             "", 
'Modular', 'Community structures via a modularity ', "'community.louvain'",
'',             'measure and a hierarchical approach',     "", 
'Walktraps',     'Densely connected subgraphs via',  "'community.walktrap'",
'',             'random walks', '',  
'Leading eigen', 'Densely connected subgraphs based ',
"'community.leading_eigen'",
'',             'on the leading non-negative eigen-', '', 
'',             'vector of the modularity matrix', '', 
'Betweeneess','Community structures detection',"'community.edge_betweenness'",
'',             'via edge betweenness', '',
'Greedy', 'Community structures via greedy ', "'community.fast_greedy'",
'',             'optimization of modularity', '') 

data <- matrix(data, nrow=14, ncol=3, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Type', 'Desciption', 'R parameter')

kable( data,
    caption = 'Subpathway Options - COMMUNITY' )

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c('Cliques', 'A subgraph where every two distinct',
"'component.3-cliques', ",
'', 'vertices in the clique are adjacent', "     ....     ",
'', '',  "'component.9-cliques', ",
'K-core', 'A maximal subgraph in which each', "'component.3-coreness'",
'', 'vertex has at least degree k', "     ....     ", 
'', '', "'component.9-coreness'",
'Max cliques', 'Largest of maximal cliques', "'component.max_cliques'",
'Components', 'All single components', "'component.decompose'") 
data <- matrix(data, nrow=8, ncol=3, byrow=TRUE)

rownames(data) <- rep('', nrow(data))
colnames(data) <- c('Type', 'Desciption', 'R parameter')

kable( data,
    caption = 'Subpathway Options - COMPONENT' )

## ---- eval=TRUE, echo=TRUE-----------------------------------------------

DEsubs.run <- DEsubs(
                    org='hsa', 
                    mRNAexpr=mRNAexpr, 
                    mRNAnomenclature='entrezgene', 
                    pathways='All', 
                    DEtool=NULL, DEpar=0.05, 
                    CORtool='pearson', CORpar=0.7,
                    subpathwayType='community.walktrap',
                    rankedList=rankedList, 
                    verbose=FALSE)

## ---- eval=TRUE, echo=FALSE, results = 'asis'----------------------------

data <- c(  'ACAD9', 'ACAD8', 'SH3GLB1', 'ESCO2', 'ESCO1', 'ADH1C', '"0"',
            'ADH1C', 'ADH1B', 'ADHFE1', 'ADH1A', 'ADH6', 'ADH7', 'ADH4',
            '...', '...', '...', '...', '...', '...', '...',
            'PTPN1', 'RHOA', 'ACTN4', 'ACTN3', 'ACTN2', '"0"', '"0"')
data <- matrix(data, nrow=4, ncol=7, byrow=TRUE)

rownames(data) <- c(paste0('Term ', 1:2), '...',  'Term N')
colnames(data) <- paste0('Target ', 1:7)

kable( data,
    caption = 'Example of custom gene set' )

## ----  eval=FALSE, echo=TRUE---------------------------------------------
#  
#  res <- geneVisualization(
#              DEsubs.out=DEsubs.out, top=10,
#              measures.topological=c( 'degree', 'betweenness', 'closeness',
#                                      'eccentricity', 'page_rank'),
#              measures.functional=c(  'KEGG', 'GO_bp','GO_cc', 'GO_mf',
#                                      'Disease_OMIM', 'Disease_GAD',
#                                      'Drug_DrugBank','miRNA', 'TF'),
#              size.topological=c(5,4),
#              size.functional=c(7,4),
#              size.barplot=c(5,6),
#              export='plot', verbose=FALSE)

## ---- echo=FALSE, fig.width=6.2, fig.height=5.2, fig.cap=cap-------------

cap <- 'Bars illustrate the genes with the highest Q-values.'

res <- geneVisualization(  
            DEsubs.out=DEsubs.out, 
            top=10,
            measures.topological=NULL,
            measures.functional=NULL,
            measures.barplot=TRUE,
            size.barplot=c(5,6), 
            export='plot',
            verbose=FALSE)

## ---- echo=FALSE, fig.width=7, fig.height=4, fig.cap=cap-----------------

cap <- 'Heat map represents the twelve genes with the highest values of 
functional measures. The values are scaled and the red graduation indicates 
the value degree.'

res <- geneVisualization(  
            DEsubs.out=DEsubs.out, 
            top=12,
            measures.topological=NULL,
            measures.functional=c(  'KEGG', 'GO_bp','GO_cc', 'GO_mf', 
                                    'Disease_OMIM', 'Disease_GAD', 
                                    'Drug_DrugBank','miRNA', 'TF'),
            measures.barplot=FALSE,
            size.functional=c(7,4), 
            export='plot',
            verbose=FALSE)

## ---- echo=FALSE, fig.width=5, fig.height=4, fig.align="center", fig.cap=cap----

cap <- 'Heat map represents the twelve genes with the highest values of 
topological measures. The values are scaled and the red graduation indicates 
the value degree.'

res <- geneVisualization(  
            DEsubs.out=DEsubs.out, 
            top=12,
            measures.topological=c( 'degree', 'betweenness', 'closeness',
                                    'eccentricity', 'page_rank'),
            measures.functional=NULL,
            measures.barplot=FALSE,
            size.topological=c(5,4), 
            export='plot',
            verbose=FALSE)

## ---- eval=FALSE, echo=TRUE----------------------------------------------
#  
#  res <- subpathwayToGraph(
#                      DEsubs.out=DEsubs.out,
#                      submethod='community.walktrap',
#                      subname='sub6', verbose=FALSE,
#                      export=c('plot', 'gml', 'edgelist') )

## ---- echo=FALSE, fig.width=3.5, fig.height=3.5, fig.cap=cap-------------

library('DEsubs')
load(system.file('extdata', 'data.RData', package='DEsubs'))

cap <- 'Graph illustrates the links of a subpathway. Red graduation 
in nodes indicate the Q-value degree, the edge width indicates the correlation
degree between the respective genes. Green or red color in edges indicates 
the positive or negative correlation respectively'

res <- subpathwayToGraph( 
                    DEsubs.out=DEsubs.out, 
                    submethod='community.walktrap', 
                    subname='sub6', 
                    verbose=FALSE,
                    export=c('plot', 'gml', 'edgelist') )

## ---- eval=FALSE, echo=TRUE----------------------------------------------
#  
#  res <- subpathwayVisualization(
#                      DEsubs.out=DEsubs.out,
#                      references=c('GO', 'TF'),
#                      submethod='community.walktrap',
#                      subname='sub1',
#                      scale=c(1, 1),
#                      export='plot',
#                      verbose=FALSE)
#  

## ---- echo=FALSE, fig.width=3.8, fig.height=3.8, fig.cap=cap-------------

cap <- 'Circular Diagram shows the associations among genes including in a 
subpathway and Gene Ontology terms where are enriched'

library('DEsubs')
load(system.file('extdata', 'data.RData', package='DEsubs'))

res <- subpathwayVisualization( 
                    DEsubs.out=DEsubs.out,  
                    references='GO', 
                    submethod='community.walktrap', 
                    subname='sub1', 
                    scale=1, 
                    export='plot', 
                    verbose=FALSE)

## ---- echo=FALSE, fig.width=4.0, fig.height=4.0, fig.cap=cap-------------

cap <- 'Circular Diagram shows the associations among genes included in a 
subpathway and enriched Transcription Factors.'


res <- subpathwayVisualization( 
                    DEsubs.out=DEsubs.out,  
                    references='TF', 
                    submethod='community.walktrap', 
                    subname='sub1', 
                    scale=1.0, 
                    export='plot', 
                    verbose=FALSE)

## ---- eval=FALSE, echo=TRUE----------------------------------------------
#  
#  res <- organismVisualization(
#                      DEsubs.out=DEsubs.out,
#                      references='KEGG',
#                      topSubs=10,
#                      topTerms=20,
#                      export='plot',
#                      verbose=FALSE)

## ---- echo=FALSE, fig.width=7.4, fig.height=6, fig.cap=cap---------------

cap <- 'Dot plot shows the enriched associations among experiment-specific 
extracted subpathways and pathwaysfrom KEGG database. 
Twenty pathways were selected as the desired number of terms.'


res <- organismVisualization( 
            DEsubs.out=DEsubs.out, 
            references='KEGG', 
            topSubs=10, topTerms=20, 
            export='plot', verbose=FALSE)

