## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,
               fig.width=9,fig.height=5,
               message=FALSE)

## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----package-load,message=FALSE---------------------------------------------------------
library(DEGreport)
data(humanSexDEedgeR)
library(edgeR)

## ----chunk-1----------------------------------------------------------------------------
des<-humanSexDEedgeR$design
fit <- glmFit(humanSexDEedgeR,des)
lrt <- glmLRT(fit)
tab<-cbind(lrt$table,p.adjust(lrt$table$PValue,method="BH"))
detags <- rownames(tab[tab[,5]<=0.1,])
plotSmear(humanSexDEedgeR, de.tags=detags)

## ----chunk-2----------------------------------------------------------------------------
counts<-cpm(humanSexDEedgeR,log=FALSE)
g1<-colnames(counts)[1:41]
g2<-colnames(counts)[42:85]
design<-data.frame(condition=sub("1","Male",sub("0","Female",des[,2])), other=1, row.names=colnames(counts))

## ----chunk-3----------------------------------------------------------------------------
data(geneInfo)

## ----chunk-mean-------------------------------------------------------------------------
degMean(lrt$table$PValue, counts)

## ----chunk-var--------------------------------------------------------------------------
degVar(lrt$table$PValue, counts)

## ----chunk-mean-var---------------------------------------------------------------------
degMV(humanSexDEedgeR$samples$group, lrt$table$PValue, counts)

## ----chunk-qc---------------------------------------------------------------------------
degQC(lrt$table$PValue, counts, humanSexDEedgeR$samples$group)

## ----chunk-mean-dist--------------------------------------------------------------------
degMB(detags,g1,g2,counts)

## ----chunk-var-dist---------------------------------------------------------------------
degVB(detags,g1,g2,counts)

## ----chunk-shiny, eval=FALSE------------------------------------------------------------
#  degObj(counts,design,"degObj.rda")
#  library(shiny)
#  shiny::runGitHub("lpantano/shiny", subdir="expression")

## ----deseq2-----------------------------------------------------------------------------
data(humanSexDEedgeR)
library(DESeq2)
idx <- c(1:10, 75:85)
dse <- DESeqDataSetFromMatrix(humanSexDEedgeR$counts[1:5000, idx],
                              humanSexDEedgeR$samples[idx,], 
                              design=~group)
dse <- DESeq(dse)
res <- results(dse)
resreport <- degResults(dds=dse, name="test", org=NULL, 
do_go=FALSE, group="group", xs="group", path_results = NULL)

## ----deseq2-volcano---------------------------------------------------------------------
res$id <- row.names(res)
show = as.data.frame(res[1:2, c("log2FoldChange", "padj", "id")])
degVolcano(as.data.frame(res[,c("log2FoldChange", "padj")]), plot_text = show)

## ----deseq2-gene-plots------------------------------------------------------------------
degPlot(dds=dse, res = res, n = 6, xs = "group", group = "group")

## ----pattern----------------------------------------------------------------------------
ma = assay(rlog(dse))[row.names(res)[1:100],]
res <- degPatterns(ma, as.data.frame(colData(dse)), time="group", col=NULL)

