/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Random;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.Utils;

public class CostMatrix
extends Matrix {
    public static String FILE_EXTENSION = ".cost";

    public CostMatrix(CostMatrix costMatrix) {
        super(costMatrix.size(), costMatrix.size());
        for (int i = 0; i < costMatrix.size(); ++i) {
            for (int j = 0; j < costMatrix.size(); ++j) {
                this.setElement(i, j, costMatrix.getElement(i, j));
            }
        }
    }

    public CostMatrix(int n) {
        super(n, n);
    }

    public CostMatrix(Reader reader) throws Exception {
        super(reader);
        if (this.numRows() != this.numColumns()) {
            throw new Exception("Trying to create a non-square cost matrix");
        }
    }

    public void initialize() {
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                this.setElement(i, j, i == j ? 0.0 : 1.0);
            }
        }
    }

    public int size() {
        return this.numColumns();
    }

    public Instances applyCostMatrix(Instances instances, Random random) throws Exception {
        int n;
        int n2;
        double d = 0.0;
        if (instances.classIndex() < 0) {
            throw new Exception("Class index is not set!");
        }
        if (this.size() != instances.numClasses()) {
            throw new Exception("Misclassification cost matrix has wrong format!");
        }
        double[] dArray = new double[instances.numClasses()];
        double[] dArray2 = new double[instances.numClasses()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            int n3 = (int)instances.instance(n2).classValue();
            dArray2[n3] = dArray2[n3] + instances.instance(n2).weight();
        }
        double d2 = Utils.sum(dArray2);
        for (n2 = 0; n2 < this.size(); ++n2) {
            if (Utils.eq(this.getElement(n2, n2), 0.0)) continue;
            CostMatrix costMatrix = new CostMatrix(this);
            costMatrix.normalize();
            return costMatrix.applyCostMatrix(instances, random);
        }
        for (n2 = 0; n2 < instances.numClasses(); ++n2) {
            double d3 = 0.0;
            for (n = 0; n < instances.numClasses(); ++n) {
                if (Utils.sm(this.getElement(n2, n), 0.0)) {
                    throw new Exception("Neg. weights in misclassification cost matrix!");
                }
                d3 += this.getElement(n2, n);
            }
            dArray[n2] = d3 * d2;
            d += d3 * dArray2[n2];
        }
        n2 = 0;
        while (n2 < instances.numClasses()) {
            int n4 = n2++;
            dArray[n4] = dArray[n4] / d;
        }
        double[] dArray3 = new double[instances.numInstances()];
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            dArray3[n2] = instances.instance(n2).weight() * dArray[(int)instances.instance(n2).classValue()];
        }
        if (random != null) {
            return instances.resampleWithWeights(random, dArray3);
        }
        Instances instances2 = new Instances(instances);
        for (n = 0; n < instances.numInstances(); ++n) {
            instances2.instance(n).setWeight(dArray3[n]);
        }
        return instances2;
    }

    public double[] expectedCosts(double[] dArray) throws Exception {
        if (dArray.length != this.size()) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        double[] dArray2 = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                int n = i;
                dArray2[n] = dArray2[n] + dArray[j] * this.getElement(j, i);
            }
        }
        return dArray2;
    }

    public double getMaxCost(int n) {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            double d2 = this.getElement(n, i);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public void normalize() {
        for (int i = 0; i < this.size(); ++i) {
            double d = this.getElement(i, i);
            for (int j = 0; j < this.size(); ++j) {
                this.setElement(j, i, this.getElement(j, i) - d);
            }
        }
    }

    public void readOldFormat(Reader reader) throws Exception {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.initialize();
        streamTokenizer.commentChar(37);
        streamTokenizer.eolIsSignificant(true);
        while (-1 != (n = streamTokenizer.nextToken())) {
            if (n == 10) continue;
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double d = streamTokenizer.nval;
            if (!Utils.eq((int)d, d)) {
                throw new Exception("First number in line has to be index of a class!");
            }
            if ((int)d >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            n = streamTokenizer.nextToken();
            if (-1 == n) {
                throw new Exception("Premature end of file!");
            }
            if (n == 10) {
                throw new Exception("Premature end of line!");
            }
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double d2 = streamTokenizer.nval;
            if (!Utils.eq((int)d2, d2)) {
                throw new Exception("Second number in line has to be index of a class!");
            }
            if ((int)d2 >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            if ((int)d2 == (int)d) {
                throw new Exception("Diagonal of cost matrix non-zero!");
            }
            n = streamTokenizer.nextToken();
            if (-1 == n) {
                throw new Exception("Premature end of file!");
            }
            if (n == 10) {
                throw new Exception("Premature end of line!");
            }
            if (n != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double d3 = streamTokenizer.nval;
            if (!Utils.gr(d3, 0.0)) {
                throw new Exception("Only positive weights allowed!");
            }
            this.setElement((int)d, (int)d2, d3);
        }
    }
}

