## ----'installDer', eval = FALSE------------------------------------------
#  ## try http:// if https:// URLs are not supported
#  source("https://bioconductor.org/biocLite.R")
#  biocLite("regionReport")
#  
#  ## Check that you have a valid Bioconductor installation
#  biocValid()

## ----'citation'----------------------------------------------------------
## Citation info
citation('regionReport')

## ----vignetteSetup, echo = FALSE, message = FALSE, warning = FALSE-------
## Track time spent on making the vignette
startTimeVignette <- Sys.time()

## Bib setup
library('knitcitations')

## Load knitcitations with a clean bibliography
cleanbib()
cite_options(hyperlink = 'to.doc', citation_format = 'text', style = 'html')
# Note links won't show for now due to the following issue
# https://github.com/cboettig/knitcitations/issues/63

## Write bibliography information
bibs <- c(knitcitations = citation('knitcitations'), 
    derfinder = citation('derfinder')[1], 
    regionReport = citation('regionReport')[1],
    knitrBootstrap = citation('knitrBootstrap'),
    #BiocStyle = citation('BiocStyle'),
    BiocStyle = RefManageR::BibEntry(bibtype = 'unpublished', key = 'BiocStyle', title = 'BiocStyle: Standard styles for vignettes and other Bioconductor documents', author = 'Martin Morgan and Andrzej Oles and Wolfgang Huber', note = 'R package version 1.8.0', year = '2015'),
    ggbio = citation('ggbio'),
    ggplot2 = citation('ggplot2'),
    knitr = citation('knitr')[3],
    rmarkdown = citation('rmarkdown'),
    DT = citation('DT'),
    R = citation(),
    IRanges = citation('IRanges'),
    devtools = citation('devtools'),
    #GenomeInfoDb = citation('GenomeInfoDb'),
    GenomeInfoDb = RefManageR::BibEntry(bibtype = 'unpublished', key = 'GenomeInfoDb', title = "GenomeInfoDb: Utilities for manipulating chromosome and other 'seqname' identifiers", author = 'Sonali Arora and Martin Morgan and Marc Carlson and H. Pages', note = 'R package version 1.7.3', year = '2015'),
    GenomicRanges = citation('GenomicRanges'),
    #biovizBase = citation('biovizBase'),
    biovizBase = RefManageR::BibEntry(bibtype = 'unpublished', key = 'biovizBase', title = 'biovizBase: Basic graphic utilities for visualization of genomic data.', author = 'Tengfei Yin and Michael Lawrence and Dianne Cook', note = 'R package version 1.19.0', year = '2015'),
    #TxDb.Hsapiens.UCSC.hg19.knownGene = citation('TxDb.Hsapiens.UCSC.hg19.knownGene'),
    TxDb.Hsapiens.UCSC.hg19.knownGene = RefManageR::BibEntry(bibtype = 'unpublished', key = 'TxDb.Hsapiens.UCSC.hg19.knownGene', title = 'TxDb.Hsapiens.UCSC.hg19.knownGene: Annotation package for TxDb object(s)', author = 'Marc Carlson and Bioconductor Package Maintainer', note = 'R package version 3.2.2', year = '2015'),
    derfinderPlot = citation('derfinderPlot')[1],
    grid = citation('grid'),
    gridExtra = citation('gridExtra'),
    mgcv = citation('mgcv'),
    RColorBrewer = citation('RColorBrewer'),
    Cairo = citation('Cairo'),
    whikser = citation('whisker'),
    bumphunter = citation('bumphunter')[1],
    pheatmap = citation('pheatmap'),
    DESeq2 = citation('DESeq2'),
    edgeR1 = citation('edgeR')[1],
    edgeR2 = citation('edgeR')[2],
    edgeR5 = citation('edgeR')[5],
    edgeR6 = RefManageR::BibEntry('inbook', key = 'edgeR6', author = 'Chen, Yunshun and Lun, Aaron T. L. and Smyth, Gordon K.', title = 'Differential expression analysis of complex RNA-seq experiments using edgeR', booktitle = 'Statistical Analysis of Next Generation Sequencing Data', year = 2014, editor = 'Datta, Somnath and Nettleton, Dan', publisher = 'Springer', location = 'New York', pages = '51-74'),
    DEFormats = citation('DEFormats')
)

write.bibtex(bibs,
    file = 'regionReportRef.bib')
bib <- read.bibtex('regionReportRef.bib')

## Assign short names
names(bib) <- names(bibs)

## ---- eval = FALSE-------------------------------------------------------
#  ## Load derfinder
#  library('derfinder')
#  regions <- genomeRegions$regions
#  
#  ## Assign chr length
#  library('GenomicRanges')
#  seqlengths(regions) <- c('chr21' = 48129895)
#  
#  ## The output will be saved in the 'derfinderReport-example' directory
#  dir.create('renderReport-example', showWarnings = FALSE, recursive = TRUE)
#  
#  ## Generate the HTML report
#  report <- renderReport(regions, 'Example run', pvalueVars = c(
#      'Q-values' = 'qvalues', 'P-values' = 'pvalues'), densityVars = c(
#      'Area' = 'area', 'Mean coverage' = 'meanCoverage'),
#      significantVar = regions$qvalues <= 0.05, nBestRegions = 20,
#      outdir = 'renderReport-example')

## ----loadDerfinder-------------------------------------------------------
## Load derfinder
library('derfinder')

## The output will be saved in the 'report' directory
dir.create('report', showWarnings = FALSE, recursive = TRUE)

## ----runDerfinderFake, eval=FALSE----------------------------------------
#  ## Save the current path
#  initialPath <- getwd()
#  setwd(file.path(initialPath, 'report'))
#  
#  ## Generate output from derfinder
#  
#  ## Collapse the coverage information
#  collapsedFull <- collapseFullCoverage(list(genomeData$coverage),
#  verbose=TRUE)
#  
#  ## Calculate library size adjustments
#  sampleDepths <- sampleDepth(collapsedFull, probs=c(0.5), nonzero=TRUE,
#  verbose=TRUE)
#  
#  ## Build the models
#  group <- genomeInfo$pop
#  adjustvars <- data.frame(genomeInfo$gender)
#  models <- makeModels(sampleDepths, testvars=group, adjustvars=adjustvars)
#  
#  ## Analyze chromosome 21
#  analysis <- analyzeChr(chr='21', coverageInfo=genomeData, models=models,
#  cutoffFstat=1, cutoffType='manual', seeds=20140330, groupInfo=group,
#  mc.cores=1, writeOutput=TRUE, returnOutput=TRUE)
#  
#  ## Save the stats options for later
#  optionsStats <- analysis$optionsStats
#  
#  ## Change the directory back to the original one
#  setwd(initialPath)

## ----runDerfinderReal----------------------------------------------------
## Copy previous results
file.copy(system.file(file.path('extdata', 'chr21'), package='derfinder', 
mustWork=TRUE), 'report', recursive=TRUE)

## ----mergeResults--------------------------------------------------------
## Merge the results from the different chromosomes. In this case, there's 
## only one: chr21
mergeResults(chrs = 'chr21', prefix = 'report',
    genomicState = genomicState$fullGenome)
    
## Load optionsStats
load(file.path('report', 'chr21', 'optionsStats.Rdata'))

## ----loadLib, message=FALSE----------------------------------------------
## Load derfindeReport
library('regionReport')

## ----createReport--------------------------------------------------------
## Generate the HTML report
report <- derfinderReport(prefix='report', browse=FALSE,
    nBestRegions=15, makeBestClusters=TRUE, outdir='html',
    fullCov=list('21'=genomeDataRaw$coverage), optionsStats=optionsStats)

## ----vignetteBrowse, eval=FALSE------------------------------------------
#  ## Browse the report
#  browseURL(report)

## ----createVignette, eval=FALSE------------------------------------------
#  ## Create the vignette
#  library('rmarkdown')
#  system.time(render('regionReport.Rmd', 'BiocStyle::html_document'))
#  
#  ## Extract the R code
#  library('knitr')
#  knit('regionReport.Rmd', tangle = TRUE)

## ----createVignette2-----------------------------------------------------
## Clean up
file.remove('regionReportRef.bib')
unlink('report', recursive = TRUE)

## ----vignetteReproducibility1, echo=FALSE--------------------------------
## Date the report was generated
Sys.time()

## ----vignetteReproducibility2, echo=FALSE--------------------------------
## Processing time in seconds
totalTimeVignette <- diff(c(startTimeVignette, Sys.time()))
round(totalTimeVignette, digits=3)

## ----vignetteReproducibility3, echo=FALSE-----------------------------------------------------------------------------
## Session info
library('devtools')
options(width = 120)
session_info()

## ----vignetteBiblio, results='asis', echo=FALSE, warning = FALSE------------------------------------------------------
## Print bibliography
bibliography()

