/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree.utils;

import edu.msu.cme.rdp.taxatree.ConcretRoot;
import edu.msu.cme.rdp.taxatree.Taxon;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewickTreeBuilder<E extends Taxon> {
    private PushbackReader reader;
    private NewickTaxonFactory<E> taxonFactory;
    private ConcretRoot<E> root;
    private int lineno = 1;
    private int col = 1;
    private Map<String, Integer> nameToIdMap = new HashMap<String, Integer>();

    public NewickTreeBuilder(E rootTaxon, InputStream is, NewickTaxonFactory<E> taxonFactory) throws IOException {
        this.root = new ConcretRoot<E>(rootTaxon);
        this.reader = new PushbackReader(new InputStreamReader(is));
        this.taxonFactory = taxonFactory;
        this.parseNewick();
    }

    public NewickTreeBuilder(ConcretRoot<E> root, InputStream is, NewickTaxonFactory<E> taxonFactory) throws IOException {
        this.root = root;
        this.reader = new PushbackReader(new InputStreamReader(is));
        this.taxonFactory = taxonFactory;
        this.parseNewick();
    }

    public ConcretRoot<E> getRoot() {
        return this.root;
    }

    public Integer getTaxidByName(String name) {
        return this.nameToIdMap.get(name);
    }

    private char read() throws IOException {
        int ret = 32;
        do {
            if ((ret = this.reader.read()) == 10) {
                ++this.lineno;
                this.col = 1;
                continue;
            }
            ++this.col;
        } while (ret > 0 && Character.isWhitespace(ret));
        if (ret == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (char)ret;
    }

    private void parseNewick() throws IOException {
        Stack<NewickTaxon<E>> taxaStack = new Stack<NewickTaxon<E>>();
        this.parseTaxon(this.root.getRootTaxid(), taxaStack);
        char next = this.read();
        if (next != ';') {
            this.doError("Unexpected " + next + ", expected ;");
        }
        while (!taxaStack.empty()) {
            NewickTaxon<E> taxon = taxaStack.pop();
            this.root.addChild(taxon.t, taxon.parent);
            this.nameToIdMap.put(((Taxon)taxon.t).getName(), ((Taxon)taxon.t).getTaxid());
        }
    }

    private void parseTaxon(int parentId, Stack<NewickTaxon<E>> taxa) throws IOException {
        int taxid = IdGen.nextId();
        char next = this.read();
        if (next == '(') {
            while (true) {
                this.parseTaxon(taxid, taxa);
                next = this.read();
                if (next != ')') {
                    if (next == ',') continue;
                    this.doError("Unexpected " + next + ", expected ) or ,");
                    continue;
                }
                break;
            }
        } else {
            this.reader.unread(next);
        }
        NewickTaxon taxon = new NewickTaxon();
        taxon.t = this.parseTaxonObject(taxid);
        taxon.parent = parentId;
        taxa.push(taxon);
    }

    private Taxon parseTaxonObject(int taxid) throws IOException {
        StringBuffer buf = new StringBuffer();
        float dist = 0.0f;
        boolean singleQuote = false;
        boolean doubleQuote = false;
        while (true) {
            char next = this.read();
            if (!singleQuote && !doubleQuote && next == ':') {
                dist = this.parseDistance();
                break;
            }
            if (!(singleQuote || doubleQuote || next != ',' && next != ';')) {
                this.reader.unread(next);
                break;
            }
            if (next == '\'' && !doubleQuote) {
                singleQuote = !singleQuote;
            } else if (next == '\"' && !singleQuote) {
                doubleQuote = !doubleQuote;
            }
            buf.append(next);
        }
        String name = buf.toString();
        if (name.length() == 0) {
            name = TaxaNameGen.nextLabel();
        }
        return this.taxonFactory.buildTaxon(taxid, name, dist);
    }

    private float parseDistance() throws IOException {
        StringBuffer ret = new StringBuffer();
        char next = this.read();
        while (Character.isDigit(next) || next == '.' || next == '-') {
            ret.append(next);
            next = this.read();
        }
        this.reader.unread(next);
        float dist = 0.0f;
        try {
            dist = Float.parseFloat(ret.toString());
            if (dist < 0.0f) {
                dist = 0.0f;
            }
        }
        catch (NumberFormatException e) {
            this.doError("Invalid distance value \"" + ret.toString() + "\"");
        }
        return dist;
    }

    private void doError(String message) throws IOException {
        throw new IOException("Error line=" + this.lineno + " col=" + this.col + ": " + message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NewickTaxon<E extends Taxon> {
        E t;
        int parent;

        private NewickTaxon() {
        }
    }

    private static class TaxaNameGen {
        private static int id = 1;

        private TaxaNameGen() {
        }

        public static String nextLabel() {
            return "Unknown_Taxon_" + id++;
        }
    }

    private static class IdGen {
        private static int id = 1;

        private IdGen() {
        }

        public static int nextId() {
            return id++;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NewickTaxonFactory<E extends Taxon> {
        public E buildTaxon(int var1, String var2, float var3);
    }
}

