/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.multicompare.taxon;

import edu.msu.cme.rdp.multicompare.MCSample;
import edu.msu.cme.rdp.taxatree.Taxon;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MCTaxon
extends Taxon {
    protected Map<MCSample, Integer> sampleCountMap = new LinkedHashMap<MCSample, Integer>();
    private Set<String> sequences = new HashSet<String>();
    private String lineage;

    public MCTaxon(int id, String name, String rank) {
        this(id, name, rank, false);
    }

    public MCTaxon(int id, String name, String rank, boolean unclassified) {
        super(id, name, rank, unclassified);
    }

    public MCTaxon(Taxon t) {
        super(t);
    }

    public void addSequence(String seqid) {
        this.sequences.add(seqid);
    }

    public Set<String> getSequences() {
        return Collections.unmodifiableSet(this.sequences);
    }

    public void setLineage(String lineage) {
        this.lineage = lineage;
    }

    public String getLineage() {
        return this.lineage;
    }

    public Set<MCSample> getSamples() {
        return this.sampleCountMap.keySet();
    }

    public int getCount(MCSample s) {
        if (this.sampleCountMap.containsKey(s)) {
            return this.sampleCountMap.get(s);
        }
        return 0;
    }

    public void incCount(MCSample s, int c) {
        Integer i = this.sampleCountMap.get(s);
        if (i == null) {
            i = 0;
        }
        this.sampleCountMap.put(s, i + c);
    }
}

