/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class DateObjectDescription
extends AbstractObjectDescription {
    public DateObjectDescription() {
        super(Date.class);
        this.setParameterDefinition("year", Integer.class);
        this.setParameterDefinition("month", Integer.class);
        this.setParameterDefinition("day", Integer.class);
    }

    public Object createObject() {
        int y = this.getIntParameter("year");
        int m = this.getIntParameter("month");
        int d = this.getIntParameter("day");
        return new GregorianCalendar(y, m, d).getTime();
    }

    private int getIntParameter(String param) {
        Integer p = (Integer)this.getParameter(param);
        if (p == null) {
            return 0;
        }
        return p;
    }

    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Date)) {
            throw new ObjectFactoryException("Is no instance of java.util.Date");
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime((Date)o);
        int year = gc.get(1);
        int month = gc.get(2);
        int day = gc.get(5);
        this.setParameter("year", new Integer(year));
        this.setParameter("month", new Integer(month));
        this.setParameter("day", new Integer(day));
    }
}

