/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level2;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.publicationXref;
import org.biopax.paxtools.model.level2.relationshipXref;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.model.level2.xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;

class ReferenceHelper
implements Serializable {
    private final XReferrable owner;
    private Set<xref> XREF;

    ReferenceHelper(XReferrable owner) {
        this.owner = owner;
        this.XREF = new HashSet<xref>();
    }

    void addXREF(xref XREF_INST) {
        this.XREF.add(XREF_INST);
        XREF_INST.isXREFof().add(this.owner);
    }

    Set<xref> getXREF() {
        return this.XREF;
    }

    void removeXREF(xref XREF_INST) {
        this.XREF.remove(XREF_INST);
        XREF_INST.isXREFof().remove(this.owner);
    }

    void setXREF(Set<xref> XREF) {
        for (xref xref2 : this.XREF) {
            xref2.isXREFof().remove(this.owner);
        }
        this.XREF = XREF == null ? new HashSet() : XREF;
        for (xref xref2 : this.XREF) {
            xref2.isXREFof().add(this.owner);
        }
    }

    Set<unificationXref> findCommonUnifications(XReferrable that) {
        return this.findIntersectionOfType(that, unificationXref.class);
    }

    Set<relationshipXref> findCommonRelationships(XReferrable that) {
        return this.findIntersectionOfType(that, relationshipXref.class);
    }

    Set<publicationXref> findCommonPublications(XReferrable that) {
        return this.findIntersectionOfType(that, publicationXref.class);
    }

    private <T extends xref> Set<T> findIntersectionOfType(XReferrable that, Class<T> type) {
        return SetEquivalenceChecker.findEquivalentIntersection(new ClassFilterSet<xref, T>(this.XREF, type), new ClassFilterSet<xref, T>(that.getXREF(), type));
    }
}

