/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class Sum
extends BaseBuiltin {
    public String getName() {
        return "sum";
    }

    public int getArgLength() {
        return 3;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        BindingEnvironment env = context.getEnv();
        Node n1 = this.getArg(0, args, context);
        Node n2 = this.getArg(1, args, context);
        if (n1.isLiteral() && n2.isLiteral()) {
            Object v1 = n1.getLiteralValue();
            Object v2 = n2.getLiteralValue();
            Node sum = null;
            if (v1 instanceof Number && v2 instanceof Number) {
                Number nv1 = (Number)v1;
                Number nv2 = (Number)v2;
                sum = v1 instanceof Float || v1 instanceof Double || v2 instanceof Float || v2 instanceof Double ? Util.makeDoubleNode(nv1.doubleValue() + nv2.doubleValue()) : Util.makeLongNode(nv1.longValue() + nv2.longValue());
                return env.bind(args[2], sum);
            }
        }
        return false;
    }
}

