/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ontocat.special;

import junit.framework.TestCase;
import uk.ac.ebi.ontocat.OntologyService;
import uk.ac.ebi.ontocat.OntologyTerm;
import uk.ac.ebi.ontocat.bioportal.BioportalOntologyService;
import uk.ac.ebi.ontocat.ols.OlsOntologyService;
import uk.ac.ebi.ontocat.utils.OntologyParser;

public class OntologyParserTest
extends TestCase {
    private OntologyParser op;

    protected void setUp() throws Exception {
        super.setUp();
        this.op = new OntologyParser();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.op = null;
    }

    public void testOntologyParser() throws Exception {
        if (this.op != null) {
            System.out.println("ONTOLOGY'S RELATION NAMES:");
            for (String relation : this.op.getOntologyRelationNames()) {
                System.out.println(relation);
            }
            OntologyTerm term = this.op.getTermById("EFO_0000806");
            System.out.println("TERM'S \"" + term.getLabel() + "\" RELATION NAMES:");
            for (String relation : this.op.getTermRelationNames(term)) {
                System.out.println(relation);
            }
            System.out.println("TERM'S \"" + term.getLabel() + "\" RELATIONS (is_location_of_disease):");
            for (OntologyTerm ot : this.op.getTermRelations(term, "is_location_of_disease")) {
                System.out.println(ot.getLabel());
            }
            System.out.println("TERM'S \"" + term.getLabel() + "\" PARTONOMY:");
            this.op.showTermPartonomy(term);
            OntologyTerm termFail = this.op.getTermById("AA_0000502");
            System.out.println("SEARCH TERM:");
            for (OntologyTerm ot : this.op.searchTerm("electrically")) {
                System.out.println(ot);
            }
            System.out.println("SEARCH TERM PREFIX:");
            for (OntologyTerm ot : this.op.searchTermPrefix("T3")) {
                System.out.println(ot);
            }
            System.out.println("GET ALL TERMS:");
            for (OntologyTerm ot : this.op.getAllTerms()) {
                System.out.println(ot);
            }
            System.out.println("GET ALL TERM IDS:");
            for (String st : this.op.getAllTermIds()) {
                System.out.println(st);
            }
            System.out.println("GET ROOTS:");
            for (OntologyTerm ot : this.op.getRoots()) {
                System.out.println(ot);
            }
            System.out.println("GET ROOT IDS:");
            for (String st : this.op.getRootIds()) {
                System.out.println(st);
            }
            System.out.println("GET EFO BRANCH ROOTS:");
            for (OntologyTerm ot : this.op.getEFOBranchRoots()) {
                System.out.println(ot);
            }
            System.out.println("GET EFO BRANCH ROOT IDS:");
            for (String st : this.op.getEFOBranchRootIds()) {
                System.out.println(st);
            }
            System.out.println("GET TERM NAME BY ID:");
            System.out.println(this.op.getTermNameById("CL_0000502"));
            System.out.println(this.op.getTermNameById("AA_0000502"));
            System.out.println("GET TERM NAME:");
            System.out.println(this.op.getTermName(term));
            System.out.println(this.op.getTermName(termFail));
            System.out.println("GET TERM DEFINITIONS:");
            for (String st : this.op.getTermDefinitions(term)) {
                System.out.println(st);
            }
            for (String st : this.op.getTermDefinitions(termFail)) {
                System.out.println(st);
            }
            System.out.println("GET TERM SYNONYMS:");
            for (String st : this.op.getTermSynonyms(term)) {
                System.out.println(st);
            }
            for (String st : this.op.getTermSynonyms(termFail)) {
                System.out.println(st);
            }
            System.out.println("CHECK TERM:");
            System.out.println(this.op.hasTerm("CL_0000502"));
            System.out.println(this.op.hasTerm("AA_0000502"));
            System.out.println("CHECK ROOT TERM BY ID:");
            System.out.println(this.op.isRoot("CL_0000502"));
            System.out.println(this.op.isRoot("CL_0000000"));
            System.out.println(this.op.isRoot("AA_0000502"));
            System.out.println("CHECK ROOT TERM:");
            System.out.println(this.op.isRoot(term));
            System.out.println(this.op.isRoot(termFail));
            System.out.println("CHECK EFO BRANCH ROOT TERM BY ID:");
            System.out.println(this.op.isEFOBranchRoot("CL_0000502"));
            System.out.println(this.op.isEFOBranchRoot("CL_0000000"));
            System.out.println(this.op.isEFOBranchRoot("AA_0000502"));
            System.out.println("CHECK EFO BRANCH ROOT TERM:");
            System.out.println(this.op.isEFOBranchRoot(term));
            System.out.println(this.op.isEFOBranchRoot(termFail));
            System.out.println("HIERARCHY:");
            this.op.showHierarchyDownToTerm("CL_0000502");
            this.op.showPathsToTerm("CL_0000502");
            this.op.showHierarchyDownToTerm(term);
            this.op.showPathsToTerm(term);
            this.op.showHierarchyDownToTerm("AA_0000502");
            this.op.showHierarchyDownToTerm(termFail);
            this.op.showPathsToTerm(termFail);
            System.out.println("PARSER FOR BIOPORTAL 1158:");
            BioportalOntologyService los = new BioportalOntologyService();
            OntologyParser bop = new OntologyParser((OntologyService)los, "1158");
            for (OntologyTerm ot : bop.getRoots()) {
                System.out.println(ot.getAccession());
            }
            System.out.println(bop.getOntologyDescription());
            System.out.println("PARSER FOR OLS EHDA:");
            OlsOntologyService los2 = new OlsOntologyService();
            OntologyParser bop2 = new OntologyParser((OntologyService)los2, "EHDA");
            for (OntologyTerm ot : bop2.getRoots()) {
                System.out.println(ot.getAccession());
            }
            System.out.println(bop2.getOntologyDescription());
        }
    }
}

