/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.debugger.commands;

import java.io.PrintWriter;
import org.semanticweb.HermiT.debugger.Debugger;
import org.semanticweb.HermiT.debugger.DerivationHistory;
import org.semanticweb.HermiT.debugger.DerivationViewer;
import org.semanticweb.HermiT.debugger.commands.AbstractCommand;
import org.semanticweb.HermiT.tableau.Node;

public class DerivationTreeCommand
extends AbstractCommand {
    public DerivationTreeCommand(Debugger debugger) {
        super(debugger);
    }

    public String getCommandName() {
        return "dertree";
    }

    public String[] getDescription() {
        return new String[]{"clash", "shows the derivation tree for the clash", "predicate [nodeID]+", "shows the derivation tree for the given atom"};
    }

    public void printHelp(PrintWriter printWriter) {
        printWriter.println("usage: dertree clash");
        printWriter.println("    Shows the derivation tree for the clash.");
        printWriter.println("usage: dertree predicate [nodeID]+");
        printWriter.println("    Shows the derivation tree for the given atom.");
        printWriter.println("    yellow: DL clause application");
        printWriter.println("    cyan: disjunct application (choose and apply a disjunct)");
        printWriter.println("    blue: merged two nodes");
        printWriter.println("    dark grey: description graph checking");
        printWriter.println("    black: clash");
        printWriter.println("    red: existential expansion");
        printWriter.println("    magenta: base/given fact");
    }

    public void execute(String[] stringArray) {
        Object[] objectArray;
        if (stringArray.length < 2) {
            this.m_debugger.getOutput().println("The specification of the predicate is missing.");
            return;
        }
        String string = stringArray[1];
        if ("clash".equals(string.toLowerCase())) {
            objectArray = new Object[]{};
        } else {
            objectArray = new Object[stringArray.length - 1];
            try {
                objectArray[0] = this.getDLPredicate(string);
            }
            catch (Exception exception) {
                this.m_debugger.getOutput().println("Invalid predicate '" + string + "':" + exception.getMessage());
            }
            if (objectArray[0] == null) {
                this.m_debugger.getOutput().println("Invalid predicate '" + string + "'.");
                return;
            }
        }
        for (int i = 1; i < objectArray.length; ++i) {
            int n;
            try {
                n = Integer.parseInt(stringArray[i + 1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_debugger.getOutput().println("Invalid ID of the node at argument " + i + ".");
                return;
            }
            Node node = this.m_debugger.getTableau().getNode(n);
            if (node == null) {
                this.m_debugger.getOutput().println("Node with ID '" + n + "' not found.");
                return;
            }
            objectArray[i] = node;
        }
        DerivationHistory.Atom atom = this.m_debugger.getDerivationHistory().getAtom(objectArray);
        if (atom != null) {
            new DerivationViewer(this.m_debugger.getPrefixes(), atom);
            this.selectConsoleWindow();
        } else {
            this.m_debugger.getOutput().println("Atom not found.");
        }
    }
}

