/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.Set;
import org.coode.owlapi.rdfxml.parser.HasKeyListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.OptimisedListTranslator;
import org.coode.owlapi.rdfxml.parser.TriplePredicateHandler;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class TPHasKeyHandler
extends TriplePredicateHandler {
    private OptimisedListTranslator<OWLPropertyExpression> listTranslator = new OptimisedListTranslator<OWLPropertyExpression>(this.getConsumer(), new HasKeyListItemTranslator(this.getConsumer()));

    public TPHasKeyHandler(OWLRDFConsumer consumer) {
        super(consumer, OWLRDFVocabulary.OWL_HAS_KEY.getIRI());
    }

    public boolean canHandleStreaming(IRI subject, IRI predicate, IRI object) {
        this.getConsumer().addClassExpression(subject, false);
        return false;
    }

    public void handleTriple(IRI subject, IRI predicate, IRI object) throws UnloadableImportException {
        if (this.getConsumer().isClassExpression(subject)) {
            this.consumeTriple(subject, predicate, object);
            OWLClassExpression ce = this.translateClassExpression(subject);
            Set<OWLPropertyExpression> props = this.listTranslator.translateToSet(object);
            this.addAxiom(this.getDataFactory().getOWLHasKeyAxiom(ce, props, this.getPendingAnnotations()));
        }
    }
}

