## ----style, echo = FALSE, results = 'asis'-------------------------------
BiocStyle::markdown()

## ----lkd, cache=TRUE-----------------------------------------------------
suppressPackageStartupMessages(library(ldblock))
path = dir(system.file("hapmap", package="ldblock"), full=TRUE)
ceu17 = hmld(path, poptag="CEU", chrom="chr17")
ceu17

## ----abc, fig=TRUE, fig.width=7, fig.height=7----------------------------
library(Matrix)
image(ceu17@ldmat[1:400,1:400], 
   col.reg=heat.colors(120), colorkey=TRUE, useRaster=TRUE)

## ----getg----------------------------------------------------------------
library(gwascat)
data(ebicat37)
seqlevelsStyle(ebicat37) = "NCBI"
e17 = ebicat37[ which(seqnames(ebicat37) == "17") ]

## ----getrs---------------------------------------------------------------
rsh17 = unique(e17$SNPS)
head(rsh17)

## ----doexpa--------------------------------------------------------------
length(rsh17)
exset = expandSnpSet( rsh17, ldstruct= ceu17, lb=.9 )
length(exset)
all(rsh17 %in% exset)

