test_fit_led <- function() {
    library(flowCore)
    library(flowQBData)
    fcs_directory <- system.file("extdata", "SSFF_LSRII", 
        "LED_Series", package="flowQBData")
    fcs_file_path_list <- list.files(fcs_directory, "*.fcs", full.names= TRUE)
    
    ignore_channels <- c("Time", "FSC-A", "FSC-W", "FSC-H", 
        "SSC-A", "SSC-W", "SSC-H")
    dyes <- c("APC", "APC-Cy7", "APC-H7", "FITC", "PE", "PE-Cy7", "PerCP", 
        "PerCP-Cy55", "V450", "V500-C")
    detectors <- c("APC-A", "APC-Cy7-A", "APC-Cy7-A", "FITC-A", "PE-A", 
        "PE-Cy7-A", "PerCP-Cy5-5-A", "PerCP-Cy5-5-A", "Pacific Blue-A", 
        "Aqua Amine-A")
    bounds <- list(minimum = -100, maximum = 100000)
    signal_type <- "Area"
    instrument_name <- "LSRII"

    led_results <- fit_led(fcs_file_path_list, ignore_channels, dyes, 
        detectors, signal_type, instrument_name, bounds = bounds,
        minimum_useful_peaks = 3, max_iterations = 10)

    ## Fits are being checked in all details
    expected_fits_c0 <- c(
        97.5456094689457, 409.233836898034, 103.447871646762,
        -154.315670949759, 312.628908188591, 72.4722211591131,
        224.481864056377, 68.8059632383273, 338.166380851089,
        166.94891475164, 300.996574741915, 238.044004386844,
        419.844214136208, 239.774206135396, 341.688776218363,
        160.799177514026, 275.426507607051, 9.30624928437482,
        268.695580197899, -353.075272925968, 43.6881487831744,
        -152.391370183232, 68.855973943612, 43.6412803992173,
        54.7775386047556, -75.9854109123077, 84.3998042043891,
        87.4197836909638, 74.7383787382777, 62.6444547423221,
        64.4561103737055, 14.0326829678873, 69.300543473386,
        45.460423661618, 93.4738634025946, -10.9238534593521
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c0',]), expected_fits_c0, 1e-5), 1,
        function(x) {
            if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
        })))
    
    expected_fits_c0se <- c(
        0.541699550502571, 19.1620392471639, 0.801966682990562,
        72.3318655508524, 2.40581410403137, 23.0511934815152,
        1.8866063084185, 14.4036565541777, 2.6928693809305,
        31.8522657690699, 2.34848472750344, 51.7600483062689,
        2.75762809099363, 111.684447487825, 2.17311071453231,
        78.4445620833546, 1.99199915025164, 32.7886999324635,
        3.31189774657042, 100.442706740149, 0.481298987397454,
        31.5931098323025, 0.533265830097803, 22.4985853322598,
        0.456455208348159, 345.819733378484, 0.631455708495964,
        15.4698845277121, 0.466827434762608, 15.3888745490549,
        0.507501873260459, 25.4743131760709, 0.383291334331904,
        10.2273084098886, 0.638469957427783, 34.9073775721497
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c0 SE',]), 
            expected_fits_c0se, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c0p <- c(
        1.96874475592105e-26, 4.17355852051007e-06, 1.42515122699907e-25, 
        0.0768434108814442, 5.60948133861622e-23, 0.0255518694774276,
        1.92400865057409e-22, 0.00307234299172259, 1.94620529187001e-21,
        0.00335009636582528, 3.41465458501942e-20, 0.00584567352840326,
        4.33029457207758e-21, 0.0845769940910687, 3.89696111780676e-24,
        0.0862605607379679, 1.03321993432394e-24, 0.784756042632861,
        2.35046677451076e-22, 0.0170061540366185, 5.65639344424312e-22,
        0.00191358966482439, 1.40263623987763e-25, 0.0935715931636889,
        4.52007251266124e-25, 0.834773791113974, 1.71709706459687e-24,
        0.00240991686866448, 4.50623642412798e-27, 0.00657016949765504,
        1.82634245759712e-25, 0.601624850370089, 6.44362998039887e-28,
        0.00435240590136014, 1.88284383640527e-26, 0.769964828519711
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c0 P',]), 
            expected_fits_c0p, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))

    expected_fits_c1 <- c(
        1.10290510163207, 2.24026631214985, 5.17755215137334,
        10.3078788696501, 1.60016745069267, 1.68638874980258,
        2.89703331871532, 2.93043753178901, 3.61036929997928,
        3.57697690233222, 3.7891634514763, 3.70212391568151,
        5.09232232267477, 5.05688004822917, 6.37478667301232,
        6.30677579032335, 5.56694747890997, 5.4890038898808,
        14.0029872293698, 13.9515232556145, 4.04403053208548,
        9.68513503769357, 2.28764383588041, 5.46654852616153,
        10.8152776671986, 25.7260360903185, 1.19537161004058,
        2.1711600522241, 0.658658293954315, 1.22955692355825,
        2.45654295131437, 4.59706188930715, 1.62301364277436,
        3.05743908886104, 3.16629767102649, 5.98423533189895
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c1',]), 
            expected_fits_c1, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c1se <- c(
        0.00725797188645377, 0.0151656976249323, 0.0312156701134579,
        0.104131046095479, 0.0170160162578118, 0.0475385845093945,
        0.0276252221441078, 0.029270030102357, 0.0270893884660799,
        0.0404400728759655, 0.0246684163846036, 0.0409700180473779,
        0.0283685400588459, 0.0879476924966566, 0.0331186653643788,
        0.0755895757809885, 0.0356681726001694, 0.0543103941038644,
        0.157368704355336, 0.170045055042722, 0.0252766903600071,
        0.0715667444697187, 0.015961466962551, 0.0362438058465308,
        0.0675726267387461, 0.357935984371984, 0.00871742513397431,
        0.0155850311094181, 0.00476869085897853, 0.0250690695394189,
        0.0178135015185097, 0.0341546806251514, 0.0103883419040359,
        0.0228362853500499, 0.0309975648690772, 0.0892005731686066
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c1 SE',]), 
            expected_fits_c1se, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c1p <- c(
        2.50906685320819e-25, 2.69714543886014e-10, 2.55930194024447e-27,
        7.16261289478171e-11, 5.16665657301066e-21, 3.35008684388147e-07,
        1.12545923274676e-21, 6.69215154781275e-11, 8.98560658328939e-22,
        3.5009689427082e-09, 3.89353736688336e-21, 3.14637279525826e-09,
        6.00553604324829e-22, 3.01027681125841e-08, 2.29851442704617e-25,
        1.99640518473692e-10, 1.68040849051205e-25, 2.44667055351644e-12,
        5.37770720233289e-23, 5.09711888551379e-09, 1.15914231453559e-25,
        3.17320362170119e-13, 2.64517181994095e-26, 1.48594803095882e-13,
        4.52626219976331e-27, 9.87565594335752e-09, 1.16998612666065e-24,
        3.61529132793307e-10, 4.77674097688725e-26, 4.81727275955298e-09,
        4.89889187732256e-26, 1.13434595301265e-11, 6.66029269251727e-27,
        1.17092243392637e-11, 5.93531671783713e-24, 2.95763210666151e-07
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c1 P',]), 
            expected_fits_c1p, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))

    expected_fits_c2 <- c(
        -6.55956064724152e-07, -6.71855911336056e-07, -1.11359519749824e-06,
        3.38016994912796e-07, -2.2354780776823e-07, -1.55440885550087e-06,
        -1.05861920598525e-06, -2.50406788400029e-08, 1.0198268806321e-06,
        -5.89943574227676e-07, -2.72796143164385e-06, -1.42478781464577e-06,
        -8.81721130273936e-07, -1.69083719619699e-06, -3.14986448126124e-06,
        -1.22892695810603e-06, 1.12925233311478e-06, -4.82154852626122e-08,
        -2.29202077070306e-06, -3.37922379607335e-06, -2.29486086601629e-06,
        -4.40785919024369e-06, -2.00772455112443e-06, -2.85777156295577e-06,
        7.03202478371621e-06, 3.18143124520113e-06, -1.28768437164342e-06,
        -1.62945315761677e-06, 9.67600905403856e-07, 1.6299189662059e-06,
        -4.75373944458258e-07, -8.12766462609441e-07, -3.6440995213787e-06,
        -4.5249758187983e-06, 1.18477093218695e-05, 1.49445120598109e-05
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c2',]), 
              expected_fits_c2, 1e-5), 1, function(x) {
                  if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
              }
    )))
    
    expected_fits_c2se <- c(
        2.7602835152544e-07, 3.027163487669e-07, 1.1994793598035e-06,
        3.39001148994413e-06, 5.89436378771728e-07, 1.87028819406193e-06,
        1.30452555734292e-06, 7.71131340120386e-07, 8.66792121685246e-07,
        1.3248700386038e-06, 1.08526594333212e-06, 9.43621469960074e-07,
        1.37214049246527e-06, 2.16868592510892e-06, 1.16470570808328e-06,
        1.61630803350434e-06, 1.43278195413958e-06, 1.35555990281967e-06,
        1.24434019948573e-05, 1.20412497599966e-05, 9.08942003569157e-07,
        1.84943599280023e-06, 8.63645930063354e-07, 8.81347745587261e-07,
        8.53810663817747e-06, 1.57554150291181e-05, 2.42328082803405e-07,
        4.33038007890826e-07, 1.66081893365774e-07, 9.03982353311555e-07,
        1.10417832832178e-06, 1.11126712222686e-06, 1.04253842322637e-06,
        1.30737035211899e-06, 1.06734179171585e-05, 1.52578404670833e-05
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c2 SE',]), 
            expected_fits_c2se, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c2p <- c(
        0.0312305690193773, 0.0771841332829077, 0.366995711500685,
        0.923822886447631, 0.710187400318763, 0.443777423882169,
        0.430661404967946, 0.975148399878756, 0.260468877112865,
        0.674731367052622, 0.0272255848496337, 0.191449750871034,
        0.53257697388634, 0.470866615029426, 0.0171075906691407,
        0.475863428641857, 0.442884842609092, 0.972619317461,
        0.856174247655652, 0.790230203539891, 0.0233356839690143,
        0.0486417288992125, 0.0335717637643957, 0.0142038070466683,
        0.422271492284761, 0.847932981475045, 8.67445188872264e-05,
        0.01311912230709, 2.57845002975473e-05, 0.12143957145369,
        0.672558588897673, 0.492106981791967, 0.00299241546999109,
        0.013448739043939, 0.283394993006936, 0.382808167402508
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c2 P',]), 
            expected_fits_c2p, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))

    expected_fits_c0f <- c(
        97.7032982879942, 429.155756446676, 103.528717949154,
        -157.988520570062, 312.762808728334, 81.1868850310872,
        224.668327503333, 69.0025800740837, 337.688780663863,
        173.981098169768, 302.059694913877, 278.206188408969,
        420.156620457616, 284.818300845532, 342.535689618292,
        190.696022610348, 275.202717043657, 9.84238810453576,
        268.765373090759, -336.348089286846, 43.8527745356094,
        -120.314500274022, 69.0265922892773, 76.9749009899233,
        54.7402034141668, -116.634159672932, 84.8448529312681,
        116.860639017731, 74.3743282241847, 49.6948921479073,
        64.4845829917343, 23.5238401872493, 69.484881085942,
        63.678082615809, 93.3702132968109, -33.1675381938747
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c0\'',]), 
            expected_fits_c0f, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c0fse <- c(
        0.610727185057108, 21.7748607505118, 0.793980631437816,
        57.6799342060048, 2.31085327768266, 19.992209078578,
        1.85112438459627, 12.1007982379094, 2.69838562670015,
        25.7472373994182, 2.74220469812275, 48.9096354980489,
        2.65243405917602, 92.4041107749052, 2.56336952624412,
        65.800619872129, 1.94817829392701, 27.2404250479592,
        3.19529821883707, 74.3808887048673, 0.551162400171176,
        35.9855996085388, 0.592675268110563, 29.6106923846952,
        0.449880940808057, 257.734330879372, 1.02885518157662,
        23.8475264651736, 0.792944104491407, 15.6461160259282,
        0.49097003194596, 21.1804960152042, 0.489121335670064,
        14.0534540234955, 0.635902673975112, 26.4019923092473
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c0\' SE',]), 
              expected_fits_c0fse, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))

    expected_fits_c0fp <- c(
        4.56053890028981e-27, 1.10628813524544e-06, 5.97568364267063e-27,
        0.0289576385747452, 1.42296990332514e-24, 0.00664354603399675,
        7.28839760582018e-24, 0.000733591664384627, 9.49949094693263e-23,
        0.000512518284269989, 1.06789202823046e-20, 0.00127384433362244,
        9.52633506504684e-23, 0.0215990609096441, 1.72326721507648e-24,
        0.02304868570319, 3.33460380712549e-26, 0.727219785773736,
        1.0188320534927e-23, 0.00400917700022058, 3.20845187316924e-22,
        0.010179496138801, 4.06793921345263e-26, 0.0316392248810701,
        1.93457367434233e-26, 0.666784376329042, 1.81137040648116e-22,
        0.00270999900458473, 1.60445981657991e-24, 0.0155732217631345,
        5.28309211641876e-27, 0.303412612404918, 1.39364005773095e-27,
        0.00269605956378686, 7.95226740062607e-28, 0.264524581856477
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c0\' P',]), 
            expected_fits_c0fp, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c1f <- c(
        1.09249288518429, 2.21574080153402, 5.16148106291938,
        10.3154190007601, 1.59600878360465, 1.65814819333823,
        2.88355862406732, 2.9298029610343, 3.62917571061006,
        3.5638483328937, 3.7513195213373, 3.65615646601159,
        5.08116315366637, 5.00594833787949, 6.32343863398982,
        6.26470088191203, 5.58342310190409, 5.48765654801064,
        13.9861467315406, 13.9138983336615, 4.00971427396926,
        9.57319940288111, 2.26580554548181, 5.38436462804923,
        10.8455414914419, 25.7830440603459, 1.16748424474404,
        2.12796850972818, 0.675303341448448, 1.26176466915733,
        2.45205818599484, 4.57871151173056, 1.5999063010667,
        2.99827763288564, 3.18937108129532, 6.05730795445998
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c1\'',]), 
            expected_fits_c1f, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c1fse <- c(
        0.00657307994676646, 0.0133595844353688, 0.0258704972453363,
        0.0663319843348466, 0.0126350022850464, 0.0323780976132281,
        0.0218252043292941, 0.0201765097216653, 0.0221690263670306,
        0.0257633281354693, 0.0231966772526693, 0.0302004686739658,
        0.0219196842954255, 0.0569276548092173, 0.0323466542340596,
        0.0499170363719642, 0.0285563163829191, 0.0364091120437336,
        0.124393159264964, 0.0962332348138267, 0.0246318576703454,
        0.0679856166038162, 0.0144797359693016, 0.0383329414594732,
        0.0561691456732198, 0.201676171333888, 0.0114423898145863,
        0.0188383551285022, 0.00654425257833505, 0.020220167130779,
        0.0140996583151718, 0.0223911173416936, 0.0103242251399804,
        0.0242695025488801, 0.0231515017483945, 0.0486975109886425
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c1\' SE',]), 
            expected_fits_c1fse, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    expected_fits_c1fp <- c(
        2.47607197639704e-27, 3.24114977088013e-12, 4.34682930801578e-30,
        1.19960146279236e-13, 4.0046638440176e-24, 3.71934541802707e-09,
        2.04247042406482e-24, 1.93811754826499e-13, 2.21654135926536e-24,
        9.62593387930949e-12, 7.27929952449568e-23, 2.14175908565464e-11,
        6.75996135234507e-25, 1.45693810498921e-10, 5.7449176667036e-27,
        5.37791618421808e-13, 1.84294243101653e-28, 4.20003444427837e-15,
        7.39812625085514e-26, 7.38302210105194e-12, 3.45316765932368e-27,
        7.23547132070198e-15, 2.69691581588504e-28, 7.38049805421591e-15,
        7.58133979744231e-30, 1.54457044781194e-11, 6.04324977163406e-24,
        3.24514811690313e-11, 3.17474710734287e-25, 7.12841674082198e-11,
        4.4844182195893e-29, 1.76553539799191e-14, 3.18158255923103e-28,
        6.00452775770219e-13, 2.34896782022452e-27, 6.36998945918586e-10
    )
    checkTrue(all(apply(
        cbind(as.numeric(led_results$fits['c1\' P',]), 
            expected_fits_c1fp, 1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
    )))
    
    ## The rest of the results will be checked as well, but not to such
    ## a great extent since one error would likely impact many things

    checkTrue(
        apply(cbind(
            sum(led_results$iterated_fits), 10803.2138769121, 1e-5), 
            1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[1]], na.rm=TRUE), 864726.388688922,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[2]], na.rm=TRUE), 1490652.93776911,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[3]], na.rm=TRUE), 1367286.40570405,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[4]], na.rm=TRUE), 3130343.22627266,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[5]], na.rm=TRUE), 1299395.27243239,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[6]], na.rm=TRUE), 1339254.85078651,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[7]], na.rm=TRUE), 1948997.47201088,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[8]], na.rm=TRUE), 1627006.06382322,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[9]], na.rm=TRUE), 2375530.948295,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    checkTrue(
        apply(cbind(
            sum(led_results$peak_stats[[10]], na.rm=TRUE), 2738814.36380929,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    x <- 0
    for(i in 1:length(led_results$peak_stats)) {
        x = x + sum(led_results$peak_stats[[i]], na.rm=TRUE)    
    }
    checkTrue(
        apply(cbind(x, 65654034.6531254, 1e-5), 1, function(x) {
            if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
        }))
    
    checkTrue(
        apply(cbind(
            sum(led_results$bg_stats), 720874.07164,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))

    checkTrue(
        apply(cbind(
            sum(led_results$dye_bg_stats), 200093.951503735,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    checkTrue(
        apply(cbind(
            sum(led_results$dye_fits), 2460.56810222963,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))

    checkTrue(
        apply(cbind(
            sum(led_results$fits), 10788.6161991899,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))

    checkTrue(
        apply(cbind(
            sum(led_results$iterated_fits), 10803.2138769121,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    checkTrue(
        apply(cbind(
            sum(led_results$iterated_dye_fits), 2463.01996306341,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    checkTrue(
        apply(cbind(
            sum(unlist(qb_from_fits(led_results$iterated_dye_fits))),
            630.780755321259,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))

    checkTrue(
        apply(cbind(
            sum(unlist(qb_from_fits(led_results$iterated_fits))),
            1700.66866141411,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    checkTrue(
        apply(cbind(
            sum(unlist(qb_from_fits(led_results$dye_fits))),
            630.999235064801,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
    
    checkTrue(
        apply(cbind(
            sum(unlist(qb_from_fits(led_results$fits))),
            1699.77719217736,
            1e-5), 1, function(x) {
                if (abs(x[[1]] - x[[2]]) < x[[3]]) TRUE else FALSE
            }
        ))
}

test_qb_from_fits_error <- function() {
    checkTrue(tryCatch(
        {
            qb_from_fits(c(1,2,3));
        },
        interrupt = function(ex) { "interrupt"; },
        error = function(ex) { "error"; }
    ) == "error")
}
