### R code from vignette source 'flowDensityVignette.Rnw'

###################################################
### code chunk number 1: flowDensityVignette.Rnw:85-97
###################################################
library(flowCore)
library(flowDensity)
library(GEOmap)
data_dir <- system.file("extdata", package = "flowDensity")
load(list.files(pattern = 'sampleFCS_1', data_dir, full = TRUE))
f
lymph <- flowDensity(obj=f, channels=c('FSC-A', 'SSC-A'),
                     position=c(TRUE, FALSE), upper= c(NA, TRUE), 
                     debris.gate=c(TRUE, FALSE))
sglt  <- flowDensity(obj=lymph, singlet.gate=TRUE)
bcell <- flowDensity(obj=sglt, channels=c(9, 3),
                     position=c(FALSE, NA))


###################################################
### code chunk number 2: plotBcell
###################################################
plot(getflowFrame(sglt), bcell)


###################################################
### code chunk number 3: flowDensityVignette.Rnw:106-107
###################################################
plot(getflowFrame(sglt), bcell)


###################################################
### code chunk number 4: flowDensityVignette.Rnw:136-142
###################################################
CD19pCD20n <- flowDensity(obj=bcell, channels=c(8, 6),
                        position=c(T,F))
plasmablasts <- flowDensity(obj=CD19pCD20n, channels=c(5, 12),
                            position=c(T, T))
plotDens(getflowFrame(CD19pCD20n), plasmablasts@channels, pch=19)
points(plasmablasts@filter, type='l', col=2, lwd=2)


###################################################
### code chunk number 5: plotPlasmablasts
###################################################
#devn=FALSE is used so that Sweave can save the plot as pdf
plotDens(getflowFrame(CD19pCD20n), plasmablasts@channels, pch=19, devn=FALSE)
points(plasmablasts@filter, type='l', col=2, lwd=2)


###################################################
### code chunk number 6: flowDensityVignette.Rnw:153-154
###################################################
#devn=FALSE is used so that Sweave can save the plot as pdf
plotDens(getflowFrame(CD19pCD20n), plasmablasts@channels, pch=19, devn=FALSE)
points(plasmablasts@filter, type='l', col=2, lwd=2)


###################################################
### code chunk number 7: flowDensityVignette.Rnw:182-185
###################################################
f <- nmRemove(f, c("FSC-A", "SSC-A"))
#plotDens(f, c("FSC-A", "SSC-A"), devn=F)
#plot(f, lymph)


###################################################
### code chunk number 8: flowDensityVignette.Rnw:190-204
###################################################
load(list.files(pattern = 'sampleFCS_2', data_dir, full = TRUE))
f2
channels <- c("V500-A", "SSC-A")
# First call to flowDensity
tmp.cp1 <- flowDensity(obj=f2, channels=channels,
                      position=c(TRUE, FALSE), percentile=c(0.25, NA))
# Second call to flowDensity
tmp.cp2 <- flowDensity(obj=tmp.cp1, channels=channels,
                       position=c(TRUE, FALSE), gates=c(FALSE, NA), 
                       percentile=c(NA, 0.85))
# Final call to flowDensity
lymph <- flowDensity(obj=f2, channels=channels,
                     position=c(TRUE, FALSE), gates=c(tmp.cp1@gates[1], 
                     tmp.cp2@gates[2]), ellip.gate=TRUE, scale=.99)


###################################################
### code chunk number 9: plotTmp1
###################################################
plot(f2, tmp.cp1)


###################################################
### code chunk number 10: plotLymph2
###################################################
plot(f2, tmp.cp2)


###################################################
### code chunk number 11: plotFinalLymph2
###################################################
plotDens(flow.frame=f2, channels=channels, devn=F)
points(lymph@filter, type="l", col=2, lwd=2)


###################################################
### code chunk number 12: flowDensityVignette.Rnw:222-223
###################################################
plot(f2, tmp.cp1)


###################################################
### code chunk number 13: flowDensityVignette.Rnw:225-226
###################################################
plot(f2, tmp.cp2)


###################################################
### code chunk number 14: flowDensityVignette.Rnw:235-236
###################################################
plotDens(flow.frame=f2, channels=channels, devn=F)
points(lymph@filter, type="l", col=2, lwd=2)


###################################################
### code chunk number 15: flowDensityVignette.Rnw:264-274
###################################################
load(list.files(pattern = 'sampleFCS_3.Rdata', data_dir, full = TRUE))
f3
load(list.files(pattern = 'sampleFCS_3_FMO', data_dir, full = TRUE))
f3.fmo
f3.gated <- flowDensity(obj=f3, channels=c('BV421-A', 'FSC-A'),
                        position = c(TRUE, NA),use.control = c(TRUE, F)
                        , control = c(f3.fmo, NA))
f3.fmo.gated <- flowDensity(obj=f3.fmo, channels=c('BV421-A', 'FSC-A'),
                            position=c(TRUE, NA),
                            gates=c(f3.gated@gates[1], NA))


###################################################
### code chunk number 16: fmoDefault1
###################################################
plot(f3.fmo, f3.fmo.gated)


###################################################
### code chunk number 17: fmoDefault2
###################################################
plot(f3, f3.gated)


###################################################
### code chunk number 18: flowDensityVignette.Rnw:287-288
###################################################
plot(f3.fmo, f3.fmo.gated)


###################################################
### code chunk number 19: flowDensityVignette.Rnw:290-291
###################################################
plot(f3, f3.gated)


###################################################
### code chunk number 20: flowDensityVignette.Rnw:302-309
###################################################
f3.gated.98p <- flowDensity(obj=f3, channels=c('BV421-A', 'FSC-A'),
                            position = c(TRUE, NA),use.percentile = c(TRUE, NA),
                            percentile = 0.98, use.control = c(TRUE, FALSE),
                            control = c(f3.fmo, NA))
f3.fmo.gated.98p <- flowDensity(obj=f3.fmo, channels=c('BV421-A', 'FSC-A'),
                                position = c(TRUE, NA),
                                gates=c(f3.gated.98p@gates[1], NA))


###################################################
### code chunk number 21: fmoPercentile1
###################################################
plot(f3.fmo, f3.fmo.gated.98p)


###################################################
### code chunk number 22: fmoPercentile2
###################################################
plot(f3, f3.gated.98p)


###################################################
### code chunk number 23: flowDensityVignette.Rnw:322-323
###################################################
plot(f3.fmo, f3.fmo.gated.98p)


###################################################
### code chunk number 24: flowDensityVignette.Rnw:325-326
###################################################
plot(f3, f3.gated.98p)


