## ---- eval = FALSE-------------------------------------------------------
#  source("http://www.bioconductor.org/biocLite.R")
#  biocLite("anamiR")

## ------------------------------------------------------------------------
library(anamiR)

## ------------------------------------------------------------------------
data(mrna)
data(mirna)
data(pheno.mirna)
data(pheno.mrna)

## ------------------------------------------------------------------------
mrna[1:5,1:5]

## ------------------------------------------------------------------------
mirna[1:5,1:5]

## ------------------------------------------------------------------------
pheno.mrna[1:3,1:3]

## ---- eval = FALSE-------------------------------------------------------
#  se <- normalization(data = mirna, method = "quantile")

## ------------------------------------------------------------------------

mrna_se <- SummarizedExperiment(
    assays = SimpleList(counts=mrna),
    colData = pheno.mrna)

mirna_se <- SummarizedExperiment(
    assays = SimpleList(counts=mirna),
    colData = pheno.mirna)


## ------------------------------------------------------------------------
mrna_d <- differExp_discrete(se = mrna_se,
    class = "ER", method = "t.test",
    t_test.var = FALSE, log2 = FALSE,
    p_value.cutoff = 0.05,  foldchange = 0.5
)

mirna_d <- differExp_discrete(se = mirna_se,
   class = "ER", method = "t.test",
   t_test.var = FALSE, log2 = FALSE,
   p_value.cutoff = 0.05,  foldchange = 0.5
)

## ------------------------------------------------------------------------
nc <- ncol(mrna_d)
mrna_d[1:5, (nc-4):nc]

## ------------------------------------------------------------------------
mirna_21 <- miR_converter(data = mirna_d, remove_old = TRUE,
    original_version = 17, latest_version = 21)

## ------------------------------------------------------------------------
# Before
head(row.names(mirna_d))
# After
head(row.names(mirna_21))

## ------------------------------------------------------------------------
cor <- negative_cor(mrna_data = mrna_d, mirna_data = mirna_21,
    method = "pearson", cut.off = -0.5)

## ------------------------------------------------------------------------
head(cor)

## ------------------------------------------------------------------------
heat_vis(cor, mrna_d, mirna_21)

## ------------------------------------------------------------------------
sup <- database_support(cor_data = cor,
    org = "hsa", Sum.cutoff = 3)

## ------------------------------------------------------------------------
head(sup)

## ------------------------------------------------------------------------
path <- enrichment(data_support = sup, org = "hsa", per_time = 1000)

## ------------------------------------------------------------------------
head(path)

