/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientVertexRenderer<V, E>
implements Renderer.Vertex<V, E> {
    Color colorOne;
    Color colorTwo;
    Color pickedColorOne;
    Color pickedColorTwo;
    PickedState<V> pickedState;
    boolean cyclic;

    public GradientVertexRenderer(Color colorOne, Color colorTwo, boolean cyclic) {
        this.colorOne = colorOne;
        this.colorTwo = colorTwo;
        this.cyclic = cyclic;
    }

    public GradientVertexRenderer(Color colorOne, Color colorTwo, Color pickedColorOne, Color pickedColorTwo, PickedState<V> pickedState, boolean cyclic) {
        this.colorOne = colorOne;
        this.colorTwo = colorTwo;
        this.pickedColorOne = pickedColorOne;
        this.pickedColorTwo = pickedColorTwo;
        this.pickedState = pickedState;
        this.cyclic = cyclic;
    }

    @Override
    public void paintVertex(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        Graph<V, E> graph = layout.getGraph();
        if (rc.getVertexIncludePredicate().evaluate(Context.getInstance(graph, v))) {
            float y;
            boolean vertexHit = true;
            Shape shape = rc.getVertexShapeTransformer().transform(v);
            Point2D p = (Point2D)layout.transform(v);
            p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
            float x = (float)p.getX();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y = (float)p.getY());
            shape = xform.createTransformedShape(shape);
            vertexHit = this.vertexHit(rc, shape);
            if (vertexHit) {
                this.paintShapeForVertex(rc, v, shape);
            }
        }
    }

    protected boolean vertexHit(RenderContext<V, E> rc, Shape s) {
        JComponent vv = rc.getScreenDevice();
        Rectangle deviceRectangle = null;
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        return rc.getMultiLayerTransformer().getTransformer(Layer.VIEW).transform(s).intersects(deviceRectangle);
    }

    protected void paintShapeForVertex(RenderContext<V, E> rc, V v, Shape shape) {
        Paint drawPaint;
        GraphicsDecorator g = rc.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Rectangle r = shape.getBounds();
        float y2 = (float)r.getMaxY();
        if (this.cyclic) {
            y2 = (float)(r.getMinY() + r.getHeight() / 2.0);
        }
        GradientPaint fillPaint = null;
        fillPaint = this.pickedState != null && this.pickedState.isPicked(v) ? new GradientPaint((float)r.getMinX(), (float)r.getMinY(), this.pickedColorOne, (float)r.getMinX(), y2, this.pickedColorTwo, this.cyclic) : new GradientPaint((float)r.getMinX(), (float)r.getMinY(), this.colorOne, (float)r.getMinX(), y2, this.colorTwo, this.cyclic);
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(shape);
            g.setPaint(oldPaint);
        }
        if ((drawPaint = rc.getVertexDrawPaintTransformer().transform(v)) != null) {
            g.setPaint(drawPaint);
        }
        Stroke oldStroke = g.getStroke();
        Stroke stroke = rc.getVertexStrokeTransformer().transform(v);
        if (stroke != null) {
            g.setStroke(stroke);
        }
        g.draw(shape);
        g.setPaint(oldPaint);
        g.setStroke(oldStroke);
    }
}

