/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.dialect;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.apache.axiom.util.stax.dialect.BEAStreamReaderWrapper;
import org.apache.axiom.util.stax.wrapper.XMLInputFactoryWrapper;

class BEAInputFactoryWrapper
extends XMLInputFactoryWrapper {
    public BEAInputFactoryWrapper(XMLInputFactory parent) {
        super(parent);
    }

    public XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        return this.createXMLStreamReader(null, stream);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        String encoding;
        byte[] startBytes = new byte[4];
        try {
            int c;
            boolean useMark = stream.markSupported();
            if (useMark) {
                stream.mark(4);
            } else {
                stream = new PushbackInputStream(stream, 4);
            }
            int read = 0;
            do {
                if ((c = stream.read(startBytes, read, 4 - read)) != -1) continue;
                throw new XMLStreamException("Unexpected end of stream");
            } while ((read += c) < 4);
            if (useMark) {
                stream.reset();
            } else {
                ((PushbackInputStream)stream).unread(startBytes);
            }
        }
        catch (IOException ex) {
            throw new XMLStreamException("Unable to read start bytes", ex);
        }
        int marker = (startBytes[0] & 0xFF) << 24 + (startBytes[1] & 0xFF) << 16 + (startBytes[2] & 0xFF) << 8 + (startBytes[3] & 0xFF);
        switch (marker) {
            case -16842752: 
            case -131072: 
            case 60: 
            case 15360: 
            case 65279: 
            case 65534: 
            case 0x3C0000: 
            case 0x3C000000: {
                encoding = "UCS-4";
                break;
            }
            case 3932223: {
                encoding = "UTF-16BE";
                break;
            }
            case 1006649088: {
                encoding = "UTF-16LE";
                break;
            }
            case 1010792557: {
                encoding = "UTF-8";
                break;
            }
            default: {
                encoding = (marker & 0xFFFF0000) == -16842752 ? "UTF-16BE" : ((marker & 0xFFFF0000) == -131072 ? "UTF-16LE" : "UTF-8");
            }
        }
        XMLStreamReader reader = systemId == null ? super.createXMLStreamReader(stream) : super.createXMLStreamReader(systemId, stream);
        return new BEAStreamReaderWrapper(reader, encoding);
    }

    public XMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        return new BEAStreamReaderWrapper(super.createXMLStreamReader(stream, encoding), null);
    }

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return new BEAStreamReaderWrapper(super.createXMLStreamReader(reader), null);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        return new BEAStreamReaderWrapper(super.createXMLStreamReader(source), null);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return new BEAStreamReaderWrapper(super.createXMLStreamReader(systemId, reader), null);
    }
}

