/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.attachments.BoundaryDelimitedStream;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.attachments.MIMEBodyPartInputStream;
import org.apache.axiom.attachments.MultipartAttachmentStreams;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.impl.PartFactory;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.LifecycleManagerImpl;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.util.DetachableInputStream;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Attachments
implements OMAttachmentAccessor {
    ContentType contentType;
    int contentLength;
    byte[] boundary;
    String applicationType;
    PushbackInputStream pushbackInStream;
    int PUSHBACK_SIZE = 4096;
    DetachableInputStream filterIS = null;
    TreeMap attachmentsMap;
    ArrayList cids = new ArrayList();
    int partIndex = 0;
    IncomingAttachmentStreams streams = null;
    private boolean streamsRequested = false;
    private boolean partsRequested = false;
    private boolean endOfStreamReached;
    private boolean noStreams = false;
    private String firstPartId;
    private boolean fileCacheEnable;
    private String attachmentRepoDir;
    private int fileStorageThreshold;
    private LifecycleManager manager;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$attachments$Attachments == null ? (class$org$apache$axiom$attachments$Attachments = Attachments.class$("org.apache.axiom.attachments.Attachments")) : class$org$apache$axiom$attachments$Attachments));
    static /* synthetic */ Class class$org$apache$axiom$attachments$Attachments;

    public LifecycleManager getLifecycleManager() {
        if (this.manager == null) {
            this.manager = new LifecycleManagerImpl();
        }
        return this.manager;
    }

    public void setLifecycleManager(LifecycleManager manager) {
        this.manager = manager;
    }

    public Attachments(LifecycleManager manager, InputStream inStream, String contentTypeString, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) throws OMException {
        this(manager, inStream, contentTypeString, fileCacheEnable, attachmentRepoDir, fileThreshold, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attachments(LifecycleManager manager, InputStream inStream, String contentTypeString, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold, int contentLength) throws OMException {
        this.manager = manager;
        this.contentLength = contentLength;
        this.attachmentRepoDir = attachmentRepoDir;
        this.fileCacheEnable = fileCacheEnable;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attachments contentLength=" + contentLength + ", contentTypeString=" + contentTypeString));
        }
        this.fileStorageThreshold = fileThreshold != null && !"".equals(fileThreshold) ? Integer.parseInt(fileThreshold) : 1;
        this.attachmentsMap = new TreeMap();
        try {
            this.contentType = new ContentType(contentTypeString);
        }
        catch (ParseException e) {
            throw new OMException("Invalid Content Type Field in the Mime Message", e);
        }
        try {
            String boundaryParam;
            String encoding = this.contentType.getParameter("charset");
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            if ((boundaryParam = this.contentType.getParameter("boundary")) == null) {
                throw new OMException("Content-type has no 'boundary' parameter");
            }
            this.boundary = ("--" + boundaryParam).getBytes(encoding);
            if (log.isDebugEnabled()) {
                log.debug((Object)("boundary=" + new String(this.boundary)));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new OMException(e);
        }
        InputStream is = inStream;
        if (contentLength <= 0) {
            this.filterIS = new DetachableInputStream(inStream);
            is = this.filterIS;
        }
        this.pushbackInStream = new PushbackInputStream(is, this.PUSHBACK_SIZE);
        try {
            while (true) {
                int boundaryIndex;
                int value;
                if ((byte)(value = this.pushbackInStream.read()) == this.boundary[0]) {
                } else {
                    if ((byte)value != -1) continue;
                    throw new OMException("Mime parts not found. Stream ended while searching for the boundary");
                }
                for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                    value = this.pushbackInStream.read();
                    if (value != -1) continue;
                    throw new OMException("Unexpected End of Stream while searching for first Mime Boundary");
                }
                if (boundaryIndex == this.boundary.length) break;
            }
            this.pushbackInStream.read();
        }
        catch (IOException e1) {
            throw new OMException("Stream Error" + e1.toString(), e1);
        }
        this.getDataHandler(this.getSOAPPartContentID());
        this.partsRequested = false;
    }

    public Attachments(InputStream inStream, String contentTypeString, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) throws OMException {
        this(null, inStream, contentTypeString, fileCacheEnable, attachmentRepoDir, fileThreshold, 0);
    }

    public Attachments(InputStream inStream, String contentTypeString, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold, int contentLength) throws OMException {
        this(null, inStream, contentTypeString, fileCacheEnable, attachmentRepoDir, fileThreshold, contentLength);
    }

    public Attachments(InputStream inStream, String contentTypeString) throws OMException {
        this(null, inStream, contentTypeString, false, null, null);
    }

    public Attachments() {
        this.attachmentsMap = new TreeMap();
        this.noStreams = true;
    }

    public String getAttachmentSpecType() {
        if (this.applicationType == null) {
            this.applicationType = this.contentType.getParameter("type");
            if ("application/xop+xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "application/xop+xml";
            } else if ("text/xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "text/xml";
            } else if ("application/soap+xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "application/soap+xml";
            } else {
                throw new OMException("Invalid Application type. Support available for MTOM & SwA only.");
            }
        }
        return this.applicationType;
    }

    public DataHandler getDataHandler(String blobContentID) {
        if (this.attachmentsMap.containsKey(blobContentID)) {
            DataHandler dataHandler = (DataHandler)this.attachmentsMap.get(blobContentID);
            return dataHandler;
        }
        if (!this.noStreams) {
            DataHandler dataHandler;
            while ((dataHandler = this.getNextPartDataHandler()) != null) {
                if (!this.attachmentsMap.containsKey(blobContentID)) continue;
                dataHandler = (DataHandler)this.attachmentsMap.get(blobContentID);
                return dataHandler;
            }
        }
        return null;
    }

    public void addDataHandler(String contentID, DataHandler dataHandler) {
        this.attachmentsMap.put(contentID, dataHandler);
        if (!this.cids.contains(contentID)) {
            this.cids.add(contentID);
        }
    }

    public void removeDataHandler(String blobContentID) {
        if (this.attachmentsMap.containsKey(blobContentID)) {
            this.attachmentsMap.remove(blobContentID);
        } else if (!this.noStreams) {
            while (this.getNextPartDataHandler() != null) {
                if (!this.attachmentsMap.containsKey(blobContentID)) continue;
                this.attachmentsMap.remove(blobContentID);
            }
        }
        if (this.cids.contains(blobContentID)) {
            this.cids.remove(blobContentID);
        }
    }

    public InputStream getSOAPPartInputStream() throws OMException {
        if (this.noStreams) {
            throw new OMException("Invalid operation. Attachments are created programatically.");
        }
        try {
            DataHandler dh = this.getDataHandler(this.getSOAPPartContentID());
            if (dh == null) {
                throw new OMException("Mandatory Root MIME part containing the SOAP Envelope is missing");
            }
            return dh.getInputStream();
        }
        catch (IOException e) {
            throw new OMException("Problem with DataHandler of the Root Mime Part. ", e);
        }
    }

    public String getSOAPPartContentID() {
        if (this.contentType == null) {
            return null;
        }
        String rootContentID = this.contentType.getParameter("start");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSOAPPartContentID rootContentID=" + rootContentID));
        }
        if (rootContentID == null) {
            if (this.partIndex == 0) {
                this.getNextPartDataHandler();
            }
            rootContentID = this.firstPartId;
        } else if ((rootContentID = rootContentID.trim()).indexOf("<") > -1 & rootContentID.indexOf(">") > -1) {
            rootContentID = rootContentID.substring(1, rootContentID.length() - 1);
        }
        if (rootContentID.length() > 4 && "cid:".equalsIgnoreCase(rootContentID.substring(0, 4))) {
            rootContentID = rootContentID.substring(4);
        }
        return rootContentID;
    }

    public String getSOAPPartContentType() {
        if (!this.noStreams) {
            DataHandler soapPart = this.getDataHandler(this.getSOAPPartContentID());
            return soapPart.getContentType();
        }
        throw new OMException("The attachments map was created programatically. Unsupported operation.");
    }

    public IncomingAttachmentStreams getIncomingAttachmentStreams() throws IllegalStateException {
        if (this.partsRequested) {
            throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
        }
        if (this.noStreams) {
            throw new IllegalStateException("The attachments map was created programatically. No streams are available.");
        }
        this.streamsRequested = true;
        if (this.streams == null) {
            BoundaryDelimitedStream boundaryDelimitedStream = new BoundaryDelimitedStream(this.pushbackInStream, this.boundary, 1024);
            this.streams = new MultipartAttachmentStreams(boundaryDelimitedStream);
        }
        return this.streams;
    }

    private void fetchAllParts() {
        DataHandler dataHandler;
        while (!this.noStreams && (dataHandler = this.getNextPartDataHandler()) != null) {
        }
    }

    public String[] getAllContentIDs() {
        this.fetchAllParts();
        return this.cids.toArray(new String[this.cids.size()]);
    }

    public Set getContentIDSet() {
        this.fetchAllParts();
        return this.attachmentsMap.keySet();
    }

    public Map getMap() {
        this.fetchAllParts();
        return Collections.unmodifiableMap(this.attachmentsMap);
    }

    public List getContentIDList() {
        return this.cids;
    }

    public long getContentLength() throws IOException {
        if (this.contentLength > 0) {
            return this.contentLength;
        }
        if (this.filterIS != null) {
            this.getContentIDSet();
            return this.filterIS.length();
        }
        return -1L;
    }

    protected void setEndOfStream(boolean value) {
        this.endOfStreamReached = value;
    }

    public InputStream getIncomingAttachmentsAsSingleStream() throws IllegalStateException {
        if (this.partsRequested) {
            throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
        }
        if (this.noStreams) {
            throw new IllegalStateException("The attachments map was created programatically. No streams are available.");
        }
        this.streamsRequested = true;
        return this.pushbackInStream;
    }

    private DataHandler getNextPartDataHandler() throws OMException {
        if (this.endOfStreamReached) {
            return null;
        }
        Part nextPart = this.getPart();
        if (nextPart == null) {
            return null;
        }
        long size = nextPart.getSize();
        try {
            String partContentID = nextPart.getContentID();
            if (partContentID == null & this.partIndex == 1) {
                String id;
                this.firstPartId = id = "firstPart_" + UIDGenerator.generateContentId();
                DataHandler dataHandler = size > 0L ? nextPart.getDataHandler() : new DataHandler((DataSource)new ByteArrayDataSource(new byte[0]));
                this.addDataHandler(id, dataHandler);
                return dataHandler;
            }
            if (partContentID == null) {
                throw new OMException("Part content ID cannot be blank for non root MIME parts");
            }
            if (partContentID.indexOf("<") > -1 & partContentID.indexOf(">") > -1) {
                partContentID = partContentID.substring(1, partContentID.length() - 1);
            }
            if (this.partIndex == 1) {
                this.firstPartId = partContentID;
            }
            if (this.attachmentsMap.containsKey(partContentID)) {
                throw new OMException("Two MIME parts with the same Content-ID not allowed.");
            }
            DataHandler dataHandler = size > 0L ? nextPart.getDataHandler() : new DataHandler((DataSource)new ByteArrayDataSource(new byte[0]));
            this.addDataHandler(partContentID, dataHandler);
            return dataHandler;
        }
        catch (MessagingException e) {
            try {
                throw new OMException("Error reading Content-ID from the Part." + (Object)((Object)e));
            }
            catch (MessagingException e2) {
                throw new OMException(e2);
            }
        }
    }

    private Part getPart() throws OMException {
        if (this.streamsRequested) {
            throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
        }
        this.partsRequested = true;
        boolean isSOAPPart = this.partIndex == 0;
        int threshhold = this.fileCacheEnable ? this.fileStorageThreshold : 0;
        MIMEBodyPartInputStream partStream = new MIMEBodyPartInputStream(this.pushbackInStream, this.boundary, this, this.PUSHBACK_SIZE);
        Part part = PartFactory.createPart(this.getLifecycleManager(), partStream, isSOAPPart, threshhold, this.attachmentRepoDir, this.contentLength);
        ++this.partIndex;
        return part;
    }

    private static int readToBuffer(InputStream is, byte[] buffer) throws IOException {
        int index = 0;
        int remainder = buffer.length;
        while (true) {
            int bytesRead;
            if ((bytesRead = is.read(buffer, index, remainder)) > 0) {
                index += bytesRead;
                remainder -= bytesRead;
                continue;
            }
            if (remainder <= 0 || is.available() <= 0) break;
        }
        return index;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

