library('getopt')

spec <- matrix(c(
'help',           'h', 0, "logical",
'normal',         'n', 1, "character",
'tumor',          't', 1, "character",
'vcf',            'v', 1, "character",
'genome',         'g', 1, "character",
'gcgene',         'c', 1, "character",
'segfile',        'f', 1, "character",
'snpblacklist',   's', 1, "character",
'statsfile',      'a', 1, "character",
'targetweightfile', 'e', 1, "character",
'normaldb',       'd', 1, "character",
'outdir',         'o', 1, "character",
'sampleid',       'i', 1, "character"
), byrow=TRUE, ncol=4)
opt <- getopt(spec)

if ( !is.null(opt$help) ) {
    cat(getopt(spec, usage=TRUE))
    q(status=1)
}

normal.coverage.file <- opt$normal
tumor.coverage.file <- opt$tumor
tumor.vcf <- opt$vcf
genome <- opt$genome
gc.gene.file <- opt$gcgene
snp.blacklist <- opt$snpblacklist
stats.file <- opt$statsfile
seg.file <- opt$segfile
target.weight.file <- opt$targetweightfile
normalDB <- opt$normaldb
sampleid <- opt$sampleid
outdir <- opt$outdir

PureCN <- function(
tumor.coverage.file, normal.coverage.file=NULL, tumor.vcf, genome,
gc.gene.file=NULL, seg.file=NULL, snp.blacklist=NULL, stats.file=NULL,
target.weight.file=NULL, normalDB=NULL, sampleid, outdir) {

    file.rds <- paste(outdir,"/",  sampleid, '_abs.rds', sep='')

    if (!is.null(normalDB)) {
        message("normalDB: ", normalDB)
        normalDB <- readRDS(normalDB)
        if (is.null(normal.coverage.file)) {
            normal.coverage.file <- findBestNormal(tumor.coverage.file, normalDB)
        }
    } else if (is.null(normal.coverage.file) && is.null(seg.file)) {
        stop("Need either normalDB or normal.coverage.file")
    }    
    message(paste('Best Normal:', normal.coverage.file))
    pdf(paste(outdir,"/", sampleid, '_abs_segmentation.pdf', sep=''), 
        width=10, height=12)

    ret <- runAbsoluteCN(normal.coverage.file=normal.coverage.file, 
            tumor.coverage.file=tumor.coverage.file, vcf.file=tumor.vcf,
            sampleid=sampleid, gc.gene.file=gc.gene.file, plot.cnv=TRUE,
            genome=genome, seg.file=seg.file,
            args.filterVcf=list(snp.blacklist=snp.blacklist, 
                stats.file=stats.file), 
            args.segmentation=list(target.weight.file=target.weight.file), 
            args.filterTargets=list(normalDB=normalDB),
            post.optimize=FALSE)
    dev.off()

    save(ret, file=paste(outdir,"/", sampleid, '_abs.rda', sep=''))
    saveRDS(ret, file=file.rds)
    createCurationFile(file.rds)
    pdf(paste(outdir,"/",sampleid, '_abs.pdf', sep=''), width=10, height=12)
    plotAbs(ret, type='all')
    dev.off()
}


outdir <- normalizePath(outdir, mustWork=TRUE)

if (is.null(seg.file)) {
    tumor.coverage.file <- normalizePath(tumor.coverage.file, mustWork=TRUE)
}

if (is.null(sampleid)) stop("Need sampleid.")

library(PureCN)

PureCN(tumor.coverage.file, normal.coverage.file, tumor.vcf, genome,
gc.gene.file, seg.file=seg.file, snp.blacklist=snp.blacklist, 
stats.file=stats.file, target.weight.file=target.weight.file, 
normalDB=normalDB, sampleid=sampleid, outdir=outdir) 

