## ----style, echo = FALSE, results = 'asis', message=FALSE----------------
BiocStyle::markdown()

## ----env, echo=FALSE, message=FALSE, warning=FALSE-----------------------
library("Pbase")

## ----pplot, echo=FALSE, fig.width=8.5, fig.height=8.5--------------------
Pbase:::pplot()

## ----fa, cache=TRUE------------------------------------------------------
library("Biostrings")
fafile <- system.file("extdata/HUMAN_2015_02_selected.fasta",
                      package = "Pbase")
fa <- readAAStringSet(fafile)
fa

## ----psm, cache=TRUE-----------------------------------------------------
library("mzID")
idfile <- system.file("extdata/Thermo_Hela_PRTC_selected.mzid",
                      package = "Pbase")
id <- flatten(mzID(idfile))
dim(id)
head(id)

## ----p, cache=TRUE-------------------------------------------------------
library("Pbase")
p <- Proteins(fafile)
p <- addIdentificationData(p, idfile)
p

## ----paccess-------------------------------------------------------------
aa(p)
pranges(p)
pfeatures(p)

## ----metadata------------------------------------------------------------
metadata(p)
head(acols(p))
head(pcols(p))

## ----plot, fig.align='center', cache=TRUE--------------------------------
seqnames(p)
plot(p[c(1,9)])

## ----si------------------------------------------------------------------
sessionInfo()

