/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.protein_inference.proteintree;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.Protein;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.TagFactory;
import com.compomics.util.experiment.identification.protein_inference.proteintree.Node;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTreeComponentsFactory;
import com.compomics.util.experiment.identification.tags.Tag;
import com.compomics.util.experiment.identification.tags.TagComponent;
import com.compomics.util.experiment.identification.tags.matchers.TagMatcher;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ProteinTree {
    private int memoryAllocation;
    private static final long cacheScale = 10000L;
    private SequenceFactory sequenceFactory = SequenceFactory.getInstance();
    private HashMap<String, Node> tree = new HashMap();
    private ArrayDeque<String> tagsInTree = new ArrayDeque();
    private long treeSize = 0L;
    private boolean debugSpeed = false;
    private boolean debugPassages = false;
    private BufferedWriter debugSpeedWriter = null;
    private ProteinTreeComponentsFactory componentsFactory = null;
    private int cacheSize = 100;
    private boolean useCache = true;
    private HashMap<String, HashMap<String, HashMap<String, ArrayList<Integer>>>> lastQueriedPeptidesCache;
    private ArrayDeque<String> lastQueriedPeptidesCacheContent = new ArrayDeque(this.cacheSize);
    private int queryTimeThreshold = 50;
    private HashMap<String, HashMap<String, HashMap<String, ArrayList<Integer>>>> lastSlowQueriedPeptidesCache;
    private ArrayDeque<String> lastSlowQueriedPeptidesCacheContent = new ArrayDeque(this.cacheSize);
    public static final String version = "1.1.0";
    private SequenceMatchingPreferences cacheSequenceMatchingPreferences = null;
    private boolean listening = true;
    public static final int proteinBatchSize = 100;
    private HashMap<String, Integer> proteinLengthsCache = new HashMap();

    public ProteinTree(int memoryAllocation, int cacheSize) throws IOException {
        this.memoryAllocation = memoryAllocation;
        this.cacheSize = cacheSize;
        this.lastSlowQueriedPeptidesCache = new HashMap(cacheSize);
        this.lastQueriedPeptidesCache = new HashMap(cacheSize);
        if (this.debugSpeed) {
            try {
                this.debugSpeedWriter = new BufferedWriter(new FileWriter(new File("treeSpeed.txt")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getMemoryAllocation() {
        return this.memoryAllocation;
    }

    public void setMemoryAllocation(int memoryAllocation) {
        this.memoryAllocation = memoryAllocation;
    }

    public void initiateTree(int initialTagSize, int maxNodeSize, int maxPeptideSize, WaitingHandler waitingHandler, boolean printExpectedImportTime, boolean displayProgress, int nThreads) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        this.initiateTree(initialTagSize, maxNodeSize, maxPeptideSize, null, waitingHandler, printExpectedImportTime, displayProgress, nThreads);
    }

    public void initiateTree(int initialTagSize, int maxNodeSize, int maxPeptideSize, Enzyme enzyme, WaitingHandler waitingHandler, boolean printExpectedImportTime, boolean displayProgress, int nThreads) throws IOException, IllegalArgumentException, InterruptedException, IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        block19: {
            try {
                ProteinTreeComponentsFactory.deletOutdatedTrees();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.tree.clear();
            this.componentsFactory = ProteinTreeComponentsFactory.getInstance();
            try {
                boolean needImport;
                try {
                    boolean bl = needImport = !this.componentsFactory.initiate();
                    if (!needImport) {
                        this.componentsFactory.loadParameters();
                        if (this.componentsFactory.isCorrupted()) {
                            throw new IllegalArgumentException("Database is corrupted. Tree will be reindexed.");
                        }
                        if (!this.componentsFactory.importComplete()) {
                            throw new IllegalArgumentException("Database import was not successfully completed. Tree will be reindexed.");
                        }
                        String tempVersion = this.componentsFactory.getVersion();
                        if (tempVersion == null || !tempVersion.equals(version)) {
                            throw new IllegalArgumentException("Database version " + tempVersion + " obsolete. Tree will be reindexed.");
                        }
                        if (initialTagSize != this.componentsFactory.getInitialSize()) {
                            throw new IllegalArgumentException("Different initial size. Tree will be reindexed.");
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    needImport = true;
                    this.componentsFactory.delete();
                    this.componentsFactory.initiate();
                }
                if (needImport) {
                    this.importDb(initialTagSize, maxNodeSize, maxPeptideSize, enzyme, waitingHandler, printExpectedImportTime, displayProgress, nThreads);
                }
            }
            catch (IOException e) {
                this.componentsFactory.delete();
                throw e;
            }
            catch (IllegalArgumentException e) {
                this.componentsFactory.delete();
                throw e;
            }
            catch (InterruptedException e) {
                this.componentsFactory.delete();
                throw e;
            }
            catch (ClassNotFoundException e) {
                this.componentsFactory.delete();
                throw e;
            }
            catch (SQLException e) {
                this.componentsFactory.delete();
                throw e;
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                return;
            }
            try {
                this.componentsFactory.loadTags();
            }
            catch (Exception e) {
                if (waitingHandler != null && waitingHandler.isRunCanceled()) break block19;
                e.printStackTrace();
            }
        }
    }

    public boolean deleteDb() {
        try {
            return this.componentsFactory.delete();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void importDb(int initialTagSize, int maxNodeSize, int maxPeptideSize, Enzyme enzyme, WaitingHandler waitingHandler, boolean printExpectedImportTime, boolean displayProgress, int nThreads) throws IOException, IllegalArgumentException, InterruptedException, IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        int nTags;
        if (printExpectedImportTime) {
            int nSeconds = this.getExpectedImportTime();
            String report = "Estimated import time: ";
            if (nSeconds < 120) {
                report = report + nSeconds + " seconds.";
            } else {
                int nMinutes = nSeconds / 60;
                if (nMinutes < 120) {
                    report = report + nMinutes + " minutes.";
                } else {
                    int nHours = nMinutes / 60;
                    report = report + nHours + " hours.";
                }
            }
            if (waitingHandler != null && waitingHandler.isReport()) {
                waitingHandler.appendReport(report, true, true);
                waitingHandler.appendReport("    See http://code.google.com/p/compomics-utilities/wiki/ProteinInference.", true, true);
            } else {
                System.out.println(report);
                System.out.println("    See http://code.google.com/p/compomics-utilities/wiki/ProteinInference.");
            }
        }
        this.componentsFactory.saveInitialSize(initialTagSize);
        ArrayList<String> tags = TagFactory.getAminoAcidCombinations(initialTagSize);
        int nAccessions = this.sequenceFactory.isDefaultReversed() ? this.sequenceFactory.getNTargetSequences() : this.sequenceFactory.getNSequences();
        long tagsSize = 500L;
        long criticalSize = tagsSize * (long)nAccessions;
        long capacity = (long)this.memoryAllocation * 10000L;
        long estimatedTreeSize = 6L * criticalSize;
        int ratio = (int)(estimatedTreeSize / capacity);
        if (ratio == 0) {
            ratio = 1;
        }
        int nPassages = ratio;
        if (tags.size() % ratio != 0) {
            ++nPassages;
        }
        if (ratio > 0) {
            nTags = tags.size() / ratio;
            if (nTags == 0) {
                nTags = 1;
            }
        } else {
            nTags = tags.size();
        }
        if (nPassages > 1) {
            // empty if block
        }
        if (this.debugPassages) {
            System.out.println("Estimated tree size: " + estimatedTreeSize);
            System.out.println(new Date() + " " + nPassages + " passages needed (" + nTags + " tags of " + tags.size() + " per passage)");
        }
        if (this.debugSpeed) {
            this.debugSpeedWriter.write("Critical size: " + criticalSize);
            System.out.println("Critical size: " + criticalSize);
            this.debugSpeedWriter.write("Estimated tree size: " + (estimatedTreeSize /= 100L));
            this.debugSpeedWriter.write(new Date() + " " + nPassages + " passages needed (" + nTags + " tags of " + tags.size() + " per passage)");
            this.debugSpeedWriter.newLine();
            this.debugSpeedWriter.flush();
        }
        if (waitingHandler != null && displayProgress && !waitingHandler.isRunCanceled()) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            int totalProgress = nPassages * nAccessions + tags.size() * 2;
            waitingHandler.setMaxSecondaryProgressCounter(totalProgress);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return;
        }
        long time0 = System.currentTimeMillis();
        ArrayList<String> tempTags = new ArrayList<String>(nTags);
        int tagsLoaded = 0;
        boolean first = true;
        for (String tag : tags) {
            if (tempTags.size() == nTags) {
                this.loadTags(tempTags, initialTagSize, maxNodeSize, maxPeptideSize, enzyme, nThreads, waitingHandler, displayProgress);
                if (first) {
                    first = false;
                }
                tagsLoaded += tempTags.size();
                tempTags.clear();
                if (this.debugSpeed) {
                    this.debugSpeedWriter.write(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                    System.out.println(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                    this.debugSpeedWriter.newLine();
                    this.debugSpeedWriter.flush();
                }
            }
            tempTags.add(tag);
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            return;
        }
        if (!tempTags.isEmpty()) {
            this.loadTags(tempTags, initialTagSize, maxNodeSize, maxPeptideSize, enzyme, nThreads, waitingHandler, displayProgress);
            if (this.debugSpeed) {
                this.debugSpeedWriter.write(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                System.out.println(new Date() + " " + tagsLoaded + " tags of " + tags.size() + " loaded.");
                this.debugSpeedWriter.newLine();
                this.debugSpeedWriter.flush();
            }
        }
        this.tagsInTree.addAll(this.tree.keySet());
        for (Node node : this.tree.values()) {
            this.treeSize += node.getSize();
        }
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return;
        }
        this.componentsFactory.setVersion(version);
        this.componentsFactory.setFastaFilePath(this.sequenceFactory.getCurrentFastaFile().getAbsolutePath());
        this.componentsFactory.setImportComplete(true);
        long time1 = System.currentTimeMillis();
        long initiationTime = time1 - time0;
        if (this.sequenceFactory.getNSequences() > 1000) {
            UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
            utilitiesUserPreferences.addProteinTreeImportTime(this.sequenceFactory.getCurrentFastaFile().length(), initiationTime);
            UtilitiesUserPreferences.saveUserPreferences(utilitiesUserPreferences);
        }
        if (this.debugSpeed) {
            this.debugSpeedWriter.write("tree initiation: " + initiationTime + " ms.");
            System.out.println("tree initiation: " + initiationTime + " ms.");
            this.debugSpeedWriter.newLine();
            this.debugSpeedWriter.flush();
        }
    }

    private int getExpectedImportTime() {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        HashMap<Long, ArrayList<Long>> importTimeMap = utilitiesUserPreferences.getProteinTreeImportTime();
        if (importTimeMap.isEmpty()) {
            return this.sequenceFactory.getNTargetSequences() * 16 / 1000;
        }
        ArrayList<Double> ratios = new ArrayList<Double>();
        for (Long size : importTimeMap.keySet()) {
            for (Long time : importTimeMap.get(size)) {
                double ratio = size / time;
                ratios.add(ratio);
            }
        }
        double ratio = BasicMathFunctions.percentile(ratios, 0.05);
        int timeInSeconds = (int)(1.2 * (double)this.sequenceFactory.getCurrentFastaFile().length() / (1000.0 * ratio));
        timeInSeconds = Math.max(timeInSeconds, 1);
        return timeInSeconds;
    }

    private synchronized void loadTags(ArrayList<String> tags, int initialTagSize, int maxNodeSize, int maxPeptideSize, Enzyme enzyme, int nThreads, WaitingHandler waitingHandler, boolean displayProgress) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        if (nThreads == 1) {
            this.indexProteinsSingleThread(tags, initialTagSize, enzyme, waitingHandler, displayProgress);
        } else {
            this.indexProteins(tags, initialTagSize, enzyme, waitingHandler, displayProgress, nThreads);
        }
        if (nThreads == 1) {
            this.processRawNodesSingleThread(tags, maxNodeSize, maxPeptideSize, waitingHandler, displayProgress);
        } else {
            this.processRawNodes(maxNodeSize, maxPeptideSize, waitingHandler, displayProgress, nThreads);
        }
        this.tree.clear();
        System.gc();
    }

    private void indexProteinsSingleThread(ArrayList<String> tags, int initialTagSize, Enzyme enzyme, WaitingHandler waitingHandler, boolean displayProgress) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        SequenceFactory.ProteinIterator proteinIterator = this.sequenceFactory.getProteinIterator(this.sequenceFactory.isDefaultReversed());
        while (proteinIterator.hasNext()) {
            Protein protein = proteinIterator.getNextProtein();
            String accession = protein.getAccession();
            if (protein.getLength() <= 0) continue;
            HashMap<String, ArrayList<Integer>> indexesMap = this.getTagToIndexesMap(protein.getSequence(), tags, enzyme, waitingHandler);
            for (String tag : indexesMap.keySet()) {
                ArrayList<Integer> indexes = indexesMap.get(tag);
                if (!indexes.isEmpty()) {
                    Node node = this.tree.get(tag);
                    if (node == null) {
                        node = new Node(initialTagSize);
                        this.tree.put(tag, node);
                    }
                    node.addAccession(accession, indexes);
                }
                if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
                break;
            }
            if (displayProgress && waitingHandler != null) {
                waitingHandler.increaseSecondaryProgressCounter();
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled()) continue;
            this.tree.clear();
            return;
        }
    }

    private void indexProteins(ArrayList<String> tags, int initialTagSize, Enzyme enzyme, WaitingHandler waitingHandler, boolean displayProgress, int nThreads) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        ArrayList<Protein> sequenceBuffer = new ArrayList<Protein>(100);
        ArrayList<SequenceIndexer> sequenceIndexers = new ArrayList<SequenceIndexer>(nThreads);
        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
        SequenceFactory.ProteinIterator proteinIterator = this.sequenceFactory.getProteinIterator(this.sequenceFactory.isDefaultReversed());
        while (proteinIterator.hasNext()) {
            Protein protein = proteinIterator.getNextProtein();
            sequenceBuffer.add(protein);
            if (sequenceBuffer.size() == 100) {
                while (sequenceIndexers.size() == nThreads) {
                    this.processFinishedIndexers(sequenceIndexers, initialTagSize);
                }
                SequenceIndexer sequenceIndexer = new SequenceIndexer(sequenceBuffer, tags, enzyme, waitingHandler, displayProgress);
                pool.submit(new Thread((Runnable)sequenceIndexer, "sequence indexing"));
                sequenceBuffer = new ArrayList(100);
                sequenceIndexers.add(sequenceIndexer);
            }
            if (waitingHandler == null || !waitingHandler.isRunCanceled() && !waitingHandler.isRunFinished()) continue;
            pool.shutdownNow();
            this.emptyCache();
            return;
        }
        if (!sequenceBuffer.isEmpty()) {
            SequenceIndexer sequenceIndexer = new SequenceIndexer(sequenceBuffer, tags, enzyme, waitingHandler, displayProgress);
            pool.submit(new Thread((Runnable)sequenceIndexer, "sequence indexing"));
            sequenceIndexers.add(sequenceIndexer);
        }
        while (!sequenceIndexers.isEmpty()) {
            this.processFinishedIndexers(sequenceIndexers, initialTagSize);
        }
        pool.shutdown();
    }

    private void processRawNodesSingleThread(ArrayList<String> tags, int maxNodeSize, int maxPeptideSize, WaitingHandler waitingHandler, boolean displayProgress) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        int batchSize = (int)Math.ceil(this.tree.size() / 3);
        batchSize = Math.min(10000, batchSize);
        batchSize = Math.max(1000, batchSize);
        HashMap<String, Object> splittedNodes = new HashMap<String, Object>(batchSize);
        for (String tag : tags) {
            Node node = this.tree.get(tag);
            if (node != null) {
                node.splitNode(maxNodeSize, maxPeptideSize);
                splittedNodes.put(tag, node);
                if (splittedNodes.size() == batchSize) {
                    this.componentsFactory.saveNodes(splittedNodes, waitingHandler);
                    splittedNodes.clear();
                }
            }
            if (waitingHandler == null) continue;
            if (displayProgress) {
                waitingHandler.increaseSecondaryProgressCounter();
                if (node == null) {
                    waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            if (!waitingHandler.isRunCanceled() && !waitingHandler.isRunFinished()) continue;
            this.emptyCache();
            return;
        }
        if (!splittedNodes.isEmpty()) {
            this.componentsFactory.saveNodes(splittedNodes, waitingHandler);
            splittedNodes.clear();
        }
    }

    private void processRawNodes(int maxNodeSize, int maxPeptideSize, WaitingHandler waitingHandler, boolean displayProgress, int nThreads) throws IOException, IllegalArgumentException, InterruptedException, ClassNotFoundException, SQLException {
        ArrayList<NodeSplitter> nodeSplitters = new ArrayList<NodeSplitter>(nThreads);
        ExecutorService pool = Executors.newFixedThreadPool(nThreads);
        for (String tag : this.tree.keySet()) {
            Node node = this.tree.get(tag);
            while (nodeSplitters.size() == nThreads) {
                this.processFinishedNodeSplitters(nodeSplitters, null);
            }
            NodeSplitter nodeSplitter = new NodeSplitter(tag, node, maxNodeSize, maxPeptideSize, waitingHandler, displayProgress);
            pool.submit(new Thread((Runnable)nodeSplitter, "Node splitting of tag " + tag));
            nodeSplitters.add(nodeSplitter);
            if (waitingHandler == null || !waitingHandler.isRunCanceled() && !waitingHandler.isRunFinished()) continue;
            this.emptyCache();
            pool.shutdownNow();
            return;
        }
        while (!nodeSplitters.isEmpty()) {
            this.processFinishedNodeSplitters(nodeSplitters, null);
        }
        pool.shutdown();
    }

    private synchronized void processFinishedNodeSplitters(ArrayList<NodeSplitter> nodeSplitters, WaitingHandler waitingHandler) throws InterruptedException, SQLException, IOException {
        this.listening = false;
        ArrayList<NodeSplitter> done = new ArrayList<NodeSplitter>();
        for (NodeSplitter nodeSplitter : nodeSplitters) {
            if (!nodeSplitter.isFinished()) continue;
            done.add(nodeSplitter);
        }
        if (done.isEmpty()) {
            this.listening = true;
            this.wait();
            for (NodeSplitter nodeSplitter : nodeSplitters) {
                if (!nodeSplitter.isFinished()) continue;
                done.add(nodeSplitter);
            }
        }
        this.listening = true;
        HashMap<String, Object> splittedNodes = new HashMap<String, Object>(done.size());
        for (NodeSplitter nodeSplitter : done) {
            splittedNodes.put(nodeSplitter.getTag(), nodeSplitter.getNode());
            nodeSplitter.clear();
        }
        this.componentsFactory.saveNodes(splittedNodes, waitingHandler);
        nodeSplitters.removeAll(done);
    }

    private synchronized void processFinishedIndexers(ArrayList<SequenceIndexer> sequenceIndexers, int initialTagSize) throws InterruptedException {
        this.listening = false;
        ArrayList<SequenceIndexer> done = new ArrayList<SequenceIndexer>();
        for (SequenceIndexer sequenceIndexer : sequenceIndexers) {
            if (!sequenceIndexer.isFinished()) continue;
            done.add(sequenceIndexer);
        }
        if (done.isEmpty()) {
            this.listening = true;
            this.wait();
            for (SequenceIndexer sequenceIndexer : sequenceIndexers) {
                if (!sequenceIndexer.isFinished()) continue;
                done.add(sequenceIndexer);
            }
        }
        this.listening = true;
        for (SequenceIndexer sequenceIndexer : done) {
            HashMap<String, HashMap<String, ArrayList<Integer>>> tagToIndexesMap = sequenceIndexer.getIndexes();
            for (String accession : tagToIndexesMap.keySet()) {
                for (String tag : tagToIndexesMap.get(accession).keySet()) {
                    ArrayList<Integer> indexes = tagToIndexesMap.get(accession).get(tag);
                    if (indexes.isEmpty()) continue;
                    Node node = this.tree.get(tag);
                    if (node == null) {
                        node = new Node(initialTagSize);
                        this.tree.put(tag, node);
                    }
                    node.addAccession(accession, indexes);
                }
            }
            sequenceIndexer.clear();
        }
        sequenceIndexers.removeAll(done);
    }

    public HashMap<String, HashMap<String, ArrayList<Integer>>> getProteinMapping(String peptideSequence, SequenceMatchingPreferences proteinInferencePrefeerences) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        long time0 = 0L;
        if (this.debugSpeed) {
            time0 = System.currentTimeMillis();
        }
        HashMap<String, HashMap<String, ArrayList<Integer>>> result = this.getProteinMapping(peptideSequence, proteinInferencePrefeerences, false);
        if (this.debugSpeed) {
            long time1 = System.currentTimeMillis();
            long queryTime = time1 - time0;
            this.debugSpeedWriter.write(peptideSequence + "\t" + result.size() + "\t" + queryTime);
            this.debugSpeedWriter.newLine();
            this.debugSpeedWriter.flush();
        }
        return result;
    }

    private HashMap<String, HashMap<String, ArrayList<Integer>>> getProteinMapping(String peptideSequence, SequenceMatchingPreferences sequenceMatchingPreferences, boolean reversed) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        if (this.useCache && this.cacheSequenceMatchingPreferences != null && !this.cacheSequenceMatchingPreferences.isSameAs(sequenceMatchingPreferences)) {
            this.emptyCache();
            this.cacheSequenceMatchingPreferences = sequenceMatchingPreferences;
        }
        HashMap<String, HashMap<String, ArrayList<Integer>>> result = null;
        if (this.useCache) {
            result = this.lastQueriedPeptidesCache.get(peptideSequence);
        }
        if (result == null) {
            if (this.useCache) {
                result = this.lastSlowQueriedPeptidesCache.get(peptideSequence);
            }
            if (result == null) {
                if (this.sequenceFactory.isDefaultReversed() && this.useCache) {
                    String reversedSequence = SequenceFactory.reverseSequence(peptideSequence);
                    result = this.lastQueriedPeptidesCache.get(reversedSequence);
                    if (result == null) {
                        result = this.lastSlowQueriedPeptidesCache.get(reversedSequence);
                    }
                    if (result != null) {
                        return this.getReversedResults(result);
                    }
                }
                long timeStart = System.currentTimeMillis();
                int initialTagSize = this.componentsFactory.getInitialSize();
                if (peptideSequence.length() < initialTagSize) {
                    throw new IllegalArgumentException("Peptide (" + peptideSequence + ") should be at least of length " + initialTagSize + ".");
                }
                result = new HashMap();
                AminoAcidSequence peptideAminoAcidSequence = new AminoAcidSequence(peptideSequence);
                Double limitX = null;
                if (sequenceMatchingPreferences.hasLimitX()) {
                    limitX = sequenceMatchingPreferences.getLimitX() * (double)peptideSequence.length() / (double)initialTagSize;
                }
                HashSet<String> initialTags = this.getInitialTags(peptideAminoAcidSequence, sequenceMatchingPreferences, limitX);
                for (String tag : initialTags) {
                    Node node = this.getNode(tag);
                    if (node == null) continue;
                    HashMap<String, HashMap<String, ArrayList<Integer>>> tagResults = node.getProteinMapping(peptideAminoAcidSequence, tag, sequenceMatchingPreferences);
                    for (String tagSequence : tagResults.keySet()) {
                        HashMap<String, ArrayList<Integer>> mapping = result.get(tagSequence);
                        HashMap<String, ArrayList<Integer>> tagMapping = tagResults.get(tagSequence);
                        if (mapping == null && !tagMapping.isEmpty()) {
                            result.put(tagSequence, tagMapping);
                            continue;
                        }
                        for (String tagAccession : tagMapping.keySet()) {
                            ArrayList<Integer> indexes = mapping.get(tagAccession);
                            ArrayList<Integer> tagIndexes = tagMapping.get(tagAccession);
                            if (indexes == null) {
                                mapping.put(tagAccession, tagIndexes);
                                continue;
                            }
                            for (int newIndex : tagIndexes) {
                                if (indexes.contains(newIndex)) continue;
                                indexes.add(newIndex);
                            }
                            Collections.sort(indexes);
                        }
                    }
                }
                if (this.sequenceFactory.isDefaultReversed() && !reversed) {
                    HashMap<String, HashMap<String, ArrayList<Integer>>> reversedResult;
                    String reversedSequence = SequenceFactory.reverseSequence(peptideSequence);
                    if (!reversedSequence.equals(peptideSequence)) {
                        reversedResult = this.getProteinMapping(reversedSequence, sequenceMatchingPreferences, true);
                        reversedResult = this.getReversedResults(reversedResult);
                    } else {
                        reversedResult = this.getReversedResults(result);
                    }
                    for (String tempReversedSequence : reversedResult.keySet()) {
                        HashMap<String, ArrayList<Integer>> mapping = result.get(tempReversedSequence);
                        if (mapping != null) {
                            mapping.putAll((Map<String, ArrayList<Integer>>)reversedResult.get(tempReversedSequence));
                            continue;
                        }
                        result.put(tempReversedSequence, reversedResult.get(tempReversedSequence));
                    }
                }
                if (!reversed && this.useCache) {
                    long timeEnd = System.currentTimeMillis();
                    long queryTime = timeEnd - timeStart;
                    this.addToCache(peptideSequence, result, queryTime);
                }
            }
        }
        return result;
    }

    private synchronized void addToCache(String peptideSequence, HashMap<String, HashMap<String, ArrayList<Integer>>> mapping, long queryTime) {
        if (queryTime <= (long)this.queryTimeThreshold) {
            this.lastQueriedPeptidesCache.put(peptideSequence, mapping);
            this.lastQueriedPeptidesCacheContent.add(peptideSequence);
            if (this.lastQueriedPeptidesCacheContent.size() > this.cacheSize) {
                String key = this.lastQueriedPeptidesCacheContent.pollLast();
                this.lastQueriedPeptidesCache.remove(key);
            }
        } else {
            this.lastSlowQueriedPeptidesCache.put(peptideSequence, mapping);
            this.lastSlowQueriedPeptidesCacheContent.add(peptideSequence);
            if (this.lastSlowQueriedPeptidesCacheContent.size() > this.cacheSize) {
                String key = this.lastSlowQueriedPeptidesCacheContent.pollLast();
                this.lastSlowQueriedPeptidesCache.remove(key);
            }
        }
    }

    public HashMap<Peptide, HashMap<String, ArrayList<Integer>>> getProteinMapping(Tag tag, TagMatcher tagMatcher, SequenceMatchingPreferences sequenceMatchingPreferences, Double massTolerance) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        int initialTagSize = this.componentsFactory.getInitialSize();
        AminoAcidPattern longestAminoAcidPattern = null;
        AminoAcidSequence longestAminoAcidSequence = null;
        int componentIndex = -1;
        for (int i = 0; i < tag.getContent().size(); ++i) {
            AminoAcidSequence aminoAcidSequence;
            TagComponent tagComponent = tag.getContent().get(i);
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                if (aminoAcidPattern.length() < initialTagSize || longestAminoAcidPattern != null && aminoAcidPattern.length() <= longestAminoAcidPattern.length() || longestAminoAcidSequence != null && aminoAcidPattern.length() <= longestAminoAcidSequence.length()) continue;
                componentIndex = i;
                longestAminoAcidPattern = aminoAcidPattern;
                longestAminoAcidSequence = null;
                continue;
            }
            if (!(tagComponent instanceof AminoAcidSequence) || (aminoAcidSequence = (AminoAcidSequence)tagComponent).length() < initialTagSize || longestAminoAcidPattern != null && aminoAcidSequence.length() <= longestAminoAcidPattern.length() || longestAminoAcidSequence != null && aminoAcidSequence.length() <= longestAminoAcidSequence.length()) continue;
            componentIndex = i;
            longestAminoAcidSequence = aminoAcidSequence;
            longestAminoAcidPattern = null;
        }
        if (componentIndex == -1) {
            throw new IllegalArgumentException("No amino acid sequence longer than " + initialTagSize + " was found for tag " + tag + ".");
        }
        HashMap<String, HashMap<String, ArrayList<Integer>>> seeds = new HashMap<String, HashMap<String, ArrayList<Integer>>>();
        if (longestAminoAcidPattern != null) {
            for (String peptideSequence : longestAminoAcidPattern.getAllPossibleSequences()) {
                double xShare = (double)Util.getOccurrence(peptideSequence, 'X') / (double)peptideSequence.length();
                if (sequenceMatchingPreferences.hasLimitX() && !(xShare <= sequenceMatchingPreferences.getLimitX())) continue;
                seeds.putAll(this.getProteinMapping(peptideSequence, sequenceMatchingPreferences));
            }
        } else {
            seeds.putAll(this.getProteinMapping(longestAminoAcidSequence.getSequence(), sequenceMatchingPreferences));
        }
        HashMap<Peptide, HashMap<String, ArrayList<Integer>>> results = new HashMap<Peptide, HashMap<String, ArrayList<Integer>>>();
        for (String tagSeed : seeds.keySet()) {
            double xShare = (double)Util.getOccurrence(tagSeed, 'X') / (double)tagSeed.length();
            if (sequenceMatchingPreferences.hasLimitX() && !(xShare <= sequenceMatchingPreferences.getLimitX())) continue;
            for (String accession : ((HashMap)seeds.get(tagSeed)).keySet()) {
                String proteinSequence = this.sequenceFactory.getProtein(accession).getSequence();
                Iterator iterator = ((ArrayList)((HashMap)seeds.get(tagSeed)).get(accession)).iterator();
                while (iterator.hasNext()) {
                    int seedIndex = (Integer)iterator.next();
                    HashMap<Integer, ArrayList<Peptide>> matches = tagMatcher.getPeptideMatches(tag, accession, proteinSequence, seedIndex, componentIndex, massTolerance);
                    for (int aa : matches.keySet()) {
                        for (Peptide peptide : matches.get(aa)) {
                            ArrayList<Integer> peptideIndexes;
                            HashMap<String, ArrayList<Integer>> proteinToIndexMap = results.get(peptide);
                            if (proteinToIndexMap == null) {
                                proteinToIndexMap = new HashMap();
                                results.put(peptide, proteinToIndexMap);
                            }
                            if ((peptideIndexes = proteinToIndexMap.get(accession)) == null) {
                                peptideIndexes = new ArrayList();
                                proteinToIndexMap.put(accession, peptideIndexes);
                            }
                            peptideIndexes.add(aa);
                        }
                    }
                }
            }
        }
        return results;
    }

    private HashSet<String> getInitialTags(AminoAcidSequence aminoAcidSequence, SequenceMatchingPreferences sequenceMatchingPreferences, Double limitX) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        int initialTagSize = this.componentsFactory.getInitialSize();
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < initialTagSize; ++i) {
            AminoAcid aminoAcid = aminoAcidSequence.getAminoAcidAt(i);
            if (result.isEmpty()) {
                String newAa;
                HashSet<Character> mutatedAas;
                Object newTag;
                if (sequenceMatchingPreferences.getSequenceMatchingType() == SequenceMatchingPreferences.MatchingType.string) {
                    HashSet<Character> mutatedAas2;
                    Iterator<Character> originalAa = aminoAcid.singleLetterCode;
                    result.add((String)((Object)originalAa));
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas2 = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(((String)((Object)originalAa)).charAt(0)))) == null) continue;
                    for (Character mutatedAa : mutatedAas2) {
                        String newAa2 = String.valueOf(mutatedAa);
                        result.add(newAa2);
                    }
                    continue;
                }
                for (Object originalAa : (Iterator<Character>)aminoAcid.getSubAminoAcids()) {
                    newTag = String.valueOf((char)originalAa);
                    result.add((String)newTag);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf((char)originalAa))) == null) continue;
                    for (Character mutatedAa : mutatedAas) {
                        newAa = String.valueOf(mutatedAa);
                        result.add(newAa);
                    }
                }
                for (Object combinationAa : (Iterator<Character>)aminoAcid.getCombinations()) {
                    newTag = String.valueOf((char)combinationAa);
                    result.add((String)newTag);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf((char)combinationAa))) == null) continue;
                    for (Character mutatedAa : mutatedAas) {
                        newAa = String.valueOf(mutatedAa);
                        result.add(newAa);
                    }
                }
                if (sequenceMatchingPreferences.getSequenceMatchingType() != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                for (char indistinguishableAa : aminoAcid.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance())) {
                    HashSet<Character> mutatedAas3;
                    String newTag2 = String.valueOf(indistinguishableAa);
                    result.add(newTag2);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas3 = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(indistinguishableAa))) == null) continue;
                    for (Character mutatedAa : mutatedAas3) {
                        String newAa3 = String.valueOf(mutatedAa);
                        result.add(newAa3);
                    }
                }
                continue;
            }
            HashSet<String> newResults = new HashSet<String>();
            for (String sequence : result) {
                HashSet<Character> mutatedAas;
                String newTag;
                if (sequenceMatchingPreferences.getSequenceMatchingType() == SequenceMatchingPreferences.MatchingType.string) {
                    HashSet<Character> mutatedAas4;
                    String originalAa = aminoAcid.singleLetterCode;
                    newResults.add(sequence + aminoAcid.singleLetterCode);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas4 = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(originalAa.charAt(0)))) == null) continue;
                    for (Character mutatedAa : mutatedAas4) {
                        String newAa = String.valueOf(mutatedAa);
                        newResults.add(sequence + newAa);
                    }
                    continue;
                }
                for (char originalAa : aminoAcid.getSubAminoAcids()) {
                    newTag = sequence + originalAa;
                    newResults.add(newTag);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(originalAa))) == null) continue;
                    for (Character mutatedAa : mutatedAas) {
                        newTag = sequence + String.valueOf(mutatedAa);
                        newResults.add(newTag);
                    }
                }
                for (char newAa : aminoAcid.getCombinations()) {
                    newTag = sequence + newAa;
                    newResults.add(newTag);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(newAa))) == null) continue;
                    for (Character mutatedAa : mutatedAas) {
                        newTag = sequence + String.valueOf(mutatedAa);
                        newResults.add(newTag);
                    }
                }
                if (sequenceMatchingPreferences.getSequenceMatchingType() != SequenceMatchingPreferences.MatchingType.indistiguishableAminoAcids) continue;
                Object object = aminoAcid.getIndistinguishableAminoAcids(sequenceMatchingPreferences.getMs2MzTolerance()).iterator();
                while (object.hasNext()) {
                    HashSet<Character> mutatedAas5;
                    char newAa = ((Character)object.next()).charValue();
                    String newTag3 = sequence + newAa;
                    newResults.add(newTag3);
                    if (!sequenceMatchingPreferences.hasMutationMatrix() || (mutatedAas5 = sequenceMatchingPreferences.getMutationMatrix().getMutatedAminoAcids(Character.valueOf(newAa))) == null) continue;
                    for (Character mutatedAa : mutatedAas5) {
                        newTag3 = sequence + String.valueOf(mutatedAa);
                        newResults.add(newTag3);
                    }
                }
            }
            result = newResults;
        }
        if (limitX != null && limitX < 1.0) {
            HashSet<String> filtered = new HashSet<String>();
            for (String sequence : result) {
                double xShare = (double)Util.getOccurrence(sequence, 'X') / (double)sequence.length();
                if (!(xShare <= limitX)) continue;
                filtered.add(sequence);
            }
            result = filtered;
        }
        return result;
    }

    private HashMap<String, HashMap<String, ArrayList<Integer>>> getReversedResults(HashMap<String, HashMap<String, ArrayList<Integer>>> forwardResults) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        HashMap<String, HashMap<String, ArrayList<Integer>>> results = new HashMap<String, HashMap<String, ArrayList<Integer>>>(forwardResults.keySet().size());
        for (String sequence : forwardResults.keySet()) {
            int peptideLength = sequence.length();
            String reversedSequence = SequenceFactory.reverseSequence(sequence);
            HashMap mapping = new HashMap(forwardResults.get(sequence).size());
            for (String accession : forwardResults.get(sequence).keySet()) {
                Integer proteinLength;
                String newAccession;
                if (accession.endsWith(SequenceFactory.getDefaultDecoyAccessionSuffix())) {
                    newAccession = SequenceFactory.getDefaultTargetAccession(accession);
                    proteinLength = this.getProteinLength(newAccession);
                    if (proteinLength == null) {
                        throw new IllegalArgumentException("Length of protein " + newAccession + " not found.");
                    }
                } else {
                    newAccession = SequenceFactory.getDefaultDecoyAccession(accession);
                    proteinLength = this.getProteinLength(accession);
                    if (proteinLength == null) {
                        throw new IllegalArgumentException("Length of protein " + accession + " not found.");
                    }
                }
                ArrayList<Integer> forwardIndexes = forwardResults.get(sequence).get(accession);
                ArrayList<Integer> reversedIndexes = new ArrayList<Integer>(forwardIndexes.size());
                for (int index : forwardIndexes) {
                    int reversedIndex = proteinLength - index - peptideLength;
                    if (reversedIndex < 0 || reversedIndex >= proteinLength) {
                        throw new IllegalArgumentException("Wrong index found for peptide " + reversedSequence + " in protein " + newAccession + ": " + reversedIndex + ".");
                    }
                    reversedIndexes.add(reversedIndex);
                }
                mapping.put(newAccession, reversedIndexes);
            }
            results.put(reversedSequence, mapping);
        }
        return results;
    }

    private Node getNode(String tag) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        Node result = this.tree.get(tag);
        if (result == null) {
            result = this.getNodeSynchronized(tag);
        }
        return result;
    }

    private synchronized Node getNodeSynchronized(String tag) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        Node result = this.tree.get(tag);
        if (result == null && (result = this.componentsFactory.getNode(tag)) != null) {
            long capacity = (long)this.memoryAllocation * 10000L;
            while (this.treeSize > capacity && !this.tagsInTree.isEmpty()) {
                String tempTag = this.tagsInTree.pollLast();
                Node tempNode = this.tree.get(tempTag);
                this.treeSize -= tempNode.getSize();
                this.tree.remove(tempTag);
            }
            this.tree.put(tag, result);
            this.treeSize += result.getSize();
            this.tagsInTree.addFirst(tag);
        }
        return result;
    }

    public void close() throws IOException, SQLException {
        if (this.debugSpeed) {
            try {
                this.debugSpeedWriter.flush();
                this.debugSpeedWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.emptyCache();
        this.componentsFactory.close();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void emptyCache() {
        this.tree.clear();
        this.tagsInTree.clear();
        this.lastQueriedPeptidesCache.clear();
        this.lastQueriedPeptidesCacheContent.clear();
        this.lastSlowQueriedPeptidesCache.clear();
        this.lastSlowQueriedPeptidesCacheContent.clear();
        this.proteinLengthsCache.clear();
    }

    public synchronized void reduceNodeCacheSize(double share) {
        String tempTag;
        Node tempNode;
        double limit = this.tree.size();
        if (limit > 100.0) {
            limit = share * limit;
        }
        int i = 0;
        while ((double)i < limit && (tempNode = this.tree.get(tempTag = this.tagsInTree.pollLast())) != null) {
            this.treeSize -= tempNode.getSize();
            this.tree.remove(tempTag);
            ++i;
        }
    }

    public int getNodesInCache() {
        return this.tree.size();
    }

    public HashMap<String, ArrayList<Integer>> getMatchedPeptideSequences(String peptideSequence, String proteinAccession, SequenceMatchingPreferences sequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        HashMap<String, HashMap<String, ArrayList<Integer>>> mapping = this.getProteinMapping(peptideSequence, sequenceMatchingPreferences);
        HashMap<String, ArrayList<Integer>> result = new HashMap<String, ArrayList<Integer>>();
        for (String peptide : mapping.keySet()) {
            HashMap<String, ArrayList<Integer>> tempMapping = mapping.get(peptide);
            if (!tempMapping.containsKey(proteinAccession)) continue;
            result.put(peptide, tempMapping.get(proteinAccession));
        }
        return result;
    }

    public PeptideIterator getPeptideIterator() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return new PeptideIterator();
    }

    private synchronized void runnableFinished() throws InterruptedException {
        while (!this.listening) {
            this.wait(10L);
        }
        this.notify();
    }

    private HashMap<String, ArrayList<Integer>> getTagToIndexesMap(String sequence, ArrayList<String> tags, Enzyme enzyme, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        HashMap<String, ArrayList<Integer>> tagToIndexesMap = new HashMap<String, ArrayList<Integer>>(tags.size());
        Integer initialTagSize = this.componentsFactory.getInitialSize();
        for (String tag : tags) {
            tagToIndexesMap.put(tag, new ArrayList());
        }
        for (int i = 0; i < sequence.length() - initialTagSize; ++i) {
            if (enzyme == null || i == 0 || enzyme.isCleavageSite(sequence.charAt(i - 1), sequence.charAt(i))) {
                char[] tagValue = new char[initialTagSize.intValue()];
                for (int j = 0; j < initialTagSize; ++j) {
                    char aa;
                    tagValue[j] = aa = sequence.charAt(i + j);
                }
                String tag = new String(tagValue);
                ArrayList<Integer> tempIndexes = tagToIndexesMap.get(tag);
                if (tempIndexes != null) {
                    tempIndexes.add(i);
                }
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) break;
        }
        return tagToIndexesMap;
    }

    public Integer getProteinLength(String accession) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        Integer length = this.proteinLengthsCache.get(accession);
        if (length == null) {
            return this.getProteinLengthSynchronized(accession);
        }
        return length;
    }

    private synchronized Integer getProteinLengthSynchronized(String accession) throws SQLException, ClassNotFoundException, IOException, InterruptedException {
        Integer length = this.proteinLengthsCache.get(accession);
        if (length == null) {
            Protein protein = this.sequenceFactory.getProtein(accession);
            if (protein == null) {
                throw new IllegalArgumentException("Length of protein " + accession + " not found.");
            }
            length = protein.getLength();
            this.proteinLengthsCache.put(accession, length);
        }
        return length;
    }

    public Integer getInitialTagSize() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.componentsFactory.getInitialSize();
    }

    private class NodeSplitter
    implements Runnable {
        private String tag;
        private Node node;
        private int maxNodeSize;
        private int maxPeptideSize;
        private boolean finished = false;
        private WaitingHandler waitingHandler;
        private boolean displayProgress;

        public NodeSplitter(String tag, Node node, int maxNodeSize, int maxPeptideSize, WaitingHandler waitingHandler, boolean displayProgress) {
            this.tag = tag;
            this.node = node;
            this.waitingHandler = waitingHandler;
            this.displayProgress = displayProgress;
        }

        @Override
        public synchronized void run() {
            try {
                this.node.splitNode(this.maxNodeSize, this.maxPeptideSize);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            this.finished = true;
            if (this.displayProgress && this.waitingHandler != null && !this.waitingHandler.isRunCanceled()) {
                this.waitingHandler.increaseSecondaryProgressCounter();
            }
            try {
                ProteinTree.this.runnableFinished();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void clear() {
            this.node = null;
        }

        public String getTag() {
            return this.tag;
        }

        public Node getNode() {
            return this.node;
        }
    }

    private class SequenceIndexer
    implements Runnable {
        private ArrayList<Protein> proteins;
        private boolean finished = false;
        private ArrayList<String> tags;
        private Enzyme enzyme;
        private HashMap<String, HashMap<String, ArrayList<Integer>>> indexes = new HashMap(100);
        private WaitingHandler waitingHandler;
        private boolean displayProgress;

        public SequenceIndexer(ArrayList<Protein> proteins, ArrayList<String> tags, Enzyme enzyme, WaitingHandler waitingHandler, boolean displayProgress) {
            this.proteins = proteins;
            this.tags = tags;
            this.enzyme = enzyme;
            this.waitingHandler = waitingHandler;
            this.displayProgress = displayProgress;
        }

        @Override
        public synchronized void run() {
            try {
                for (Protein protein : this.proteins) {
                    if (this.waitingHandler != null && this.waitingHandler.isRunCanceled()) {
                        return;
                    }
                    this.indexes.put(protein.getAccession(), ProteinTree.this.getTagToIndexesMap(protein.getSequence(), this.tags, this.enzyme, this.waitingHandler));
                    if (this.displayProgress && this.waitingHandler != null && !this.waitingHandler.isRunCanceled()) {
                        this.waitingHandler.increaseSecondaryProgressCounter();
                    }
                    if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) continue;
                    return;
                }
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            this.finished = true;
            try {
                ProteinTree.this.runnableFinished();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        public boolean isFinished() {
            return this.finished;
        }

        public HashMap<String, HashMap<String, ArrayList<Integer>>> getIndexes() {
            return this.indexes;
        }

        public void clear() {
            this.proteins.clear();
            this.tags = null;
            this.indexes.clear();
        }
    }

    public class PeptideIterator
    implements Iterator {
        private Integer initialTagSize;
        private ArrayList<String> tags;
        private Node currentNode = null;
        private Node parentNode = null;
        private String currentSequence = null;
        private ArrayList<Character> aas = null;
        private int i = -1;
        private int j = 0;

        private PeptideIterator() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
            this.initialTagSize = ProteinTree.this.componentsFactory.getInitialSize();
            this.tags = TagFactory.getAminoAcidCombinations(this.initialTagSize);
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.currentNode != null && this.currentNode.getDepth() == this.initialTagSize.intValue() && this.currentNode.getAccessions() != null && this.i < this.tags.size() - 1) {
                    this.parentNode = null;
                    this.aas = null;
                    this.j = 0;
                    this.currentSequence = this.tags.get(++this.i);
                    this.currentNode = ProteinTree.this.getNode(this.currentSequence);
                }
                while (++this.i < this.tags.size() && this.currentNode == null && this.parentNode == null) {
                    this.currentSequence = this.tags.get(this.i);
                    this.currentNode = ProteinTree.this.getNode(this.currentSequence);
                }
                if (this.i < this.tags.size()) {
                    if (this.aas != null) {
                        int parentDepth = this.currentSequence.length() - 1;
                        this.currentSequence = this.currentSequence.substring(0, parentDepth);
                        if (++this.j == this.aas.size()) {
                            if (!this.parentNode.getTermini().isEmpty()) {
                                this.currentNode = null;
                                return true;
                            }
                            ++this.j;
                        }
                        if (this.j == this.aas.size() + 1) {
                            if (parentDepth <= this.initialTagSize) {
                                this.currentSequence = null;
                                this.currentNode = null;
                                this.parentNode = null;
                                this.aas = null;
                                this.j = 0;
                            } else {
                                parentDepth = this.currentSequence.length() - 1;
                                String parentSequence = this.currentSequence.substring(0, parentDepth);
                                char aa = this.currentSequence.charAt(parentDepth);
                                if (parentDepth == this.initialTagSize) {
                                    this.parentNode = ProteinTree.this.getNode(parentSequence);
                                } else {
                                    String tag = parentSequence.substring(0, this.initialTagSize);
                                    this.parentNode = ProteinTree.this.getNode(tag).getSubNode(parentSequence);
                                }
                                this.currentNode = this.parentNode.getSubtree().get(Character.valueOf(aa));
                                this.aas = new ArrayList<Character>(this.parentNode.getSubtree().keySet());
                                Collections.sort(this.aas);
                                this.j = this.aas.indexOf(Character.valueOf(aa));
                            }
                            return this.hasNext();
                        }
                        char aa = this.aas.get(this.j).charValue();
                        this.currentSequence = this.currentSequence + aa;
                        this.currentNode = this.parentNode.getSubtree().get(Character.valueOf(aa));
                    }
                    while (this.currentNode.getAccessions() == null) {
                        this.j = 0;
                        this.aas = new ArrayList<Character>(this.currentNode.getSubtree().keySet());
                        this.parentNode = this.currentNode;
                        if (!this.aas.isEmpty()) {
                            Collections.sort(this.aas);
                            char aa = this.aas.get(this.j).charValue();
                            this.currentSequence = this.currentSequence + aa;
                            this.currentNode = this.currentNode.getSubtree().get(Character.valueOf(aa));
                            continue;
                        }
                        this.currentNode = null;
                        return true;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("An error occurred while iterating the tree. See previous exception.");
            }
        }

        public Object next() {
            return this.currentSequence;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("ProteinTrees are not editable.");
        }

        public HashMap<String, ArrayList<Integer>> getMapping() {
            if (this.currentNode != null) {
                return this.currentNode.getAccessions();
            }
            return this.parentNode.getTermini();
        }
    }
}

