/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence;

import org.biojava3.core.sequence.RNASequence;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.loader.StringProxySequenceReader;
import org.biojava3.core.sequence.template.AbstractSequence;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceReader;
import org.biojava3.core.sequence.template.SequenceView;
import org.biojava3.core.sequence.transcription.Frame;
import org.biojava3.core.sequence.transcription.TranscriptionEngine;
import org.biojava3.core.sequence.views.ComplementSequenceView;
import org.biojava3.core.sequence.views.ReversedSequenceView;

public class DNASequence
extends AbstractSequence<NucleotideCompound> {
    private DNAType dnaType = DNAType.UNKNOWN;

    public DNASequence() {
    }

    public DNASequence(String seqString) {
        super(seqString, DNACompoundSet.getDNACompoundSet());
    }

    public DNASequence(SequenceReader<NucleotideCompound> proxyLoader) {
        super(proxyLoader, DNACompoundSet.getDNACompoundSet());
    }

    public DNASequence(String seqString, CompoundSet<NucleotideCompound> compoundSet) {
        super(seqString, compoundSet);
    }

    public DNASequence(SequenceReader<NucleotideCompound> proxyLoader, CompoundSet<NucleotideCompound> compoundSet) {
        super(proxyLoader, compoundSet);
    }

    public RNASequence getRNASequence() {
        return this.getRNASequence(Frame.getDefaultFrame());
    }

    public RNASequence getRNASequence(TranscriptionEngine engine) {
        return this.getRNASequence(engine, Frame.getDefaultFrame());
    }

    public RNASequence getRNASequence(Frame frame) {
        return this.getRNASequence(TranscriptionEngine.getDefault(), frame);
    }

    public RNASequence getRNASequence(TranscriptionEngine engine, Frame frame) {
        return (RNASequence)engine.getDnaRnaTranslator().createSequence(this, frame);
    }

    public int getGCCount() {
        return SequenceMixin.countGC(this);
    }

    public SequenceView<NucleotideCompound> getReverse() {
        return new ReversedSequenceView<NucleotideCompound>(this);
    }

    public SequenceView<NucleotideCompound> getComplement() {
        return new ComplementSequenceView<NucleotideCompound>(this);
    }

    public SequenceView<NucleotideCompound> getReverseComplement() {
        return this.getInverse();
    }

    public DNAType getDNAType() {
        return this.dnaType;
    }

    public void setDNAType(DNAType dnaType) {
        this.dnaType = dnaType;
    }

    public static void main(String[] args) {
        DNASequence dnaSequence = new DNASequence("ATCG");
        System.out.println(dnaSequence.toString());
        StringProxySequenceReader<NucleotideCompound> sequenceStringProxyLoader = new StringProxySequenceReader<NucleotideCompound>("GCTA", DNACompoundSet.getDNACompoundSet());
        DNASequence dnaSequenceFromProxy = new DNASequence(sequenceStringProxyLoader);
        System.out.println(dnaSequenceFromProxy.toString());
    }

    public static enum DNAType {
        CHROMOSOME,
        MITOCHONDRIAL,
        PLASMID,
        PLASTID,
        UNKNOWN;

    }
}

