## ---- include = FALSE----------------------------------------------------
knitr::opts_chunk$set(eval = FALSE)

## ------------------------------------------------------------------------
#  BiocInstaller::biocLite("LiNk-NY/RTCGAToolbox")
#  BiocInstaller::biocLite("waldronlab/BiocInterfaces")

## ------------------------------------------------------------------------
#  library(MultiAssayExperiment)
#  library(RTCGAToolbox)
#  library(BiocInterfaces)
#  library(readr)

## ------------------------------------------------------------------------
#  ds <- getFirehoseDatasets()[27]
#  rd <- getFirehoseRunningDates()[1]
#  ad <- getFirehoseAnalyzeDates()[1]
#  dd <- "data"

## ------------------------------------------------------------------------
#  newMAEO <- function(ds, rd, ad, dd) {
#    if(!dir.exists(dd)) {
#      dir.create(dd)
#    }
#    for(i in ds) {
#      cn <- tolower(i)
#      fp <- file.path(dd, paste0(cn, ".rds"))
#      if(file.exists(fp)) {
#        co <- readRDS(fp)
#      } else {
#        co <- getFirehoseData(i, runDate = rd, gistic2_Date = ad,
#                              RNAseq_Gene = TRUE,
#                              Clinic = TRUE,
#                              miRNASeq_Gene = TRUE,
#                              RNAseq2_Gene_Norm = TRUE,
#                              CNA_SNP = TRUE,
#                              CNV_SNP = TRUE,
#                              CNA_Seq = TRUE,
#                              CNA_CGH = TRUE,
#                              Methylation = TRUE,
#                              Mutation = TRUE,
#                              mRNA_Array = TRUE,
#                              miRNA_Array = TRUE,
#                              RPPA_Array = TRUE,
#                              RNAseqNorm = "raw_counts",
#                              RNAseq2Norm = "normalized_count",
#                              forceDownload = FALSE,
#                              destdir = "./tmp",
#                              fileSizeLimit = 500000,
#                              getUUIDs = FALSE)
#        saveRDS(co, file = fp, compress = "bzip2")
#      }
#      pd <- Clinical(co)
#      rownames(pd) <- toupper(gsub("\\.", "-", rownames(pd)))
#      pd <- type_convert(pd)
#      targets <- c(slotNames(co)[c(5:16)], "gistica", "gistict")
#      names(targets) <- targets
#      dataList <- lapply(targets, function(x) {try(TCGAextract(co, x))})
#      dataFull <- Filter(function(x){class(x)!="try-error"}, dataList)
#      ExpList <- experiments(dataFull)
#      NewExpList <- TCGAcleanExpList(ExpList, pd)
#      NewMap <- generateMap(NewExpList, pd, TCGAbarcode)
#      MAEO <- MultiAssayExperiment(NewExpList, pd, NewMap)
#      saveRDS(MAEO, file = file.path(dd, paste0(cn, "MAEO.rds")),
#              compress = "bzip2")
#    }
#  }

## ------------------------------------------------------------------------
#  newMAEO(ds, rd, ad, dd)

